/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.common.math;

import java.math.BigInteger;
import java.security.SecureRandom;

public final class FlexiBigInt {
    public BigInteger bigInt;
    public static final FlexiBigInt ZERO = new FlexiBigInt(BigInteger.ZERO);
    public static final FlexiBigInt ONE = FlexiBigInt.valueOf(1L);

    public FlexiBigInt(byte[] val) {
        this.bigInt = new BigInteger(val);
    }

    public FlexiBigInt(String val) {
        this.bigInt = new BigInteger(val);
    }

    public FlexiBigInt(int signum, byte[] magnitude) {
        this.bigInt = new BigInteger(signum, magnitude);
    }

    public FlexiBigInt(String val, int radix) {
        this.bigInt = new BigInteger(val, radix);
    }

    public FlexiBigInt(int numBits, de.flexiprovider.api.SecureRandom flexiRand) {
        JavaSecureRandom javaRand = new JavaSecureRandom(flexiRand);
        this.bigInt = new BigInteger(numBits, javaRand);
    }

    public FlexiBigInt(int bitLength, int certainty, de.flexiprovider.api.SecureRandom flexiRand) {
        JavaSecureRandom javaRand = new JavaSecureRandom(flexiRand);
        this.bigInt = new BigInteger(bitLength, certainty, javaRand);
    }

    public FlexiBigInt(BigInteger bigInt) {
        this.bigInt = bigInt;
    }

    public static FlexiBigInt valueOf(long val) {
        return new FlexiBigInt(BigInteger.valueOf(val));
    }

    public FlexiBigInt add(FlexiBigInt addend) {
        return new FlexiBigInt(this.bigInt.add(addend.bigInt));
    }

    public FlexiBigInt subtract(FlexiBigInt minuend) {
        return new FlexiBigInt(this.bigInt.subtract(minuend.bigInt));
    }

    public FlexiBigInt multiply(FlexiBigInt factor) {
        return new FlexiBigInt(this.bigInt.multiply(factor.bigInt));
    }

    public FlexiBigInt divide(FlexiBigInt divisor) {
        return new FlexiBigInt(this.bigInt.divide(divisor.bigInt));
    }

    public FlexiBigInt[] divideAndRemainder(FlexiBigInt divisor) {
        BigInteger[] dar = this.bigInt.divideAndRemainder(divisor.bigInt);
        return new FlexiBigInt[]{new FlexiBigInt(dar[0]), new FlexiBigInt(dar[1])};
    }

    public FlexiBigInt remainder(FlexiBigInt divisor) {
        return new FlexiBigInt(this.bigInt.remainder(divisor.bigInt));
    }

    public FlexiBigInt pow(int exponent) {
        return new FlexiBigInt(this.bigInt.pow(exponent));
    }

    public FlexiBigInt gcd(FlexiBigInt val) {
        return new FlexiBigInt(this.bigInt.gcd(val.bigInt));
    }

    public FlexiBigInt abs() {
        return new FlexiBigInt(this.bigInt.abs());
    }

    public FlexiBigInt negate() {
        return new FlexiBigInt(this.bigInt.negate());
    }

    public int signum() {
        return this.bigInt.signum();
    }

    public FlexiBigInt mod(FlexiBigInt modulus) {
        return new FlexiBigInt(this.bigInt.mod(modulus.bigInt));
    }

    public FlexiBigInt modPow(FlexiBigInt exponent, FlexiBigInt modulus) {
        return new FlexiBigInt(this.bigInt.modPow(exponent.bigInt, modulus.bigInt));
    }

    public FlexiBigInt modInverse(FlexiBigInt modulus) {
        return new FlexiBigInt(this.bigInt.modInverse(modulus.bigInt));
    }

    public FlexiBigInt shiftLeft(int n) {
        return new FlexiBigInt(this.bigInt.shiftLeft(n));
    }

    public FlexiBigInt shiftRight(int n) {
        return new FlexiBigInt(this.bigInt.shiftRight(n));
    }

    public FlexiBigInt and(FlexiBigInt val) {
        return new FlexiBigInt(this.bigInt.and(val.bigInt));
    }

    public FlexiBigInt or(FlexiBigInt val) {
        return new FlexiBigInt(this.bigInt.or(val.bigInt));
    }

    public FlexiBigInt xor(FlexiBigInt val) {
        return new FlexiBigInt(this.bigInt.xor(val.bigInt));
    }

    public FlexiBigInt not() {
        return new FlexiBigInt(this.bigInt.not());
    }

    public FlexiBigInt andNot(FlexiBigInt val) {
        return new FlexiBigInt(this.bigInt.andNot(val.bigInt));
    }

    public boolean testBit(int n) {
        return this.bigInt.testBit(n);
    }

    public FlexiBigInt setBit(int n) {
        return new FlexiBigInt(this.bigInt.setBit(n));
    }

    public FlexiBigInt clearBit(int n) {
        return new FlexiBigInt(this.bigInt.clearBit(n));
    }

    public FlexiBigInt flipBit(int n) {
        return new FlexiBigInt(this.bigInt.flipBit(n));
    }

    public int getLowestSetBit() {
        return this.bigInt.getLowestSetBit();
    }

    public int bitLength() {
        return this.bigInt.bitLength();
    }

    public int bitCount() {
        return this.bigInt.bitCount();
    }

    public boolean isProbablePrime(int certainty) {
        return this.bigInt.isProbablePrime(certainty);
    }

    public int compareTo(FlexiBigInt other) {
        return this.bigInt.compareTo(other.bigInt);
    }

    public FlexiBigInt min(FlexiBigInt other) {
        return new FlexiBigInt(this.bigInt.min(other.bigInt));
    }

    public FlexiBigInt max(FlexiBigInt other) {
        return new FlexiBigInt(this.bigInt.max(other.bigInt));
    }

    public boolean equals(Object other) {
        if (!(other instanceof FlexiBigInt)) {
            return false;
        }
        return this.bigInt.equals(((FlexiBigInt)other).bigInt);
    }

    public int hashCode() {
        return this.bigInt.hashCode();
    }

    public String toString(int radix) {
        return this.bigInt.toString(radix);
    }

    public String toString() {
        return this.bigInt.toString();
    }

    public byte[] toByteArray() {
        return this.bigInt.toByteArray();
    }

    public int intValue() {
        return this.bigInt.intValue();
    }

    public long longValue() {
        return this.bigInt.longValue();
    }

    public float floatValue() {
        return this.bigInt.floatValue();
    }

    public double doubleValue() {
        return this.bigInt.doubleValue();
    }

    private class JavaSecureRandom
    extends SecureRandom {
        JavaSecureRandom(de.flexiprovider.api.SecureRandom flexiRand) {
            super(flexiRand, null);
        }
    }
}

