/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.common.math;

import de.flexiprovider.api.Registry;
import de.flexiprovider.api.SecureRandom;
import de.flexiprovider.common.exceptions.NoQuadraticResidueException;
import de.flexiprovider.common.math.FlexiBigInt;

public final class IntegerFunctions {
    private static final FlexiBigInt ZERO = FlexiBigInt.ZERO;
    private static final FlexiBigInt ONE = FlexiBigInt.ONE;
    private static final FlexiBigInt TWO = FlexiBigInt.valueOf(2L);
    private static final FlexiBigInt FOUR = FlexiBigInt.valueOf(4L);
    private static final int[] SMALL_PRIMES = new int[]{3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41};
    private static final long SMALL_PRIME_PRODUCT = 152125131763605L;
    private static SecureRandom sr = null;
    private static final int[] jacobiTable = new int[]{0, 1, 0, -1, 0, -1, 0, 1};

    private IntegerFunctions() {
    }

    public static int jacobi(FlexiBigInt A, FlexiBigInt B) {
        long k = 1L;
        k = 1L;
        if (B.equals(ZERO)) {
            FlexiBigInt a = A.abs();
            return a.equals(ONE) ? 1 : 0;
        }
        if (!A.testBit(0) && !B.testBit(0)) {
            return 0;
        }
        FlexiBigInt a = A;
        FlexiBigInt b = B;
        if (b.signum() == -1) {
            b = b.negate();
            if (a.signum() == -1) {
                k = -1L;
            }
        }
        FlexiBigInt v = ZERO;
        while (!b.testBit(0)) {
            v = v.add(ONE);
            b = b.divide(TWO);
        }
        if (v.testBit(0)) {
            k *= (long)jacobiTable[a.intValue() & 7];
        }
        if (a.signum() < 0) {
            if (b.testBit(1)) {
                k = -k;
            }
            a = a.negate();
        }
        while (a.signum() != 0) {
            v = ZERO;
            while (!a.testBit(0)) {
                v = v.add(ONE);
                a = a.divide(TWO);
            }
            if (v.testBit(0)) {
                k *= (long)jacobiTable[b.intValue() & 7];
            }
            if (a.compareTo(b) < 0) {
                FlexiBigInt x = a;
                a = b;
                b = x;
                if (a.testBit(1) && b.testBit(1)) {
                    k = -k;
                }
            }
            a = a.subtract(b);
        }
        return b.equals(ONE) ? (int)k : 0;
    }

    public static FlexiBigInt ressol(FlexiBigInt a, FlexiBigInt p) throws NoQuadraticResidueException {
        FlexiBigInt v = null;
        if (a.compareTo(ZERO) < 0) {
            a = a.add(p);
        }
        if (a.equals(ZERO)) {
            return ZERO;
        }
        if (p.equals(TWO)) {
            return a;
        }
        if (p.testBit(0) && p.testBit(1)) {
            if (IntegerFunctions.jacobi(a, p) == 1) {
                v = p.add(ONE);
                v = v.shiftRight(2);
                return a.modPow(v, p);
            }
            throw new NoQuadraticResidueException(a, p);
        }
        long t = 0L;
        FlexiBigInt k = p.subtract(ONE);
        long s = 0L;
        while (!k.testBit(0)) {
            ++s;
            k = k.shiftRight(1);
        }
        k = k.subtract(ONE);
        k = k.shiftRight(1);
        FlexiBigInt r = a.modPow(k, p);
        FlexiBigInt n = r.multiply(r).remainder(p);
        n = n.multiply(a).remainder(p);
        r = r.multiply(a).remainder(p);
        if (n.equals(ONE)) {
            return r;
        }
        FlexiBigInt z = TWO;
        while (IntegerFunctions.jacobi(z, p) == 1) {
            z = z.add(ONE);
        }
        v = k;
        v = v.multiply(TWO);
        v = v.add(ONE);
        FlexiBigInt c = z.modPow(v, p);
        while (n.compareTo(ONE) == 1) {
            k = n;
            t = s;
            s = 0L;
            while (!k.equals(ONE)) {
                k = k.multiply(k).mod(p);
                ++s;
            }
            if ((t -= s) == 0L) {
                throw new NoQuadraticResidueException(a, p);
            }
            v = ONE;
            long i = 0L;
            while (i < t - 1L) {
                v = v.shiftLeft(1);
                ++i;
            }
            c = c.modPow(v, p);
            r = r.multiply(c).remainder(p);
            c = c.multiply(c).remainder(p);
            n = n.multiply(c).mod(p);
        }
        return r;
    }

    public static int gcd(int u, int v) {
        return FlexiBigInt.valueOf(u).gcd(FlexiBigInt.valueOf(v)).intValue();
    }

    public static int[] extGCD(int a, int b) {
        FlexiBigInt ba = FlexiBigInt.valueOf(a);
        FlexiBigInt bb = FlexiBigInt.valueOf(b);
        FlexiBigInt[] bresult = IntegerFunctions.extgcd(ba, bb);
        int[] result = new int[]{bresult[0].intValue(), bresult[1].intValue(), bresult[2].intValue()};
        return result;
    }

    public static FlexiBigInt divideAndRound(FlexiBigInt a, FlexiBigInt b) {
        if (a.signum() < 0) {
            return IntegerFunctions.divideAndRound(a.negate(), b).negate();
        }
        if (b.signum() < 0) {
            return IntegerFunctions.divideAndRound(a, b.negate()).negate();
        }
        return a.shiftLeft(1).add(b).divide(b.shiftLeft(1));
    }

    public static FlexiBigInt[] divideAndRound(FlexiBigInt[] a, FlexiBigInt b) {
        FlexiBigInt[] out = new FlexiBigInt[a.length];
        int i = 0;
        while (i < a.length) {
            out[i] = IntegerFunctions.divideAndRound(a[i], b);
            ++i;
        }
        return out;
    }

    public static int ceilLog(FlexiBigInt a) {
        int result = 0;
        FlexiBigInt p = FlexiBigInt.ONE;
        while (a.compareTo(p) < 0) {
            ++result;
            p = p.shiftLeft(1);
        }
        return result;
    }

    public static int ceilLog(int a) {
        int log = 0;
        int i = 1;
        while (i < a) {
            i <<= 1;
            ++log;
        }
        return log;
    }

    public static int ceilLog256(int n) {
        if (n == 0) {
            return 1;
        }
        int m = n < 0 ? -n : n;
        int d = 0;
        while (m > 0) {
            ++d;
            m >>>= 8;
        }
        return d;
    }

    public static int floorLog(FlexiBigInt a) {
        int result = -1;
        FlexiBigInt p = FlexiBigInt.ONE;
        while (p.compareTo(a) <= 0) {
            ++result;
            p = p.shiftLeft(1);
        }
        return result;
    }

    public static int floorLog(int a) {
        int h = 0;
        if (a <= 0) {
            return -1;
        }
        int p = a >>> 1;
        while (p > 0) {
            ++h;
            p >>>= 1;
        }
        return h;
    }

    public static int maxPower(int a) {
        int h = 0;
        if (a != 0) {
            int p = 1;
            while ((a & p) == 0) {
                ++h;
                p <<= 1;
            }
        }
        return h;
    }

    public static int bitCount(int a) {
        int h = 0;
        while (a != 0) {
            h += a & 1;
            a >>>= 1;
        }
        return h;
    }

    /*
     * Unable to fully structure code
     */
    public static int order(int g, int p) {
        b = g % p;
        j = 1;
        if (b != 0) ** GOTO lbl9
        throw new IllegalArgumentException(g + " is not an element of Z/(" + p + "Z)^*; it is not meaningful to compute its order.");
lbl-1000:
        // 1 sources

        {
            b *= g;
            if ((b %= p) < 0) {
                b += p;
            }
            ++j;
lbl9:
            // 2 sources

            ** while (b != 1)
        }
lbl10:
        // 1 sources

        return j;
    }

    public static FlexiBigInt reduceInto(FlexiBigInt n, FlexiBigInt begin, FlexiBigInt end) {
        return n.subtract(begin).mod(end.subtract(begin)).add(begin);
    }

    public static int pow(int a, int e) {
        int result = 1;
        while (e > 0) {
            if ((e & 1) == 1) {
                result *= a;
            }
            a *= a;
            e >>>= 1;
        }
        return result;
    }

    public static int modPow(int a, int e, int n) {
        if (n <= 0 || n * n > Integer.MAX_VALUE || e < 0) {
            return 0;
        }
        int result = 1;
        a = (a % n + n) % n;
        while (e > 0) {
            if ((e & 1) == 1) {
                result = result * a % n;
            }
            a = a * a % n;
            e >>>= 1;
        }
        return result;
    }

    public static FlexiBigInt[] extgcd(FlexiBigInt a, FlexiBigInt b) {
        FlexiBigInt u = FlexiBigInt.ONE;
        FlexiBigInt v = FlexiBigInt.ZERO;
        FlexiBigInt d = a;
        if (b.signum() != 0) {
            FlexiBigInt v1 = FlexiBigInt.ZERO;
            FlexiBigInt v3 = b;
            while (v3.signum() != 0) {
                FlexiBigInt[] tmp = d.divideAndRemainder(v3);
                FlexiBigInt q = tmp[0];
                FlexiBigInt t3 = tmp[1];
                FlexiBigInt t1 = u.subtract(q.multiply(v1));
                u = v1;
                d = v3;
                v1 = t1;
                v3 = t3;
            }
            v = d.subtract(a.multiply(u)).divide(b);
        }
        return new FlexiBigInt[]{d, u, v};
    }

    public static int modInverse(int a, int mod) {
        return FlexiBigInt.valueOf(a).modInverse(FlexiBigInt.valueOf(mod)).intValue();
    }

    public static int isPower(int a, int p) {
        if (a <= 0) {
            return -1;
        }
        int n = 0;
        int d = a;
        while (d > 1) {
            if (d % p != 0) {
                return -1;
            }
            d /= p;
            ++n;
        }
        return n;
    }

    public static int leastDiv(int a) {
        if (a < 0) {
            a = -a;
        }
        if (a == 0) {
            return 1;
        }
        if ((a & 1) == 0) {
            return 2;
        }
        int p = 3;
        while (p <= a / p) {
            if (a % p == 0) {
                return p;
            }
            p += 2;
        }
        return a;
    }

    public static boolean isPrime(int n) {
        if (n < 2) {
            return false;
        }
        if (n == 2) {
            return true;
        }
        if ((n & 1) == 0) {
            return false;
        }
        if (n < 42) {
            int i = 0;
            while (i < SMALL_PRIMES.length) {
                if (n == SMALL_PRIMES[i]) {
                    return true;
                }
                ++i;
            }
        }
        if (n % 3 == 0 || n % 5 == 0 || n % 7 == 0 || n % 11 == 0 || n % 13 == 0 || n % 17 == 0 || n % 19 == 0 || n % 23 == 0 || n % 29 == 0 || n % 31 == 0 || n % 37 == 0 || n % 41 == 0) {
            return false;
        }
        return FlexiBigInt.valueOf(n).isProbablePrime(20);
    }

    public static boolean passesSmallPrimeTest(FlexiBigInt candidate) {
        int[] smallPrime = new int[]{2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 53, 59, 61, 67, 71, 73, 79, 83, 89, 97, 101, 103, 107, 109, 113, 127, 131, 137, 139, 149, 151, 157, 163, 167, 173, 179, 181, 191, 193, 197, 199, 211, 223, 227, 229, 233, 239, 241, 251, 257, 263, 269, 271, 277, 281, 283, 293, 307, 311, 313, 317, 331, 337, 347, 349, 353, 359, 367, 373, 379, 383, 389, 397, 401, 409, 419, 421, 431, 433, 439, 443, 449, 457, 461, 463, 467, 479, 487, 491, 499, 503, 509, 521, 523, 541, 547, 557, 563, 569, 571, 577, 587, 593, 599, 601, 607, 613, 617, 619, 631, 641, 643, 647, 653, 659, 661, 673, 677, 683, 691, 701, 709, 719, 727, 733, 739, 743, 751, 757, 761, 769, 773, 787, 797, 809, 811, 821, 823, 827, 829, 839, 853, 857, 859, 863, 877, 881, 883, 887, 907, 911, 919, 929, 937, 941, 947, 953, 967, 971, 977, 983, 991, 997, 1009, 1013, 1019, 1021, 1031, 1033, 1039, 1049, 1051, 1061, 1063, 1069, 1087, 1091, 1093, 1097, 1103, 1109, 1117, 1123, 1129, 1151, 1153, 1163, 1171, 1181, 1187, 1193, 1201, 1213, 1217, 1223, 1229, 1231, 1237, 1249, 1259, 1277, 1279, 1283, 1289, 1291, 1297, 1301, 1303, 1307, 1319, 1321, 1327, 1361, 1367, 1373, 1381, 1399, 1409, 1423, 1427, 1429, 1433, 1439, 1447, 1451, 1453, 1459, 1471, 1481, 1483, 1487, 1489, 1493, 1499};
        int i = 0;
        while (i < smallPrime.length) {
            if (candidate.mod(FlexiBigInt.valueOf(smallPrime[i])).equals(FlexiBigInt.ZERO)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static int nextSmallerPrime(int n) {
        if (n <= 2) {
            return 1;
        }
        if (n == 3) {
            return 2;
        }
        n = (n & 1) == 0 ? --n : (n -= 2);
        while (n > 3 & !IntegerFunctions.isPrime(n)) {
            n -= 2;
        }
        return n;
    }

    public static FlexiBigInt nextProbablePrime(FlexiBigInt n, int certainty) {
        if (n.signum() < 0 || n.signum() == 0 || n.equals(ONE)) {
            return TWO;
        }
        FlexiBigInt result = n.add(ONE);
        if (!result.testBit(0)) {
            result = result.add(ONE);
        }
        while (true) {
            long r;
            if (result.bitLength() > 6 && ((r = result.remainder(FlexiBigInt.valueOf(152125131763605L)).longValue()) % 3L == 0L || r % 5L == 0L || r % 7L == 0L || r % 11L == 0L || r % 13L == 0L || r % 17L == 0L || r % 19L == 0L || r % 23L == 0L || r % 29L == 0L || r % 31L == 0L || r % 37L == 0L || r % 41L == 0L)) {
                result = result.add(TWO);
                continue;
            }
            if (result.bitLength() < 4) {
                return result;
            }
            if (result.isProbablePrime(certainty)) {
                return result;
            }
            result = result.add(TWO);
        }
    }

    public static FlexiBigInt nextProbablePrime(FlexiBigInt n) {
        return IntegerFunctions.nextProbablePrime(n, 20);
    }

    public static FlexiBigInt nextPrime(long n) {
        boolean found = false;
        long result = 0L;
        if (n <= 1L) {
            return FlexiBigInt.valueOf(2L);
        }
        if (n == 2L) {
            return FlexiBigInt.valueOf(3L);
        }
        long i = n + 1L + (n & 1L);
        while (i <= n << 1 && !found) {
            long j = 3L;
            while (j <= i >> 1 && !found) {
                if (i % j == 0L) {
                    found = true;
                }
                j += 2L;
            }
            if (found) {
                found = false;
            } else {
                result = i;
                found = true;
            }
            i += 2L;
        }
        return FlexiBigInt.valueOf(result);
    }

    public static FlexiBigInt binomial(int n, int t) {
        FlexiBigInt result = FlexiBigInt.ONE;
        if (n == 0) {
            if (t == 0) {
                return result;
            }
            return FlexiBigInt.ZERO;
        }
        if (t > n >>> 1) {
            t = n - t;
        }
        int i = 1;
        while (i <= t) {
            result = result.multiply(FlexiBigInt.valueOf(n - (i - 1))).divide(FlexiBigInt.valueOf(i));
            ++i;
        }
        return result;
    }

    public static FlexiBigInt randomize(FlexiBigInt upperBound) {
        if (sr == null) {
            sr = Registry.getSecureRandom();
        }
        return IntegerFunctions.randomize(upperBound, sr);
    }

    public static FlexiBigInt randomize(FlexiBigInt upperBound, SecureRandom prng) {
        int blen = upperBound.bitLength();
        FlexiBigInt randomNum = FlexiBigInt.valueOf(0L);
        if (prng == null) {
            prng = sr != null ? sr : Registry.getSecureRandom();
        }
        int i = 0;
        while (i < 20) {
            randomNum = new FlexiBigInt(blen, prng);
            if (randomNum.compareTo(upperBound) < 0) {
                return randomNum;
            }
            ++i;
        }
        return randomNum.mod(upperBound);
    }

    public static FlexiBigInt squareRoot(FlexiBigInt a) {
        if (a.compareTo(ZERO) < 0) {
            throw new ArithmeticException("cannot extract root of negative number" + a + ".");
        }
        int bl = a.bitLength();
        FlexiBigInt result = ZERO;
        FlexiBigInt remainder = ZERO;
        if ((bl & 1) != 0) {
            result = result.add(ONE);
            --bl;
        }
        while (bl > 0) {
            remainder = remainder.multiply(FOUR);
            remainder = remainder.add(FlexiBigInt.valueOf((a.testBit(--bl) ? 2 : 0) + (a.testBit(--bl) ? 1 : 0)));
            FlexiBigInt b = result.multiply(FOUR).add(ONE);
            result = result.multiply(TWO);
            if (remainder.compareTo(b) == -1) continue;
            result = result.add(ONE);
            remainder = remainder.subtract(b);
        }
        return result;
    }

    public static boolean isIncreasing(int[] a) {
        int i = 1;
        while (i < a.length) {
            if (a[i - 1] >= a[i]) {
                System.out.println("a[" + (i - 1) + "] = " + a[i - 1] + " >= " + a[i] + " = a[" + i + "]");
                return false;
            }
            ++i;
        }
        return true;
    }

    public static byte[] integerToOctets(FlexiBigInt val) {
        byte[] valBytes = val.abs().toByteArray();
        if ((val.bitLength() & 7) != 0) {
            return valBytes;
        }
        byte[] tmp = new byte[val.bitLength() >> 3];
        System.arraycopy(valBytes, 1, tmp, 0, tmp.length);
        return tmp;
    }

    public static FlexiBigInt octetsToInteger(byte[] data, int offset, int length) {
        byte[] val = new byte[length + 1];
        val[0] = 0;
        System.arraycopy(data, offset, val, 1, length);
        return new FlexiBigInt(val);
    }

    public static FlexiBigInt octetsToInteger(byte[] data) {
        return IntegerFunctions.octetsToInteger(data, 0, data.length);
    }
}

