/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.common.math.codingtheory;

import de.flexiprovider.api.SecureRandom;
import de.flexiprovider.common.math.codingtheory.GF2mField;
import de.flexiprovider.common.math.codingtheory.PolynomialGF2mSmallM;
import de.flexiprovider.common.math.linearalgebra.GF2Matrix;
import de.flexiprovider.common.math.linearalgebra.GF2Vector;
import de.flexiprovider.common.math.linearalgebra.Permutation;

public final class GoppaCode {
    private GoppaCode() {
    }

    public static GF2Matrix createCanonicalCheckMatrix(GF2mField field, PolynomialGF2mSmallM gp) {
        int m = field.getDegree();
        int n = 1 << m;
        int t = gp.getDegree();
        int[][] hArray = new int[t][n];
        int[][] yz = new int[t][n];
        int j = 0;
        while (j < n) {
            yz[0][j] = field.inverse(gp.evaluateAt(j));
            ++j;
        }
        int i = 1;
        while (i < t) {
            int j2 = 0;
            while (j2 < n) {
                yz[i][j2] = field.mult(yz[i - 1][j2], j2);
                ++j2;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < t) {
            int j3 = 0;
            while (j3 < n) {
                int k = 0;
                while (k <= i2) {
                    hArray[i2][j3] = field.add(hArray[i2][j3], field.mult(yz[k][j3], gp.getCoefficient(t + k - i2)));
                    ++k;
                }
                ++j3;
            }
            ++i2;
        }
        int[][] result = new int[t * m][n + 31 >>> 5];
        int j4 = 0;
        while (j4 < n) {
            int q = j4 >>> 5;
            int r = 1 << (j4 & 0x1F);
            int i3 = 0;
            while (i3 < t) {
                int e = hArray[i3][j4];
                int u = 0;
                while (u < m) {
                    int b = e >>> u & 1;
                    if (b != 0) {
                        int ind = (i3 + 1) * m - u - 1;
                        int[] nArray = result[ind];
                        int n2 = q;
                        nArray[n2] = nArray[n2] ^ r;
                    }
                    ++u;
                }
                ++i3;
            }
            ++j4;
        }
        return new GF2Matrix(n, result);
    }

    public static MaMaPe computeSystematicForm(GF2Matrix h, SecureRandom sr) {
        GF2Matrix sInv;
        GF2Matrix hp;
        Permutation p;
        int n = h.getNumColumns();
        GF2Matrix s = null;
        boolean found = false;
        do {
            p = new Permutation(n, sr);
            hp = (GF2Matrix)h.rightMultiply(p);
            sInv = hp.getLeftSubMatrix();
            try {
                found = true;
                s = (GF2Matrix)sInv.computeInverse();
            }
            catch (ArithmeticException ae) {
                found = false;
            }
        } while (!found);
        GF2Matrix shp = (GF2Matrix)s.rightMultiply(hp);
        GF2Matrix m = shp.getRightSubMatrix();
        return new MaMaPe(sInv, m, p);
    }

    public static GF2Vector syndromeDecode(GF2Vector syndVec, GF2mField field, PolynomialGF2mSmallM gp, PolynomialGF2mSmallM[] sqRootMatrix) {
        int n = 1 << field.getDegree();
        GF2Vector errors = new GF2Vector(n);
        if (!syndVec.isZero()) {
            PolynomialGF2mSmallM syndrome = new PolynomialGF2mSmallM(syndVec.toExtensionFieldVector(field));
            PolynomialGF2mSmallM t = syndrome.modInverse(gp);
            PolynomialGF2mSmallM tau = t.addMonomial(1);
            tau = tau.modSquareRootMatrix(sqRootMatrix);
            PolynomialGF2mSmallM[] ab = tau.modPolynomialToFracton(gp);
            PolynomialGF2mSmallM a2 = ab[0].multiply(ab[0]);
            PolynomialGF2mSmallM b2 = ab[1].multiply(ab[1]);
            PolynomialGF2mSmallM xb2 = b2.multWithMonomial(1);
            PolynomialGF2mSmallM a2plusXb2 = a2.add(xb2);
            int headCoeff = a2plusXb2.getHeadCoefficient();
            int invHeadCoeff = field.inverse(headCoeff);
            PolynomialGF2mSmallM elp = a2plusXb2.multWithElement(invHeadCoeff);
            int i = 0;
            while (i < n) {
                int z = elp.evaluateAt(i);
                if (z == 0) {
                    errors.setBit(i);
                }
                ++i;
            }
        }
        return errors;
    }

    public static class MatrixSet {
        private GF2Matrix g;
        private int[] setJ;

        public MatrixSet(GF2Matrix g, int[] setJ) {
            this.g = g;
            this.setJ = setJ;
        }

        public GF2Matrix getG() {
            return this.g;
        }

        public int[] getSetJ() {
            return this.setJ;
        }
    }

    public static class MaMaPe {
        private GF2Matrix s;
        private GF2Matrix h;
        private Permutation p;

        public MaMaPe(GF2Matrix s, GF2Matrix h, Permutation p) {
            this.s = s;
            this.h = h;
            this.p = p;
        }

        public GF2Matrix getFirstMatrix() {
            return this.s;
        }

        public GF2Matrix getSecondMatrix() {
            return this.h;
        }

        public Permutation getPermutation() {
            return this.p;
        }
    }
}

