/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.common.math.codingtheory;

import de.flexiprovider.common.math.codingtheory.GF2mField;
import de.flexiprovider.common.math.codingtheory.PolynomialGF2mSmallM;

public class PolynomialRingGF2m {
    private GF2mField field;
    private PolynomialGF2mSmallM p;
    protected PolynomialGF2mSmallM[] sqMatrix;
    protected PolynomialGF2mSmallM[] sqRootMatrix;

    public PolynomialRingGF2m(GF2mField field, PolynomialGF2mSmallM p) {
        this.field = field;
        this.p = p;
        this.computeSquaringMatrix();
        this.computeSquareRootMatrix();
    }

    public PolynomialGF2mSmallM[] getSquaringMatrix() {
        return this.sqMatrix;
    }

    public PolynomialGF2mSmallM[] getSquareRootMatrix() {
        return this.sqRootMatrix;
    }

    private void computeSquaringMatrix() {
        int numColumns = this.p.getDegree();
        this.sqMatrix = new PolynomialGF2mSmallM[numColumns];
        int i = 0;
        while (i < numColumns >> 1) {
            int[] monomCoeffs = new int[(i << 1) + 1];
            monomCoeffs[i << 1] = 1;
            this.sqMatrix[i] = new PolynomialGF2mSmallM(this.field, monomCoeffs);
            ++i;
        }
        int i2 = numColumns >> 1;
        while (i2 < numColumns) {
            int[] monomCoeffs = new int[(i2 << 1) + 1];
            monomCoeffs[i2 << 1] = 1;
            PolynomialGF2mSmallM monomial = new PolynomialGF2mSmallM(this.field, monomCoeffs);
            this.sqMatrix[i2] = monomial.mod(this.p);
            ++i2;
        }
    }

    private void computeSquareRootMatrix() {
        int numColumns = this.p.getDegree();
        PolynomialGF2mSmallM[] tmpMatrix = new PolynomialGF2mSmallM[numColumns];
        int i = numColumns - 1;
        while (i >= 0) {
            tmpMatrix[i] = new PolynomialGF2mSmallM(this.sqMatrix[i]);
            --i;
        }
        this.sqRootMatrix = new PolynomialGF2mSmallM[numColumns];
        int i2 = numColumns - 1;
        while (i2 >= 0) {
            this.sqRootMatrix[i2] = new PolynomialGF2mSmallM(this.field, i2);
            --i2;
        }
        int i3 = 0;
        while (i3 < numColumns) {
            if (tmpMatrix[i3].getCoefficient(i3) == 0) {
                boolean foundNonZero = false;
                int j = i3 + 1;
                while (j < numColumns) {
                    if (tmpMatrix[j].getCoefficient(i3) != 0) {
                        foundNonZero = true;
                        PolynomialRingGF2m.swapColumns(tmpMatrix, i3, j);
                        PolynomialRingGF2m.swapColumns(this.sqRootMatrix, i3, j);
                        j = numColumns;
                    }
                    ++j;
                }
                if (!foundNonZero) {
                    throw new ArithmeticException("Squaring matrix is not invertible.");
                }
            }
            int coef = tmpMatrix[i3].getCoefficient(i3);
            int invCoef = this.field.inverse(coef);
            tmpMatrix[i3].multThisWithElement(invCoef);
            this.sqRootMatrix[i3].multThisWithElement(invCoef);
            int j = 0;
            while (j < numColumns) {
                if (j != i3 && (coef = tmpMatrix[j].getCoefficient(i3)) != 0) {
                    PolynomialGF2mSmallM tmpSqColumn = tmpMatrix[i3].multWithElement(coef);
                    PolynomialGF2mSmallM tmpInvColumn = this.sqRootMatrix[i3].multWithElement(coef);
                    tmpMatrix[j].addToThis(tmpSqColumn);
                    this.sqRootMatrix[j].addToThis(tmpInvColumn);
                }
                ++j;
            }
            ++i3;
        }
    }

    private static void swapColumns(PolynomialGF2mSmallM[] matrix, int first, int second) {
        PolynomialGF2mSmallM tmp = matrix[first];
        matrix[first] = matrix[second];
        matrix[second] = tmp;
    }
}

