/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.common.math.ellipticcurves;

import de.flexiprovider.common.exceptions.DifferentCurvesException;
import de.flexiprovider.common.exceptions.DifferentFieldsException;
import de.flexiprovider.common.exceptions.InvalidFormatException;
import de.flexiprovider.common.exceptions.InvalidPointException;
import de.flexiprovider.common.math.ellipticcurves.EllipticCurveGF2n;
import de.flexiprovider.common.math.ellipticcurves.Point;
import de.flexiprovider.common.math.finitefields.GF2nElement;
import de.flexiprovider.common.math.finitefields.GF2nField;
import de.flexiprovider.common.math.finitefields.GF2nONBElement;
import de.flexiprovider.common.math.finitefields.GF2nONBField;
import de.flexiprovider.common.math.finitefields.GF2nPolynomialElement;
import de.flexiprovider.common.math.finitefields.GF2nPolynomialField;
import de.flexiprovider.common.math.finitefields.GFElement;
import java.util.Random;

public class PointGF2n
extends Point {
    private int mDeg;
    private GF2nField mGF2n;
    private boolean isGF2nONBField = false;
    private GF2nElement mA;
    private boolean mAIsZero;
    private GF2nElement mB;
    private GF2nElement mX;
    private GF2nElement mY;
    private GF2nElement mZ;

    public PointGF2n(EllipticCurveGF2n E) {
        this.mE = E;
        this.mP = E.getQ();
        this.mA = (GF2nElement)E.getA();
        this.mAIsZero = this.mA.isZero();
        this.mB = (GF2nElement)E.getB();
        this.mGF2n = this.mA.getField();
        this.mDeg = this.mGF2n.getDegree();
        this.setGF2nFieldType();
        this.assignZero();
    }

    public PointGF2n(EllipticCurveGF2n E, Random rand) {
        GF2nElement right;
        this.mE = E;
        this.mP = E.getQ();
        this.mA = (GF2nElement)E.getA();
        this.mAIsZero = this.mA.isZero();
        this.mB = (GF2nElement)E.getB();
        this.mGF2n = this.mA.getField();
        this.mDeg = this.mGF2n.getDegree();
        this.setGF2nFieldType();
        while (true) {
            this.mX = this.createRandomGF2nElement(this.mGF2n, rand);
            if (this.mX.isZero()) continue;
            this.mY = this.mX.square();
            right = (GF2nElement)this.mA.multiply(this.mY);
            right.addToThis(this.mB);
            right.addToThis(this.mY.multiply(this.mX));
            this.mY = (GF2nElement)this.mY.invert();
            right.multiplyThisBy(this.mY);
            if (right.trace() == 0) break;
        }
        this.mY = right.solveQuadraticEquation();
        if (this.mY.testRightmostBit()) {
            this.mY.increaseThis();
        }
        this.mY.multiplyThisBy(this.mX);
        this.mZ = this.createGF2nOneElement(this.mGF2n);
    }

    public PointGF2n(GF2nElement x, GF2nElement y, EllipticCurveGF2n E) throws InvalidPointException, DifferentFieldsException {
        this.mE = E;
        this.mP = E.getQ();
        this.mA = (GF2nElement)E.getA();
        this.mAIsZero = this.mA.isZero();
        this.mB = (GF2nElement)E.getB();
        this.mGF2n = this.mA.getField();
        this.mDeg = this.mGF2n.getDegree();
        this.setGF2nFieldType();
        this.mX = (GF2nElement)x.clone();
        this.mY = (GF2nElement)y.clone();
        this.mZ = this.createGF2nOneElement(this.mGF2n);
    }

    public PointGF2n(GF2nElement x, GF2nElement y, GF2nElement z, EllipticCurveGF2n E) throws InvalidPointException, DifferentFieldsException {
        this.mE = E;
        this.mP = E.getQ();
        this.mA = (GF2nElement)E.getA();
        this.mAIsZero = this.mA.isZero();
        this.mB = (GF2nElement)E.getB();
        this.mGF2n = this.mA.getField();
        this.mDeg = this.mGF2n.getDegree();
        this.setGF2nFieldType();
        this.mX = (GF2nElement)x.clone();
        this.mY = (GF2nElement)y.clone();
        this.mZ = (GF2nElement)z.clone();
    }

    public PointGF2n(byte[] encoded, EllipticCurveGF2n E) throws InvalidPointException, InvalidFormatException {
        this.mE = E;
        this.mP = E.getQ();
        this.mA = (GF2nElement)E.getA();
        this.mAIsZero = this.mA.isZero();
        this.mB = (GF2nElement)E.getB();
        this.mGF2n = this.mA.getField();
        this.mDeg = this.mGF2n.getDegree();
        this.setGF2nFieldType();
        if (encoded.length == 1 && encoded[0] == 0) {
            this.assignZero();
            return;
        }
        byte pc = encoded[0];
        switch (pc) {
            case 2: 
            case 3: {
                byte[] bX = new byte[encoded.length - 1];
                System.arraycopy(encoded, 1, bX, 0, bX.length);
                this.mX = this.createGF2nElement(bX);
                boolean yMod2 = (pc & 1) == 1;
                this.mY = this.decompress(yMod2, this.mX);
                break;
            }
            case 4: {
                int l = encoded.length - 1 >> 1;
                byte[] bX = new byte[l];
                byte[] bY = new byte[l];
                System.arraycopy(encoded, 1, bX, 0, l);
                System.arraycopy(encoded, 1 + l, bY, 0, l);
                this.mX = this.createGF2nElement(bX);
                this.mY = this.createGF2nElement(bY);
                break;
            }
            case 6: 
            case 7: {
                boolean yMod2;
                int l = encoded.length - 1 >> 1;
                byte[] bX = new byte[l];
                byte[] bY = new byte[l];
                System.arraycopy(encoded, 1, bX, 0, l);
                System.arraycopy(encoded, 1 + l, bY, 0, l);
                this.mX = this.createGF2nElement(bX);
                this.mY = this.createGF2nElement(bY);
                boolean bl = yMod2 = (pc & 1) == 1;
                if (this.decompress(yMod2, this.mX).equals(this.mY)) break;
                throw new InvalidPointException();
            }
            default: {
                throw new InvalidFormatException(pc);
            }
        }
        this.mZ = this.createGF2nOneElement(this.mGF2n);
    }

    public PointGF2n(PointGF2n other) {
        EllipticCurveGF2n E = (EllipticCurveGF2n)other.getE();
        this.mE = E;
        this.mP = E.getQ();
        this.mA = (GF2nElement)E.getA();
        this.mAIsZero = this.mA.isZero();
        this.mB = (GF2nElement)E.getB();
        this.mGF2n = this.mA.getField();
        this.mDeg = this.mGF2n.getDegree();
        this.setGF2nFieldType();
        this.assign(other);
    }

    private void assignZero() {
        this.mX = this.createGF2nOneElement(this.mGF2n);
        this.mY = this.createGF2nOneElement(this.mGF2n);
        this.mZ = this.createGF2nZeroElement(this.mGF2n);
    }

    private void assign(GF2nElement x, GF2nElement y, GF2nElement z) throws InvalidPointException {
        this.mX = x;
        this.mY = y;
        this.mZ = z;
    }

    private void assign(PointGF2n other) {
        this.mX = (GF2nElement)other.mX.clone();
        this.mY = (GF2nElement)other.mY.clone();
        this.mZ = (GF2nElement)other.mZ.clone();
    }

    public Object clone() {
        return new PointGF2n(this);
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof PointGF2n)) {
            return false;
        }
        PointGF2n otherPoint = (PointGF2n)other;
        if (this.mZ.isOne() && otherPoint.mZ.isOne()) {
            return this.mX.equals(otherPoint.mX) && this.mY.equals(otherPoint.mY);
        }
        boolean result = true;
        if (this.mZ.isOne()) {
            GF2nElement z2 = otherPoint.mZ.square();
            result = result && otherPoint.mX.equals(this.mX.multiply(z2));
            z2.multiplyThisBy(otherPoint.mZ);
            result = result && otherPoint.mY.equals(this.mY.multiply(z2));
        } else if (otherPoint.mZ.isOne()) {
            GF2nElement z1 = this.mZ.square();
            result = result && this.mX.equals(otherPoint.mX.multiply(z1));
            z1.multiplyThisBy(this.mZ);
            result = result && this.mY.equals(otherPoint.mY.multiply(z1));
        } else {
            GF2nElement z1 = this.mZ.square();
            GF2nElement z2 = otherPoint.mZ.square();
            result = result && this.mX.multiply(z2).equals(otherPoint.mX.multiply(z1));
            z1.multiplyThisBy(this.mZ);
            z2.multiplyThisBy(otherPoint.mZ);
            result = result && this.mY.multiply(z2).equals(otherPoint.mY.multiply(z1));
        }
        return result;
    }

    public int hashCode() {
        return this.getXAffin().hashCode() + this.getYAffin().hashCode();
    }

    public String toString() {
        return "(" + this.getXAffin().toString(16) + ",\n " + this.getYAffin().toString(16) + ")";
    }

    public GFElement getX() {
        return this.mX;
    }

    public GFElement getY() {
        return this.mY;
    }

    public GFElement getZ() {
        return this.mZ;
    }

    public GFElement getXAffin() {
        if (this.isZero()) {
            return (GF2nElement)this.mZ.clone();
        }
        if (this.mZ.isOne()) {
            return this.mX;
        }
        GFElement z = this.mZ.square();
        z = z.invert();
        z.multiplyThisBy(this.mX);
        return z;
    }

    public GFElement getYAffin() {
        if (this.isZero()) {
            return (GFElement)this.mZ.clone();
        }
        if (this.mZ.isOne()) {
            return (GFElement)this.mY.clone();
        }
        GFElement z = null;
        z = this.mZ.square();
        z.multiplyThisBy(this.mZ);
        z = z.invert();
        z.multiplyThisBy(this.mY);
        return z;
    }

    public Point getAffin() {
        if (this.isZero()) {
            return this;
        }
        GF2nElement notZ = (GF2nElement)this.mZ.invert();
        GF2nElement squareNotZ = notZ.square();
        GF2nElement x = (GF2nElement)this.mX.multiply(squareNotZ);
        notZ.multiplyThisBy(squareNotZ);
        GF2nElement y = (GF2nElement)this.mY.multiply(notZ);
        return new PointGF2n(x, y, (EllipticCurveGF2n)this.mE);
    }

    public boolean onCurve() {
        GFElement left;
        GF2nElement right;
        if (this.isZero()) {
            return true;
        }
        if (this.mZ.isOne()) {
            right = this.mX.square();
            GFElement tmp = right.multiply(this.mX);
            right.multiplyThisBy(this.mA);
            right.addToThis(tmp);
            right.addToThis(this.mB);
            left = this.mX.multiply(this.mY);
            left.addToThis(this.mY.square());
        } else {
            right = this.mX.square();
            GFElement tmp = right.multiply(this.mX);
            right.multiplyThisBy(this.mA);
            left = this.mZ.square();
            right.multiplyThisBy(left);
            right.addToThis(tmp);
            tmp = ((GF2nElement)left).square();
            left.multiplyThisBy(tmp);
            right.addToThis(left.multiply(this.mB));
            left = this.mX.multiply(this.mY);
            left.multiplyThisBy(this.mZ);
            left.addToThis(this.mY.square());
        }
        return right.equals(left);
    }

    public boolean isZero() {
        return this.mX.isOne() && this.mY.isOne() && this.mZ.isZero();
    }

    public Point add(Point other) throws DifferentCurvesException {
        PointGF2n result = new PointGF2n(this);
        result.addToThis(other);
        return result;
    }

    public void addToThis(Point other) throws DifferentCurvesException {
        if (!(other instanceof PointGF2n)) {
            throw new DifferentCurvesException("PointGF2n.addToThis(Point P): other is not an instance of PointGF2n");
        }
        PointGF2n otherPoint = (PointGF2n)other;
        if (this.isZero()) {
            this.assign(otherPoint);
        } else if (!otherPoint.isZero()) {
            GFElement T7;
            GF2nElement T1 = (GF2nElement)this.mX.clone();
            GF2nElement T2 = (GF2nElement)this.mY.clone();
            GF2nElement T3 = (GF2nElement)this.mZ.clone();
            GF2nElement T4 = (GF2nElement)otherPoint.mX.clone();
            GF2nElement T5 = (GF2nElement)otherPoint.mY.clone();
            GF2nElement T6 = (GF2nElement)otherPoint.mZ.clone();
            if (!otherPoint.mZ.isOne()) {
                T7 = T6.square();
                T1.multiplyThisBy(T7);
                T7.multiplyThisBy(T6);
                T2.multiplyThisBy(T7);
            }
            T7 = T3.square();
            GFElement T8 = T4.multiply(T7);
            T1.addToThis(T8);
            T7.multiplyThisBy(T3);
            T8 = T5.multiply(T7);
            T2.addToThis(T8);
            if (T1.isZero() && T2.isZero()) {
                this.multiplyThisBy2();
            } else if (T1.isZero() && !T2.isZero()) {
                this.assignZero();
            } else {
                T4.multiplyThisBy(T2);
                T3.multiplyThisBy(T1);
                T5.multiplyThisBy(T3);
                T4.addToThis(T5);
                T5 = T3.square();
                T7 = T4.multiply(T5);
                if (!otherPoint.mZ.isOne()) {
                    T3.multiplyThisBy(T6);
                }
                T4 = (GF2nElement)T2.add(T3);
                T2.multiplyThisBy(T4);
                T5 = T1.square();
                T1.multiplyThisBy(T5);
                if (!this.mAIsZero) {
                    T8 = T3.square();
                    GFElement T9 = this.mA.multiply(T8);
                    T1.addToThis(T9);
                }
                T1.addToThis(T2);
                T4.multiplyThisBy(T1);
                T4.addToThis(T7);
                this.assign(T1, T4, T3);
            }
        }
    }

    public Point addAffine(Point other) {
        PointGF2n p = (PointGF2n)this.getAffin();
        PointGF2n o = (PointGF2n)other.getAffin();
        if (this.isZero()) {
            return new PointGF2n(o);
        }
        if (o.isZero()) {
            return new PointGF2n(p);
        }
        GF2nElement pX = p.mX;
        GF2nElement pY = p.mY;
        GF2nElement oX = o.mX;
        GF2nElement oY = o.mY;
        if (pX.equals(oX) && pY.equals(oY)) {
            return p.multiplyBy2Affine();
        }
        GF2nElement tmp = (GF2nElement)pY.add(oY);
        GF2nElement lambda = (GF2nElement)pX.add(oX).invert();
        lambda = (GF2nElement)lambda.multiply(tmp);
        GF2nElement x = (GF2nElement)lambda.square().add(lambda);
        x = (GF2nElement)x.add(pX).add(oX).add(((EllipticCurveGF2n)this.mE).getA());
        GF2nElement y = (GF2nElement)pX.add(x).multiply(lambda);
        y = (GF2nElement)y.add(x).add(pY);
        return new PointGF2n(x, y, (EllipticCurveGF2n)this.mE);
    }

    public Point multiplyBy2() {
        PointGF2n result = new PointGF2n(this);
        result.multiplyThisBy2();
        return result;
    }

    public void multiplyThisBy2() {
        if (!this.isZero()) {
            GF2nElement T1 = (GF2nElement)this.mX.clone();
            GF2nElement T2 = (GF2nElement)this.mY.clone();
            GF2nElement T3 = (GF2nElement)this.mZ.clone();
            GF2nElement T4 = (GF2nElement)this.mB.clone();
            int i = 1;
            while (i < this.mDeg - 1) {
                T4.squareThis();
                ++i;
            }
            if (T1.isZero() || T3.isZero()) {
                this.assignZero();
            } else {
                T2.multiplyThisBy(T3);
                T3.squareThis();
                T4.multiplyThisBy(T3);
                T3.multiplyThisBy(T1);
                T2.addToThis(T3);
                T4.addToThis(T1);
                T4.squareThis();
                T4.squareThis();
                T1.squareThis();
                T2.addToThis(T1);
                T2.multiplyThisBy(T4);
                T1.squareThis();
                T1.multiplyThisBy(T3);
                T2.addToThis(T1);
            }
            this.assign(T4, T2, T3);
        }
    }

    public Point multiplyBy2Affine() {
        PointGF2n p = (PointGF2n)this.getAffin();
        GF2nElement pX = p.mX;
        GF2nElement pY = p.mY;
        if (pX.isZero() || this.mZ.isZero()) {
            return new PointGF2n((EllipticCurveGF2n)this.mE);
        }
        GF2nElement lambda = (GF2nElement)pX.invert();
        lambda = (GF2nElement)lambda.multiply(pY);
        lambda = (GF2nElement)lambda.add(pX);
        GF2nElement x = (GF2nElement)lambda.square().add(lambda);
        x = (GF2nElement)x.add(((EllipticCurveGF2n)this.mE).getA());
        GF2nElement y = (GF2nElement)lambda.add(this.createGF2nOneElement(this.mGF2n)).multiply(x);
        y = (GF2nElement)y.add(pX.square());
        return new PointGF2n(x, y, (EllipticCurveGF2n)this.mE);
    }

    public Point subtract(Point other) throws DifferentCurvesException {
        PointGF2n result = new PointGF2n(this);
        result.subtractFromThis(other);
        return result;
    }

    public void subtractFromThis(Point other) throws DifferentCurvesException {
        if (!(other instanceof PointGF2n)) {
            throw new DifferentCurvesException("PointGF2n.subtractFromThis(Point P): other is not an instance of PointGF2n");
        }
        PointGF2n minusOther = (PointGF2n)other.negate();
        if (this.isZero()) {
            this.assign(minusOther.mX, minusOther.mY, minusOther.mZ);
        } else {
            this.addToThis(minusOther);
        }
    }

    public Point negate() {
        PointGF2n result = new PointGF2n(this);
        result.negateThis();
        return result;
    }

    public void negateThis() {
        if (!this.isZero()) {
            GFElement tmp = this.mX.multiply(this.mZ);
            this.mY = (GF2nElement)tmp.add(this.mY);
        }
    }

    byte[] encodeUncompressed() {
        if (this.isZero()) {
            return new byte[1];
        }
        int l = this.mDeg;
        int dummy = l & 7;
        if (dummy != 0) {
            l += 8 - dummy;
        }
        byte[] encoded = new byte[((l >>>= 3) << 1) + 1];
        encoded[0] = 4;
        byte[] bX = this.getXAffin().toByteArray();
        byte[] bY = this.getYAffin().toByteArray();
        System.arraycopy(bX, 0, encoded, 1 + l - bX.length, bX.length);
        System.arraycopy(bY, 0, encoded, 1 + (l << 1) - bY.length, bY.length);
        return encoded;
    }

    byte[] encodeCompressed() {
        GFElement xInv;
        GFElement comp;
        if (this.isZero()) {
            return new byte[1];
        }
        int l = this.mDeg;
        if ((this.mDeg & 7) != 0) {
            l += 8 - (this.mDeg & 7);
        }
        byte[] encoded = new byte[(l >>>= 3) + 1];
        encoded[0] = 2;
        GFElement xAff = this.getXAffin();
        byte[] bX = xAff.toByteArray();
        System.arraycopy(bX, 0, encoded, 1, bX.length);
        if (!xAff.isZero() && ((GF2nElement)(comp = (xInv = xAff.invert()).multiply(this.getYAffin()))).testRightmostBit()) {
            encoded[0] = (byte)(encoded[0] | 1);
        }
        return encoded;
    }

    byte[] encodeHybrid() {
        GFElement xInv;
        GFElement comp;
        if (this.isZero()) {
            return new byte[1];
        }
        int l = this.mDeg;
        if ((l & 7) != 0) {
            l += 8 - (l & 7);
        }
        byte[] encoded = new byte[((l >>>= 3) << 1) + 1];
        encoded[0] = 6;
        GFElement xAff = this.getXAffin();
        GFElement yAff = this.getYAffin();
        byte[] bX = xAff.toByteArray();
        byte[] bY = yAff.toByteArray();
        System.arraycopy(bX, 0, encoded, 1 + l - bX.length, bX.length);
        System.arraycopy(bY, 0, encoded, 1 + (l << 1) - bY.length, bY.length);
        if (!xAff.isZero() && ((GF2nElement)(comp = (xInv = xAff.invert()).multiply(yAff))).testRightmostBit()) {
            encoded[0] = (byte)(encoded[0] | 1);
        }
        return encoded;
    }

    private GF2nElement decompress(boolean yMod2, GF2nElement x) {
        if (x.isZero()) {
            return this.mB.squareRoot();
        }
        GF2nElement z = null;
        GF2nElement tmp = x.square();
        GFElement beta = tmp.invert();
        GFElement alpha = tmp.multiply(this.mA);
        tmp.multiplyThisBy(x);
        alpha.addToThis(tmp);
        alpha.addToThis(this.mB);
        beta.multiplyThisBy(alpha);
        z = ((GF2nElement)beta).solveQuadraticEquation();
        if (z.testRightmostBit()) {
            z.increaseThis();
        }
        if (yMod2) {
            z.increaseThis();
        }
        z.multiplyThisBy(x);
        return z;
    }

    private void setGF2nFieldType() {
        this.isGF2nONBField = this.mGF2n instanceof GF2nONBField;
    }

    private GF2nElement createGF2nZeroElement(GF2nField gf2n) {
        if (this.isGF2nONBField) {
            return GF2nONBElement.ZERO((GF2nONBField)gf2n);
        }
        return GF2nPolynomialElement.ZERO((GF2nPolynomialField)gf2n);
    }

    private GF2nElement createGF2nOneElement(GF2nField gf2n) {
        if (this.isGF2nONBField) {
            return GF2nONBElement.ONE((GF2nONBField)gf2n);
        }
        return GF2nPolynomialElement.ONE((GF2nPolynomialField)gf2n);
    }

    private GF2nElement createRandomGF2nElement(GF2nField gf2n, Random rand) {
        if (this.isGF2nONBField) {
            return new GF2nONBElement((GF2nONBField)gf2n, rand);
        }
        return new GF2nPolynomialElement((GF2nPolynomialField)gf2n, rand);
    }

    private GF2nElement createGF2nElement(byte[] value) {
        if (this.isGF2nONBField) {
            return new GF2nONBElement((GF2nONBField)this.mGF2n, value);
        }
        return new GF2nPolynomialElement((GF2nPolynomialField)this.mGF2n, value);
    }
}

