/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.common.math.finitefields;

import de.flexiprovider.common.exceptions.DifferentFieldsException;
import de.flexiprovider.common.exceptions.NoSolutionException;
import de.flexiprovider.common.math.FlexiBigInt;
import de.flexiprovider.common.math.finitefields.GF2nElement;
import de.flexiprovider.common.math.finitefields.GF2nONBField;
import de.flexiprovider.common.math.finitefields.GFElement;
import java.util.Random;

public class GF2nONBElement
extends GF2nElement {
    private static final long[] mBitmask = new long[]{1L, 2L, 4L, 8L, 16L, 32L, 64L, 128L, 256L, 512L, 1024L, 2048L, 4096L, 8192L, 16384L, 32768L, 65536L, 131072L, 262144L, 524288L, 0x100000L, 0x200000L, 0x400000L, 0x800000L, 0x1000000L, 0x2000000L, 0x4000000L, 0x8000000L, 0x10000000L, 0x20000000L, 0x40000000L, 0x80000000L, 0x100000000L, 0x200000000L, 0x400000000L, 0x800000000L, 0x1000000000L, 0x2000000000L, 0x4000000000L, 0x8000000000L, 0x10000000000L, 0x20000000000L, 0x40000000000L, 0x80000000000L, 0x100000000000L, 0x200000000000L, 0x400000000000L, 0x800000000000L, 0x1000000000000L, 0x2000000000000L, 0x4000000000000L, 0x8000000000000L, 0x10000000000000L, 0x20000000000000L, 0x40000000000000L, 0x80000000000000L, 0x100000000000000L, 0x200000000000000L, 0x400000000000000L, 0x800000000000000L, 0x1000000000000000L, 0x2000000000000000L, 0x4000000000000000L, Long.MIN_VALUE};
    private static final long[] mMaxmask = new long[]{1L, 3L, 7L, 15L, 31L, 63L, 127L, 255L, 511L, 1023L, 2047L, 4095L, 8191L, 16383L, 32767L, 65535L, 131071L, 262143L, 524287L, 1048575L, 0x1FFFFFL, 0x3FFFFFL, 0x7FFFFFL, 0xFFFFFFL, 0x1FFFFFFL, 0x3FFFFFFL, 0x7FFFFFFL, 0xFFFFFFFL, 0x1FFFFFFFL, 0x3FFFFFFFL, Integer.MAX_VALUE, 0xFFFFFFFFL, 0x1FFFFFFFFL, 0x3FFFFFFFFL, 0x7FFFFFFFFL, 0xFFFFFFFFFL, 0x1FFFFFFFFFL, 0x3FFFFFFFFFL, 0x7FFFFFFFFFL, 0xFFFFFFFFFFL, 0x1FFFFFFFFFFL, 0x3FFFFFFFFFFL, 0x7FFFFFFFFFFL, 0xFFFFFFFFFFFL, 0x1FFFFFFFFFFFL, 0x3FFFFFFFFFFFL, 0x7FFFFFFFFFFFL, 0xFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFL, 0x3FFFFFFFFFFFFL, 0x7FFFFFFFFFFFFL, 0xFFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFFL, 0x3FFFFFFFFFFFFFL, 0x7FFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFFFL, 0x3FFFFFFFFFFFFFFL, 0x7FFFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFFFFL, 0x3FFFFFFFFFFFFFFFL, Long.MAX_VALUE, -1L};
    private static final int[] mIBY64 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5};
    private static final int MAXLONG = 64;
    private int mLength;
    private int mBit;
    private long[] mPol;

    public GF2nONBElement(GF2nONBField gf2n, Random rand) {
        this.mField = gf2n;
        this.mDegree = this.mField.getDegree();
        this.mLength = gf2n.getONBLength();
        this.mBit = gf2n.getONBBit();
        this.mPol = new long[this.mLength];
        if (this.mLength > 1) {
            int j = 0;
            while (j < this.mLength - 1) {
                this.mPol[j] = rand.nextLong();
                ++j;
            }
            long last = rand.nextLong();
            this.mPol[this.mLength - 1] = last >>> 64 - this.mBit;
        } else {
            this.mPol[0] = rand.nextLong();
            this.mPol[0] = this.mPol[0] >>> 64 - this.mBit;
        }
    }

    public GF2nONBElement(GF2nONBField gf2n, byte[] e) {
        this.mField = gf2n;
        this.mDegree = this.mField.getDegree();
        this.mLength = gf2n.getONBLength();
        this.mBit = gf2n.getONBBit();
        this.mPol = new long[this.mLength];
        this.assign(e);
    }

    public GF2nONBElement(GF2nONBField gf2n, FlexiBigInt val) {
        this.mField = gf2n;
        this.mDegree = this.mField.getDegree();
        this.mLength = gf2n.getONBLength();
        this.mBit = gf2n.getONBBit();
        this.mPol = new long[this.mLength];
        this.assign(val);
    }

    private GF2nONBElement(GF2nONBField gf2n, long[] val) {
        this.mField = gf2n;
        this.mDegree = this.mField.getDegree();
        this.mLength = gf2n.getONBLength();
        this.mBit = gf2n.getONBBit();
        this.mPol = val;
    }

    public GF2nONBElement(GF2nONBElement gf2n) {
        this.mField = gf2n.mField;
        this.mDegree = this.mField.getDegree();
        this.mLength = ((GF2nONBField)this.mField).getONBLength();
        this.mBit = ((GF2nONBField)this.mField).getONBBit();
        this.mPol = new long[this.mLength];
        this.assign(gf2n.getElement());
    }

    public Object clone() {
        return new GF2nONBElement(this);
    }

    public static GF2nONBElement ZERO(GF2nONBField gf2n) {
        long[] polynomial = new long[gf2n.getONBLength()];
        return new GF2nONBElement(gf2n, polynomial);
    }

    public static GF2nONBElement ONE(GF2nONBField gf2n) {
        int mLength = gf2n.getONBLength();
        long[] polynomial = new long[mLength];
        int i = 0;
        while (i < mLength - 1) {
            polynomial[i] = -1L;
            ++i;
        }
        polynomial[mLength - 1] = mMaxmask[gf2n.getONBBit() - 1];
        return new GF2nONBElement(gf2n, polynomial);
    }

    void assignZero() {
        this.mPol = new long[this.mLength];
    }

    void assignOne() {
        int i = 0;
        while (i < this.mLength - 1) {
            this.mPol[i] = -1L;
            ++i;
        }
        this.mPol[this.mLength - 1] = mMaxmask[this.mBit - 1];
    }

    private void assign(FlexiBigInt val) {
        this.assign(val.toByteArray());
    }

    private void assign(long[] val) {
        System.arraycopy(val, 0, this.mPol, 0, this.mLength);
    }

    private void assign(byte[] val) {
        this.mPol = new long[this.mLength];
        int j = 0;
        while (j < val.length) {
            int n = j >>> 3;
            this.mPol[n] = this.mPol[n] | ((long)val[val.length - 1 - j] & 0xFFL) << ((j & 7) << 3);
            ++j;
        }
    }

    public boolean isZero() {
        boolean result = true;
        int i = 0;
        while (i < this.mLength && result) {
            result = result && (this.mPol[i] & 0xFFFFFFFFFFFFFFFFL) == 0L;
            ++i;
        }
        return result;
    }

    public boolean isOne() {
        boolean result = true;
        int i = 0;
        while (i < this.mLength - 1 && result) {
            result = result && (this.mPol[i] & 0xFFFFFFFFFFFFFFFFL) == -1L;
            ++i;
        }
        if (result) {
            result = result && (this.mPol[this.mLength - 1] & mMaxmask[this.mBit - 1]) == mMaxmask[this.mBit - 1];
        }
        return result;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof GF2nONBElement)) {
            return false;
        }
        GF2nONBElement otherElem = (GF2nONBElement)other;
        int i = 0;
        while (i < this.mLength) {
            if (this.mPol[i] != otherElem.mPol[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        return this.mPol.hashCode();
    }

    public boolean testRightmostBit() {
        return (this.mPol[this.mLength - 1] & mBitmask[this.mBit - 1]) != 0L;
    }

    boolean testBit(int index) {
        if (index < 0 || index > this.mDegree) {
            return false;
        }
        long test = this.mPol[index >>> 6] & mBitmask[index & 0x3F];
        return test != 0L;
    }

    private long[] getElement() {
        long[] result = new long[this.mPol.length];
        System.arraycopy(this.mPol, 0, result, 0, this.mPol.length);
        return result;
    }

    private long[] getElementReverseOrder() {
        long[] result = new long[this.mPol.length];
        int i = 0;
        while (i < this.mDegree) {
            if (this.testBit(this.mDegree - i - 1)) {
                int n = i >>> 6;
                result[n] = result[n] | mBitmask[i & 0x3F];
            }
            ++i;
        }
        return result;
    }

    void reverseOrder() {
        this.mPol = this.getElementReverseOrder();
    }

    public GFElement add(GFElement addend) throws DifferentFieldsException {
        GF2nONBElement result = new GF2nONBElement(this);
        result.addToThis(addend);
        return result;
    }

    public void addToThis(GFElement addend) throws DifferentFieldsException {
        if (!(addend instanceof GF2nONBElement)) {
            throw new DifferentFieldsException();
        }
        if (!this.mField.equals(((GF2nONBElement)addend).mField)) {
            throw new DifferentFieldsException();
        }
        int i = 0;
        while (i < this.mLength) {
            int n = i;
            this.mPol[n] = this.mPol[n] ^ ((GF2nONBElement)addend).mPol[i];
            ++i;
        }
    }

    public GF2nElement increase() {
        GF2nONBElement result = new GF2nONBElement(this);
        result.increaseThis();
        return result;
    }

    public void increaseThis() {
        this.addToThis(GF2nONBElement.ONE((GF2nONBField)this.mField));
    }

    public GFElement multiply(GFElement factor) throws DifferentFieldsException {
        GF2nONBElement result = new GF2nONBElement(this);
        result.multiplyThisBy(factor);
        return result;
    }

    public void multiplyThisBy(GFElement factor) throws DifferentFieldsException {
        if (!(factor instanceof GF2nONBElement)) {
            throw new DifferentFieldsException("The elements have different representation: not yet implemented");
        }
        if (!this.mField.equals(((GF2nONBElement)factor).mField)) {
            throw new DifferentFieldsException();
        }
        if (this.equals(factor)) {
            this.squareThis();
        } else {
            long[] a = this.mPol;
            long[] b = ((GF2nONBElement)factor).mPol;
            long[] c = new long[this.mLength];
            int[][] m = ((GF2nONBField)this.mField).mMult;
            int degf = this.mLength - 1;
            int degb = this.mBit - 1;
            boolean s = false;
            long TWOTOMAXLONGM1 = mBitmask[63];
            long TWOTODEGB = mBitmask[degb];
            int k = 0;
            while (k < this.mDegree) {
                boolean old;
                int bita;
                int fielda;
                s = false;
                int i = 0;
                while (i < this.mDegree) {
                    fielda = mIBY64[i];
                    bita = i & 0x3F;
                    int fieldb = mIBY64[m[i][0]];
                    int bitb = m[i][0] & 0x3F;
                    if ((a[fielda] & mBitmask[bita]) != 0L) {
                        if ((b[fieldb] & mBitmask[bitb]) != 0L) {
                            s ^= true;
                        }
                        if (m[i][1] != -1 && (b[fieldb = mIBY64[m[i][1]]] & mBitmask[bitb = m[i][1] & 0x3F]) != 0L) {
                            s ^= true;
                        }
                    }
                    ++i;
                }
                fielda = mIBY64[k];
                bita = k & 0x3F;
                if (s) {
                    int n = fielda;
                    c[n] = c[n] ^ mBitmask[bita];
                }
                if (this.mLength > 1) {
                    boolean now;
                    old = (a[degf] & 1L) == 1L;
                    int i2 = degf - 1;
                    while (i2 >= 0) {
                        now = (a[i2] & 1L) != 0L;
                        a[i2] = a[i2] >>> 1;
                        if (old) {
                            int n = i2;
                            a[n] = a[n] ^ TWOTOMAXLONGM1;
                        }
                        old = now;
                        --i2;
                    }
                    a[degf] = a[degf] >>> 1;
                    if (old) {
                        int n = degf;
                        a[n] = a[n] ^ TWOTODEGB;
                    }
                    old = (b[degf] & 1L) == 1L;
                    int i3 = degf - 1;
                    while (i3 >= 0) {
                        now = (b[i3] & 1L) != 0L;
                        b[i3] = b[i3] >>> 1;
                        if (old) {
                            int n = i3;
                            b[n] = b[n] ^ TWOTOMAXLONGM1;
                        }
                        old = now;
                        --i3;
                    }
                    b[degf] = b[degf] >>> 1;
                    if (old) {
                        int n = degf;
                        b[n] = b[n] ^ TWOTODEGB;
                    }
                } else {
                    old = (a[0] & 1L) == 1L;
                    a[0] = a[0] >>> 1;
                    if (old) {
                        a[0] = a[0] ^ TWOTODEGB;
                    }
                    old = (b[0] & 1L) == 1L;
                    b[0] = b[0] >>> 1;
                    if (old) {
                        b[0] = b[0] ^ TWOTODEGB;
                    }
                }
                ++k;
            }
            this.assign(c);
        }
    }

    public GF2nElement square() {
        GF2nONBElement result = new GF2nONBElement(this);
        result.squareThis();
        return result;
    }

    public void squareThis() {
        boolean now;
        long[] pol = this.getElement();
        int f = this.mLength - 1;
        int b = this.mBit - 1;
        long TWOTOMAXLONGM1 = mBitmask[63];
        boolean old = (pol[f] & mBitmask[b]) != 0L;
        int i = 0;
        while (i < f) {
            now = (pol[i] & TWOTOMAXLONGM1) != 0L;
            pol[i] = pol[i] << 1;
            if (old) {
                int n = i;
                pol[n] = pol[n] ^ 1L;
            }
            old = now;
            ++i;
        }
        now = (pol[f] & mBitmask[b]) != 0L;
        pol[f] = pol[f] << 1;
        if (old) {
            int n = f;
            pol[n] = pol[n] ^ 1L;
        }
        if (now) {
            int n = f;
            pol[n] = pol[n] ^ mBitmask[b + 1];
        }
        this.assign(pol);
    }

    public GFElement invert() throws ArithmeticException {
        GF2nONBElement result = new GF2nONBElement(this);
        result.invertThis();
        return result;
    }

    public void invertThis() throws ArithmeticException {
        if (this.isZero()) {
            throw new ArithmeticException();
        }
        int r = 31;
        boolean found = false;
        while (!found && r >= 0) {
            if (((long)(this.mDegree - 1) & mBitmask[r]) != 0L) {
                found = true;
            }
            --r;
        }
        GF2nElement m = GF2nONBElement.ZERO((GF2nONBField)this.mField);
        GF2nONBElement n = new GF2nONBElement(this);
        int k = 1;
        int i = ++r - 1;
        while (i >= 0) {
            m = (GF2nElement)((GF2nElement)n).clone();
            int j = 1;
            while (j <= k) {
                m.squareThis();
                ++j;
            }
            ((GF2nElement)n).multiplyThisBy(m);
            k <<= 1;
            if (((long)(this.mDegree - 1) & mBitmask[i]) != 0L) {
                ((GF2nElement)n).squareThis();
                ((GF2nElement)n).multiplyThisBy(this);
                ++k;
            }
            --i;
        }
        ((GF2nElement)n).squareThis();
    }

    public GF2nElement squareRoot() {
        GF2nONBElement result = new GF2nONBElement(this);
        result.squareRootThis();
        return result;
    }

    public void squareRootThis() {
        long[] pol = this.getElement();
        int f = this.mLength - 1;
        int b = this.mBit - 1;
        long TWOTOMAXLONGM1 = mBitmask[63];
        boolean old = (pol[0] & 1L) != 0L;
        int i = f;
        while (i >= 0) {
            boolean now = (pol[i] & 1L) != 0L;
            pol[i] = pol[i] >>> 1;
            if (old) {
                if (i == f) {
                    int n = i;
                    pol[n] = pol[n] ^ mBitmask[b];
                } else {
                    int n = i;
                    pol[n] = pol[n] ^ TWOTOMAXLONGM1;
                }
            }
            old = now;
            --i;
        }
        this.assign(pol);
    }

    public int trace() {
        int result = 0;
        int max = this.mLength - 1;
        int i = 0;
        while (i < max) {
            int j = 0;
            while (j < 64) {
                if ((this.mPol[i] & mBitmask[j]) != 0L) {
                    result ^= 1;
                }
                ++j;
            }
            ++i;
        }
        int b = this.mBit;
        int j = 0;
        while (j < b) {
            if ((this.mPol[max] & mBitmask[j]) != 0L) {
                result ^= 1;
            }
            ++j;
        }
        return result;
    }

    public GF2nElement solveQuadraticEquation() throws NoSolutionException {
        if (this.trace() == 1) {
            throw new NoSolutionException(this);
        }
        long TWOTOMAXLONGM1 = mBitmask[63];
        long ZERO = 0L;
        long ONE = 1L;
        long[] p = new long[this.mLength];
        long z = 0L;
        int j = 1;
        int i = 0;
        while (i < this.mLength - 1) {
            j = 1;
            while (j < 64) {
                if (!((mBitmask[j] & this.mPol[i]) != ZERO && (z & mBitmask[j - 1]) != ZERO || (this.mPol[i] & mBitmask[j]) == ZERO && (z & mBitmask[j - 1]) == ZERO)) {
                    z ^= mBitmask[j];
                }
                ++j;
            }
            p[i] = z;
            z = (TWOTOMAXLONGM1 & z) != ZERO && (ONE & this.mPol[i + 1]) == ONE || (TWOTOMAXLONGM1 & z) == ZERO && (ONE & this.mPol[i + 1]) == ZERO ? ZERO : ONE;
            ++i;
        }
        int b = this.mDegree & 0x3F;
        long LASTLONG = this.mPol[this.mLength - 1];
        j = 1;
        while (j < b) {
            if (!((mBitmask[j] & LASTLONG) != ZERO && (mBitmask[j - 1] & z) != ZERO || (mBitmask[j] & LASTLONG) == ZERO && (mBitmask[j - 1] & z) == ZERO)) {
                z ^= mBitmask[j];
            }
            ++j;
        }
        p[this.mLength - 1] = z;
        return new GF2nONBElement((GF2nONBField)this.mField, p);
    }

    public String toString() {
        return this.toString(16);
    }

    public String toString(int radix) {
        String s;
        block5: {
            long[] a;
            block4: {
                s = "";
                a = this.getElement();
                int b = this.mBit;
                if (radix != 2) break block4;
                int j = b - 1;
                while (j >= 0) {
                    s = (a[a.length - 1] & 1L << j) == 0L ? s + "0" : s + "1";
                    --j;
                }
                int i = a.length - 2;
                while (i >= 0) {
                    int j2 = 63;
                    while (j2 >= 0) {
                        s = (a[i] & mBitmask[j2]) == 0L ? s + "0" : s + "1";
                        --j2;
                    }
                    --i;
                }
                break block5;
            }
            if (radix != 16) break block5;
            char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
            int i = a.length - 1;
            while (i >= 0) {
                s = s + HEX_CHARS[(int)(a[i] >>> 60) & 0xF];
                s = s + HEX_CHARS[(int)(a[i] >>> 56) & 0xF];
                s = s + HEX_CHARS[(int)(a[i] >>> 52) & 0xF];
                s = s + HEX_CHARS[(int)(a[i] >>> 48) & 0xF];
                s = s + HEX_CHARS[(int)(a[i] >>> 44) & 0xF];
                s = s + HEX_CHARS[(int)(a[i] >>> 40) & 0xF];
                s = s + HEX_CHARS[(int)(a[i] >>> 36) & 0xF];
                s = s + HEX_CHARS[(int)(a[i] >>> 32) & 0xF];
                s = s + HEX_CHARS[(int)(a[i] >>> 28) & 0xF];
                s = s + HEX_CHARS[(int)(a[i] >>> 24) & 0xF];
                s = s + HEX_CHARS[(int)(a[i] >>> 20) & 0xF];
                s = s + HEX_CHARS[(int)(a[i] >>> 16) & 0xF];
                s = s + HEX_CHARS[(int)(a[i] >>> 12) & 0xF];
                s = s + HEX_CHARS[(int)(a[i] >>> 8) & 0xF];
                s = s + HEX_CHARS[(int)(a[i] >>> 4) & 0xF];
                s = s + HEX_CHARS[(int)a[i] & 0xF];
                s = s + " ";
                --i;
            }
        }
        return s;
    }

    public FlexiBigInt toFlexiBigInt() {
        return new FlexiBigInt(1, this.toByteArray());
    }

    public byte[] toByteArray() {
        int k = (this.mDegree - 1 >> 3) + 1;
        byte[] result = new byte[k];
        int i = 0;
        while (i < k) {
            result[k - i - 1] = (byte)((this.mPol[i >>> 3] & 255L << ((i & 7) << 3)) >>> ((i & 7) << 3));
            ++i;
        }
        return result;
    }
}

