/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.common.math.linearalgebra;

import de.flexiprovider.api.Registry;
import de.flexiprovider.api.SecureRandom;
import de.flexiprovider.common.math.linearalgebra.GF2Vector;
import de.flexiprovider.common.math.linearalgebra.Matrix;
import de.flexiprovider.common.math.linearalgebra.Permutation;
import de.flexiprovider.common.math.linearalgebra.Vector;
import de.flexiprovider.common.util.IntUtils;
import de.flexiprovider.common.util.LittleEndianConversions;

public class GF2Matrix
extends Matrix {
    private int[][] matrix;
    private int length;

    public GF2Matrix(byte[] enc) {
        if (enc.length < 9) {
            throw new ArithmeticException("given array is not an encoded matrix over GF(2)");
        }
        this.numRows = LittleEndianConversions.OS2IP(enc, 0);
        this.numColumns = LittleEndianConversions.OS2IP(enc, 4);
        int n = (this.numColumns + 7 >>> 3) * this.numRows;
        if (this.numRows <= 0 || n != enc.length - 8) {
            throw new ArithmeticException("given array is not an encoded matrix over GF(2)");
        }
        this.length = this.numColumns + 31 >>> 5;
        this.matrix = new int[this.numRows][this.length];
        int q = this.numColumns >> 5;
        int r = this.numColumns & 0x1F;
        int count = 8;
        int i = 0;
        while (i < this.numRows) {
            int j = 0;
            while (j < q) {
                this.matrix[i][j] = LittleEndianConversions.OS2IP(enc, count);
                ++j;
                count += 4;
            }
            int j2 = 0;
            while (j2 < r) {
                int[] nArray = this.matrix[i];
                int n2 = q;
                nArray[n2] = nArray[n2] ^ (enc[count++] & 0xFF) << j2;
                j2 += 8;
            }
            ++i;
        }
    }

    public GF2Matrix(int numColumns, int[][] matrix) {
        if (matrix[0].length != numColumns + 31 >> 5) {
            throw new ArithmeticException("Int array does not match given number of columns.");
        }
        this.numColumns = numColumns;
        this.numRows = matrix.length;
        this.length = matrix[0].length;
        int rest = numColumns & 0x1F;
        int bitMask = rest == 0 ? -1 : (1 << rest) - 1;
        int i = 0;
        while (i < this.numRows) {
            int[] nArray = matrix[i];
            int n = this.length - 1;
            nArray[n] = nArray[n] & bitMask;
            ++i;
        }
        this.matrix = matrix;
    }

    public GF2Matrix(int n, char typeOfMatrix) {
        this(n, typeOfMatrix, Registry.getSecureRandom());
    }

    public GF2Matrix(int n, char typeOfMatrix, SecureRandom sr) {
        if (n <= 0) {
            throw new ArithmeticException("Size of matrix is non-positive.");
        }
        switch (typeOfMatrix) {
            case 'Z': {
                this.assignZeroMatrix(n, n);
                break;
            }
            case 'I': {
                this.assignUnitMatrix(n);
                break;
            }
            case 'L': {
                this.assignRandomLowerTriangularMatrix(n, sr);
                break;
            }
            case 'U': {
                this.assignRandomUpperTriangularMatrix(n, sr);
                break;
            }
            case 'R': {
                this.assignRandomRegularMatrix(n, sr);
                break;
            }
            default: {
                throw new ArithmeticException("Unknown matrix type.");
            }
        }
    }

    public GF2Matrix(GF2Matrix a) {
        this.numColumns = a.getNumColumns();
        this.numRows = a.getNumRows();
        this.length = a.length;
        this.matrix = new int[a.matrix.length][];
        int i = 0;
        while (i < this.matrix.length) {
            this.matrix[i] = IntUtils.clone(a.matrix[i]);
            ++i;
        }
    }

    private GF2Matrix(int m, int n) {
        if (n <= 0 || m <= 0) {
            throw new ArithmeticException("size of matrix is non-positive");
        }
        this.assignZeroMatrix(m, n);
    }

    private void assignZeroMatrix(int m, int n) {
        this.numRows = m;
        this.numColumns = n;
        this.length = n + 31 >>> 5;
        this.matrix = new int[this.numRows][this.length];
        int i = 0;
        while (i < this.numRows) {
            int j = 0;
            while (j < this.length) {
                this.matrix[i][j] = 0;
                ++j;
            }
            ++i;
        }
    }

    private void assignUnitMatrix(int n) {
        this.numRows = n;
        this.numColumns = n;
        this.length = n + 31 >>> 5;
        this.matrix = new int[this.numRows][this.length];
        int i = 0;
        while (i < this.numRows) {
            int j = 0;
            while (j < this.length) {
                this.matrix[i][j] = 0;
                ++j;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.numRows) {
            int rest = i2 & 0x1F;
            this.matrix[i2][i2 >>> 5] = 1 << rest;
            ++i2;
        }
    }

    private void assignRandomLowerTriangularMatrix(int n, SecureRandom sr) {
        this.numRows = n;
        this.numColumns = n;
        this.length = n + 31 >>> 5;
        this.matrix = new int[this.numRows][this.length];
        int i = 0;
        while (i < this.numRows) {
            int q = i >>> 5;
            int r = i & 0x1F;
            int s = 31 - r;
            r = 1 << r;
            int j = 0;
            while (j < q) {
                this.matrix[i][j] = sr.nextInt();
                ++j;
            }
            this.matrix[i][q] = sr.nextInt() >>> s | r;
            int j2 = q + 1;
            while (j2 < this.length) {
                this.matrix[i][j2] = 0;
                ++j2;
            }
            ++i;
        }
    }

    private void assignRandomUpperTriangularMatrix(int n, SecureRandom sr) {
        this.numRows = n;
        this.numColumns = n;
        this.length = n + 31 >>> 5;
        this.matrix = new int[this.numRows][this.length];
        int rest = n & 0x1F;
        int help = rest == 0 ? -1 : (1 << rest) - 1;
        int i = 0;
        while (i < this.numRows) {
            int r;
            int q = i >>> 5;
            int s = r = i & 0x1F;
            r = 1 << r;
            int j = 0;
            while (j < q) {
                this.matrix[i][j] = 0;
                ++j;
            }
            this.matrix[i][q] = sr.nextInt() << s | r;
            int j2 = q + 1;
            while (j2 < this.length) {
                this.matrix[i][j2] = sr.nextInt();
                ++j2;
            }
            int[] nArray = this.matrix[i];
            int n2 = this.length - 1;
            nArray[n2] = nArray[n2] & help;
            ++i;
        }
    }

    private void assignRandomRegularMatrix(int n, SecureRandom sr) {
        this.numRows = n;
        this.numColumns = n;
        this.length = n + 31 >>> 5;
        this.matrix = new int[this.numRows][this.length];
        GF2Matrix lm = new GF2Matrix(n, 'L', sr);
        GF2Matrix um = new GF2Matrix(n, 'U', sr);
        GF2Matrix rm = (GF2Matrix)lm.rightMultiply(um);
        Permutation perm = new Permutation(n, sr);
        int[] p = perm.getVector();
        int i = 0;
        while (i < n) {
            System.arraycopy(rm.matrix[i], 0, this.matrix[p[i]], 0, this.length);
            ++i;
        }
    }

    public static GF2Matrix[] createRandomRegularMatrixAndItsInverse(int n, SecureRandom sr) {
        GF2Matrix[] result = new GF2Matrix[2];
        int length = n + 31 >> 5;
        GF2Matrix lm = new GF2Matrix(n, 'L', sr);
        GF2Matrix um = new GF2Matrix(n, 'U', sr);
        GF2Matrix rm = (GF2Matrix)lm.rightMultiply(um);
        Permutation p = new Permutation(n, sr);
        int[] pVec = p.getVector();
        int[][] matrix = new int[n][length];
        int i = 0;
        while (i < n) {
            System.arraycopy(rm.matrix[pVec[i]], 0, matrix[i], 0, length);
            ++i;
        }
        result[0] = new GF2Matrix(n, matrix);
        GF2Matrix invLm = new GF2Matrix(n, 'I');
        int i2 = 0;
        while (i2 < n) {
            int rest = i2 & 0x1F;
            int q = i2 >>> 5;
            int r = 1 << rest;
            int j = i2 + 1;
            while (j < n) {
                int b = lm.matrix[j][q] & r;
                if (b != 0) {
                    int k = 0;
                    while (k <= q) {
                        int[] nArray = invLm.matrix[j];
                        int n2 = k;
                        nArray[n2] = nArray[n2] ^ invLm.matrix[i2][k];
                        ++k;
                    }
                }
                ++j;
            }
            ++i2;
        }
        GF2Matrix invUm = new GF2Matrix(n, 'I');
        int i3 = n - 1;
        while (i3 >= 0) {
            int rest = i3 & 0x1F;
            int q = i3 >>> 5;
            int r = 1 << rest;
            int j = i3 - 1;
            while (j >= 0) {
                int b = um.matrix[j][q] & r;
                if (b != 0) {
                    int k = q;
                    while (k < length) {
                        int[] nArray = invUm.matrix[j];
                        int n3 = k;
                        nArray[n3] = nArray[n3] ^ invUm.matrix[i3][k];
                        ++k;
                    }
                }
                --j;
            }
            --i3;
        }
        result[1] = (GF2Matrix)invUm.rightMultiply(invLm.rightMultiply(p));
        return result;
    }

    public int[][] getIntArray() {
        return this.matrix;
    }

    public int getLength() {
        return this.length;
    }

    public int[] getRow(int index) {
        return this.matrix[index];
    }

    public byte[] getEncoded() {
        int n = this.numColumns + 7 >>> 3;
        n *= this.numRows;
        byte[] enc = new byte[n += 8];
        LittleEndianConversions.I2OSP(this.numRows, enc, 0);
        LittleEndianConversions.I2OSP(this.numColumns, enc, 4);
        int q = this.numColumns >>> 5;
        int r = this.numColumns & 0x1F;
        int count = 8;
        int i = 0;
        while (i < this.numRows) {
            int j = 0;
            while (j < q) {
                LittleEndianConversions.I2OSP(this.matrix[i][j], enc, count);
                ++j;
                count += 4;
            }
            int j2 = 0;
            while (j2 < r) {
                enc[count++] = (byte)(this.matrix[i][q] >>> j2 & 0xFF);
                j2 += 8;
            }
            ++i;
        }
        return enc;
    }

    public boolean isZero() {
        int i = 0;
        while (i < this.numRows) {
            int j = 0;
            while (j < this.length) {
                if (this.matrix[i][j] != 0) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public GF2Matrix getLeftSubMatrix() {
        if (this.numColumns <= this.numRows) {
            throw new ArithmeticException("empty submatrix");
        }
        int length = this.numRows + 31 >> 5;
        int[][] result = new int[this.numRows][length];
        int bitMask = (1 << (this.numRows & 0x1F)) - 1;
        if (bitMask == 0) {
            bitMask = -1;
        }
        int i = this.numRows - 1;
        while (i >= 0) {
            System.arraycopy(this.matrix[i], 0, result[i], 0, length);
            int[] nArray = result[i];
            int n = length - 1;
            nArray[n] = nArray[n] & bitMask;
            --i;
        }
        return new GF2Matrix(this.numRows, result);
    }

    public GF2Matrix extendLeftCompactForm() {
        int newNumColumns = this.numColumns + this.numRows;
        GF2Matrix result = new GF2Matrix(this.numRows, newNumColumns);
        int ind = this.numRows - 1 + this.numColumns;
        int i = this.numRows - 1;
        while (i >= 0) {
            System.arraycopy(this.matrix[i], 0, result.matrix[i], 0, this.length);
            int[] nArray = result.matrix[i];
            int n = ind >> 5;
            nArray[n] = nArray[n] | 1 << (ind & 0x1F);
            --i;
            --ind;
        }
        return result;
    }

    public GF2Matrix getRightSubMatrix() {
        if (this.numColumns <= this.numRows) {
            throw new ArithmeticException("empty submatrix");
        }
        int q = this.numRows >> 5;
        int r = this.numRows & 0x1F;
        GF2Matrix result = new GF2Matrix(this.numRows, this.numColumns - this.numRows);
        int i = this.numRows - 1;
        while (i >= 0) {
            if (r != 0) {
                int ind = q;
                int j = 0;
                while (j < result.length - 1) {
                    result.matrix[i][j] = this.matrix[i][ind++] >>> r | this.matrix[i][ind] << 32 - r;
                    ++j;
                }
                result.matrix[i][result.length - 1] = this.matrix[i][ind++] >>> r;
                if (ind < this.length) {
                    int[] nArray = result.matrix[i];
                    int n = result.length - 1;
                    nArray[n] = nArray[n] | this.matrix[i][ind] << 32 - r;
                }
            } else {
                System.arraycopy(this.matrix[i], q, result.matrix[i], 0, result.length);
            }
            --i;
        }
        return result;
    }

    public GF2Matrix extendRightCompactForm() {
        GF2Matrix result = new GF2Matrix(this.numRows, this.numRows + this.numColumns);
        int q = this.numRows >> 5;
        int r = this.numRows & 0x1F;
        int i = this.numRows - 1;
        while (i >= 0) {
            int[] nArray = result.matrix[i];
            int n = i >> 5;
            nArray[n] = nArray[n] | 1 << (i & 0x1F);
            if (r != 0) {
                int mw;
                int ind = q;
                int j = 0;
                while (j < this.length - 1) {
                    mw = this.matrix[i][j];
                    int[] nArray2 = result.matrix[i];
                    int n2 = ind++;
                    nArray2[n2] = nArray2[n2] | mw << r;
                    int[] nArray3 = result.matrix[i];
                    int n3 = ind;
                    nArray3[n3] = nArray3[n3] | mw >>> 32 - r;
                    ++j;
                }
                mw = this.matrix[i][this.length - 1];
                int[] nArray4 = result.matrix[i];
                int n4 = ind++;
                nArray4[n4] = nArray4[n4] | mw << r;
                if (ind < result.length) {
                    int[] nArray5 = result.matrix[i];
                    int n5 = ind;
                    nArray5[n5] = nArray5[n5] | mw >>> 32 - r;
                }
            } else {
                System.arraycopy(this.matrix[i], 0, result.matrix[i], q, this.length);
            }
            --i;
        }
        return result;
    }

    public Matrix computeTranspose() {
        int[][] result = new int[this.numColumns][this.numRows + 31 >>> 5];
        int i = 0;
        while (i < this.numRows) {
            int j = 0;
            while (j < this.numColumns) {
                int qs = j >>> 5;
                int rs = j & 0x1F;
                int b = this.matrix[i][qs] >>> rs & 1;
                int qt = i >>> 5;
                int rt = i & 0x1F;
                if (b == 1) {
                    int[] nArray = result[j];
                    int n = qt;
                    nArray[n] = nArray[n] | 1 << rt;
                }
                ++j;
            }
            ++i;
        }
        return new GF2Matrix(this.numRows, result);
    }

    public Matrix computeInverse() {
        if (this.numRows != this.numColumns) {
            throw new ArithmeticException("Matrix is not invertible.");
        }
        int[][] tmpMatrix = new int[this.numRows][this.length];
        int i = this.numRows - 1;
        while (i >= 0) {
            tmpMatrix[i] = IntUtils.clone(this.matrix[i]);
            --i;
        }
        int[][] invMatrix = new int[this.numRows][this.length];
        int i2 = this.numRows - 1;
        while (i2 >= 0) {
            int q = i2 >> 5;
            int r = i2 & 0x1F;
            invMatrix[i2][q] = 1 << r;
            --i2;
        }
        int i3 = 0;
        while (i3 < this.numRows) {
            int q = i3 >> 5;
            int bitMask = 1 << (i3 & 0x1F);
            if ((tmpMatrix[i3][q] & bitMask) == 0) {
                boolean foundNonZero = false;
                int j = i3 + 1;
                while (j < this.numRows) {
                    if ((tmpMatrix[j][q] & bitMask) != 0) {
                        foundNonZero = true;
                        GF2Matrix.swapRows(tmpMatrix, i3, j);
                        GF2Matrix.swapRows(invMatrix, i3, j);
                        j = this.numRows;
                    }
                    ++j;
                }
                if (!foundNonZero) {
                    throw new ArithmeticException("Matrix is not invertible.");
                }
            }
            int j = this.numRows - 1;
            while (j >= 0) {
                if (j != i3 && (tmpMatrix[j][q] & bitMask) != 0) {
                    GF2Matrix.addToRow(tmpMatrix[i3], tmpMatrix[j], q);
                    GF2Matrix.addToRow(invMatrix[i3], invMatrix[j], 0);
                }
                --j;
            }
            ++i3;
        }
        return new GF2Matrix(this.numColumns, invMatrix);
    }

    public Matrix leftMultiply(Permutation p) {
        int[] pVec = p.getVector();
        if (pVec.length != this.numRows) {
            throw new ArithmeticException("length mismatch");
        }
        int[][] result = new int[this.numRows][];
        int i = this.numRows - 1;
        while (i >= 0) {
            result[i] = IntUtils.clone(this.matrix[pVec[i]]);
            --i;
        }
        return new GF2Matrix(this.numRows, result);
    }

    public Vector leftMultiply(Vector vec) {
        int j;
        int b;
        int bitMask;
        if (!(vec instanceof GF2Vector)) {
            throw new ArithmeticException("vector is not defined over GF(2)");
        }
        if (vec.length != this.numRows) {
            throw new ArithmeticException("length mismatch");
        }
        int[] v = ((GF2Vector)vec).getVecArray();
        int[] res = new int[this.length];
        int q = this.numRows >> 5;
        int r = 1 << (this.numRows & 0x1F);
        int row = 0;
        int i = 0;
        while (i < q) {
            bitMask = 1;
            do {
                if ((b = v[i] & bitMask) != 0) {
                    j = 0;
                    while (j < this.length) {
                        int n = j;
                        res[n] = res[n] ^ this.matrix[row][j];
                        ++j;
                    }
                }
                ++row;
            } while ((bitMask <<= 1) != 0);
            ++i;
        }
        bitMask = 1;
        while (bitMask != r) {
            b = v[q] & bitMask;
            if (b != 0) {
                j = 0;
                while (j < this.length) {
                    int n = j;
                    res[n] = res[n] ^ this.matrix[row][j];
                    ++j;
                }
            }
            ++row;
            bitMask <<= 1;
        }
        return new GF2Vector(res, this.numColumns);
    }

    public Vector leftMultiplyLeftCompactForm(Vector vec) {
        if (!(vec instanceof GF2Vector)) {
            throw new ArithmeticException("vector is not defined over GF(2)");
        }
        if (vec.length != this.numRows) {
            throw new ArithmeticException("length mismatch");
        }
        int[] v = ((GF2Vector)vec).getVecArray();
        int[] res = new int[this.numRows + this.numColumns + 31 >>> 5];
        int words = this.numRows >>> 5;
        int row = 0;
        int i = 0;
        while (i < words) {
            int bitMask = 1;
            do {
                int b;
                if ((b = v[i] & bitMask) != 0) {
                    int j = 0;
                    while (j < this.length) {
                        int n = j;
                        res[n] = res[n] ^ this.matrix[row][j];
                        ++j;
                    }
                    int q = this.numColumns + row >>> 5;
                    int r = this.numColumns + row & 0x1F;
                    int n = q;
                    res[n] = res[n] | 1 << r;
                }
                ++row;
            } while ((bitMask <<= 1) != 0);
            ++i;
        }
        int rem = 1 << (this.numRows & 0x1F);
        int bitMask = 1;
        while (bitMask != rem) {
            int b = v[words] & bitMask;
            if (b != 0) {
                int j = 0;
                while (j < this.length) {
                    int n = j;
                    res[n] = res[n] ^ this.matrix[row][j];
                    ++j;
                }
                int q = this.numColumns + row >>> 5;
                int r = this.numColumns + row & 0x1F;
                int n = q;
                res[n] = res[n] | 1 << r;
            }
            ++row;
            bitMask <<= 1;
        }
        return new GF2Vector(res, this.numRows + this.numColumns);
    }

    public Matrix rightMultiply(Matrix mat) {
        if (!(mat instanceof GF2Matrix)) {
            throw new ArithmeticException("matrix is not defined over GF(2)");
        }
        if (mat.numRows != this.numColumns) {
            throw new ArithmeticException("length mismatch");
        }
        GF2Matrix a = (GF2Matrix)mat;
        GF2Matrix result = new GF2Matrix(this.numRows, mat.numColumns);
        int rest = this.numColumns & 0x1F;
        int d = rest == 0 ? this.length : this.length - 1;
        int i = 0;
        while (i < this.numRows) {
            int g;
            int b;
            int h;
            int e;
            int count = 0;
            int j = 0;
            while (j < d) {
                e = this.matrix[i][j];
                h = 0;
                while (h < 32) {
                    b = e & 1 << h;
                    if (b != 0) {
                        g = 0;
                        while (g < a.length) {
                            int[] nArray = result.matrix[i];
                            int n = g;
                            nArray[n] = nArray[n] ^ a.matrix[count][g];
                            ++g;
                        }
                    }
                    ++count;
                    ++h;
                }
                ++j;
            }
            e = this.matrix[i][this.length - 1];
            h = 0;
            while (h < rest) {
                b = e & 1 << h;
                if (b != 0) {
                    g = 0;
                    while (g < a.length) {
                        int[] nArray = result.matrix[i];
                        int n = g;
                        nArray[n] = nArray[n] ^ a.matrix[count][g];
                        ++g;
                    }
                }
                ++count;
                ++h;
            }
            ++i;
        }
        return result;
    }

    public Matrix rightMultiply(Permutation p) {
        int[] pVec = p.getVector();
        if (pVec.length != this.numColumns) {
            throw new ArithmeticException("length mismatch");
        }
        GF2Matrix result = new GF2Matrix(this.numRows, this.numColumns);
        int i = this.numColumns - 1;
        while (i >= 0) {
            int q = i >>> 5;
            int r = i & 0x1F;
            int pq = pVec[i] >>> 5;
            int pr = pVec[i] & 0x1F;
            int j = this.numRows - 1;
            while (j >= 0) {
                int[] nArray = result.matrix[j];
                int n = q;
                nArray[n] = nArray[n] | (this.matrix[j][pq] >>> pr & 1) << r;
                --j;
            }
            --i;
        }
        return result;
    }

    public Vector rightMultiply(Vector vec) {
        if (!(vec instanceof GF2Vector)) {
            throw new ArithmeticException("vector is not defined over GF(2)");
        }
        if (vec.length != this.numColumns) {
            throw new ArithmeticException("length mismatch");
        }
        int[] v = ((GF2Vector)vec).getVecArray();
        int[] res = new int[this.numRows + 31 >>> 5];
        int i = 0;
        while (i < this.numRows) {
            int help = 0;
            int j = 0;
            while (j < this.length) {
                help ^= this.matrix[i][j] & v[j];
                ++j;
            }
            int bitValue = 0;
            int j2 = 0;
            while (j2 < 32) {
                bitValue ^= help >>> j2 & 1;
                ++j2;
            }
            if (bitValue == 1) {
                int n = i >>> 5;
                res[n] = res[n] | 1 << (i & 0x1F);
            }
            ++i;
        }
        return new GF2Vector(res, this.numRows);
    }

    public Vector rightMultiplyRightCompactForm(Vector vec) {
        if (!(vec instanceof GF2Vector)) {
            throw new ArithmeticException("vector is not defined over GF(2)");
        }
        if (vec.length != this.numColumns + this.numRows) {
            throw new ArithmeticException("length mismatch");
        }
        int[] v = ((GF2Vector)vec).getVecArray();
        int[] res = new int[this.numRows + 31 >>> 5];
        int q = this.numRows >> 5;
        int r = this.numRows & 0x1F;
        int i = 0;
        while (i < this.numRows) {
            int j;
            int help = v[i >> 5] >>> (i & 0x1F) & 1;
            int vInd = q;
            if (r != 0) {
                int vw = 0;
                j = 0;
                while (j < this.length - 1) {
                    vw = v[vInd++] >>> r | v[vInd] << 32 - r;
                    help ^= this.matrix[i][j] & vw;
                    ++j;
                }
                vw = v[vInd++] >>> r;
                if (vInd < v.length) {
                    vw |= v[vInd] << 32 - r;
                }
                help ^= this.matrix[i][this.length - 1] & vw;
            } else {
                int j2 = 0;
                while (j2 < this.length) {
                    help ^= this.matrix[i][j2] & v[vInd++];
                    ++j2;
                }
            }
            int bitValue = 0;
            j = 0;
            while (j < 32) {
                bitValue ^= help & 1;
                help >>>= 1;
                ++j;
            }
            if (bitValue == 1) {
                int n = i >> 5;
                res[n] = res[n] | 1 << (i & 0x1F);
            }
            ++i;
        }
        return new GF2Vector(res, this.numRows);
    }

    public boolean equals(Object other) {
        if (!(other instanceof GF2Matrix)) {
            return false;
        }
        GF2Matrix otherMatrix = (GF2Matrix)other;
        if (this.numRows != otherMatrix.numRows || this.numColumns != otherMatrix.numColumns || this.length != otherMatrix.length) {
            return false;
        }
        int i = 0;
        while (i < this.numRows) {
            if (!IntUtils.equals(this.matrix[i], otherMatrix.matrix[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int hash = (this.numRows * 31 + this.numColumns) * 31 + this.length;
        int i = 0;
        while (i < this.numRows) {
            hash = hash * 31 + this.matrix[i].hashCode();
            ++i;
        }
        return hash;
    }

    public String toString() {
        int rest = this.numColumns & 0x1F;
        int d = rest == 0 ? this.length : this.length - 1;
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.numRows) {
            int b;
            int k;
            int a;
            buf.append(i + ": ");
            int j = 0;
            while (j < d) {
                a = this.matrix[i][j];
                k = 0;
                while (k < 32) {
                    b = a >>> k & 1;
                    if (b == 0) {
                        buf.append('0');
                    } else {
                        buf.append('1');
                    }
                    ++k;
                }
                buf.append(' ');
                ++j;
            }
            a = this.matrix[i][this.length - 1];
            k = 0;
            while (k < rest) {
                b = a >>> k & 1;
                if (b == 0) {
                    buf.append('0');
                } else {
                    buf.append('1');
                }
                ++k;
            }
            buf.append('\n');
            ++i;
        }
        return buf.toString();
    }

    private static void swapRows(int[][] matrix, int first, int second) {
        int[] tmp = matrix[first];
        matrix[first] = matrix[second];
        matrix[second] = tmp;
    }

    private static void addToRow(int[] fromRow, int[] toRow, int startIndex) {
        int i = toRow.length - 1;
        while (i >= startIndex) {
            toRow[i] = fromRow[i] ^ toRow[i];
            --i;
        }
    }
}

