/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.common.math.polynomials;

import de.flexiprovider.api.Registry;
import de.flexiprovider.api.SecureRandom;
import de.flexiprovider.common.math.polynomials.ConvolutionPolynomial;
import de.flexiprovider.common.util.IntUtils;

public class BinaryConvolutionPolynomial
implements ConvolutionPolynomial {
    int N;
    int degree;
    int[] coefficients;

    public BinaryConvolutionPolynomial(int N, int[] coefficients) throws IllegalArgumentException {
        this.N = N;
        this.degree = this.computeDegree(coefficients);
        if (this.degree >= N) {
            throw new IllegalArgumentException("Degree is >= N.");
        }
        this.coefficients = IntUtils.clone(coefficients);
    }

    public BinaryConvolutionPolynomial(int N, int d, SecureRandom sr) {
        this.N = N < 0 ? 1 : N;
        int thisD = d;
        if (thisD < 0) {
            thisD = 0;
        }
        if (thisD > N + 1) {
            thisD = N + 1;
        }
        if (sr == null) {
            sr = Registry.getSecureRandom();
        }
        int[] index = new int[N];
        int i = 0;
        while (i < N) {
            index[i] = i;
            ++i;
        }
        this.coefficients = new int[N + 31 >>> 5];
        int k = N;
        int i2 = 0;
        while (i2 < d) {
            int n = sr.nextInt(k);
            this.setCoefficient(index[n]);
            index[n] = index[--k];
            ++i2;
        }
        this.computeDegree();
    }

    public BinaryConvolutionPolynomial(BinaryConvolutionPolynomial other) {
        this.N = other.N;
        this.degree = other.degree;
        this.coefficients = IntUtils.clone(other.coefficients);
    }

    public void setCoefficient(int index) {
        if (index < 0 || index >= this.N) {
            return;
        }
        int n = index >>> 5;
        this.coefficients[n] = this.coefficients[n] | 1 << (index & 0x1F);
    }

    public boolean testCoefficient(int index) {
        if (index < 0 || index > this.degree) {
            return false;
        }
        return (this.coefficients[index >>> 5] & 1 << (index & 0x1F)) != 0;
    }

    int[][] getPatternLocations(int w) {
        int numCoeffs = this.numCoeffs();
        int[][] locations = new int[w][(numCoeffs >> 1) + 2];
        locations[0] = new int[numCoeffs + 1];
        int currentPos = this.degree;
        while (currentPos > 0) {
            boolean patternFound = false;
            if (this.testCoefficient(currentPos)) {
                int j = 1;
                while (j < w) {
                    if (this.testCoefficient(currentPos - j)) {
                        int[] nArray = locations[j];
                        int n = nArray[0];
                        nArray[0] = n + 1;
                        locations[j][n + 1] = currentPos;
                        currentPos -= j + 1;
                        patternFound = true;
                        break;
                    }
                    ++j;
                }
                if (patternFound) continue;
                int[] nArray = locations[0];
                int n = nArray[0];
                nArray[0] = n + 1;
                locations[0][n + 1] = currentPos;
                currentPos -= w;
                continue;
            }
            --currentPos;
        }
        if (currentPos == 0 && this.testCoefficient(0)) {
            int[] nArray = locations[0];
            int n = nArray[0];
            nArray[0] = n + 1;
            locations[0][n + 1] = 0;
        }
        return locations;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof BinaryConvolutionPolynomial)) {
            return false;
        }
        BinaryConvolutionPolynomial otherPol = (BinaryConvolutionPolynomial)other;
        return this.N == otherPol.N && this.degree == otherPol.degree && IntUtils.equals(this.coefficients, otherPol.coefficients);
    }

    public int hashCode() {
        return this.N + this.degree + this.coefficients.hashCode();
    }

    public String toString() {
        String result = "BinaryConvolutionPolynomial (degree " + this.degree + "):\n";
        result = result + "x^" + this.degree;
        int i = this.degree - 1;
        while (i >= 0) {
            if (this.testCoefficient(i)) {
                result = result + " + x^" + i;
            }
            --i;
        }
        result = result + "\n";
        int i2 = this.degree;
        while (i2 >= 0) {
            result = result + (this.testCoefficient(i2) ? "1" : "0");
            --i2;
        }
        return result;
    }

    private void computeDegree() {
        this.degree = (this.coefficients.length << 5) - 1;
        while (!this.testCoefficient(this.degree)) {
            --this.degree;
        }
    }

    private int computeDegree(int[] coefficients) {
        int degree = (coefficients.length << 5) - 1;
        while (!this.testCoefficient(degree)) {
            --degree;
        }
        return degree;
    }

    int numCoeffs() {
        int numCoeffs = 0;
        int i = this.degree;
        while (i >= 0) {
            if (this.testCoefficient(i)) {
                ++numCoeffs;
            }
            --i;
        }
        return numCoeffs;
    }
}

