/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.common.math.polynomials;

import de.flexiprovider.api.SecureRandom;
import de.flexiprovider.common.math.IntegerFunctions;
import de.flexiprovider.common.math.polynomials.ConvolutionPolynomial;
import de.flexiprovider.common.math.polynomials.SparseBinaryConvolutionPolynomial;

public class ProductFormConvolutionPolynomial
implements ConvolutionPolynomial {
    int N;
    SparseBinaryConvolutionPolynomial f1;
    SparseBinaryConvolutionPolynomial f2;
    SparseBinaryConvolutionPolynomial f3;

    public ProductFormConvolutionPolynomial(int N, int d1, int d2, int d3, SecureRandom sr) {
        this.N = N < 0 ? 0 : N;
        this.f1 = new SparseBinaryConvolutionPolynomial(N, d1, sr);
        this.f2 = new SparseBinaryConvolutionPolynomial(N, d2, sr);
        this.f3 = new SparseBinaryConvolutionPolynomial(N, d3, sr);
    }

    public ProductFormConvolutionPolynomial(SparseBinaryConvolutionPolynomial f1, SparseBinaryConvolutionPolynomial f2, SparseBinaryConvolutionPolynomial f3) throws ArithmeticException {
        if (f1.N != f2.N || f1.N != f3.N) {
            throw new ArithmeticException("Binary polynomials are not elements of the same ring.");
        }
        this.N = f1.N;
        this.f1 = f1;
        this.f2 = f2;
        this.f3 = f3;
    }

    public ProductFormConvolutionPolynomial(ProductFormConvolutionPolynomial other) {
        this.N = other.N;
        this.f1 = new SparseBinaryConvolutionPolynomial(other.f1);
        this.f2 = new SparseBinaryConvolutionPolynomial(other.f2);
        this.f3 = new SparseBinaryConvolutionPolynomial(other.f3);
    }

    private ProductFormConvolutionPolynomial(int N, int d1, int d2, int d3, byte[] enc1, byte[] enc2, byte[] enc3) throws IllegalArgumentException {
        this.N = N;
        this.f1 = SparseBinaryConvolutionPolynomial.OS2REP(N, d1, enc1);
        this.f2 = SparseBinaryConvolutionPolynomial.OS2REP(N, d2, enc2);
        this.f3 = SparseBinaryConvolutionPolynomial.OS2REP(N, d3, enc3);
    }

    public byte[] RE2OSP(int N) throws ArithmeticException {
        if (this.N != N) {
            throw new ArithmeticException("Not an element of Z(X)/(X^N-1).");
        }
        byte[] enc1 = this.f1.RE2OSP();
        byte[] enc2 = this.f2.RE2OSP();
        byte[] enc3 = this.f3.RE2OSP();
        byte[] result = new byte[enc1.length + enc2.length + enc3.length];
        System.arraycopy(enc1, 0, result, 0, enc1.length);
        System.arraycopy(enc2, 0, result, enc1.length, enc2.length);
        System.arraycopy(enc3, 0, result, enc1.length + enc2.length, enc3.length);
        return result;
    }

    public static ProductFormConvolutionPolynomial OS2REP(int N, int q, int d1, int d2, int d3, byte[] encoded) throws IllegalArgumentException {
        int oLen = IntegerFunctions.ceilLog256(N - 1);
        if (encoded.length != oLen * (d1 + d2 + d3)) {
            throw new IllegalArgumentException("Encoded product form polynomial has wrong length.");
        }
        if (q == 0) {
            q = 2;
        }
        if (q < 0) {
            q = -q;
        }
        byte[] enc1 = new byte[oLen * d1];
        byte[] enc2 = new byte[oLen * d2];
        byte[] enc3 = new byte[oLen * d3];
        System.arraycopy(encoded, 0, enc1, 0, enc1.length);
        System.arraycopy(encoded, enc1.length, enc2, 0, enc2.length);
        System.arraycopy(encoded, enc1.length + enc2.length, enc3, 0, enc3.length);
        return new ProductFormConvolutionPolynomial(N, d1, d2, d3, enc1, enc2, enc3);
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof ProductFormConvolutionPolynomial)) {
            return false;
        }
        ProductFormConvolutionPolynomial otherPol = (ProductFormConvolutionPolynomial)other;
        return this.N == otherPol.N && this.f1.equals(otherPol.f1) && this.f2.equals(otherPol.f2) && this.f3.equals(otherPol.f3);
    }

    public int hashCode() {
        return this.N + this.f1.hashCode() + this.f2.hashCode() + this.f3.hashCode();
    }

    public String toString() {
        String result = "ModQPolynomialProductForm (degree " + this.N + "):\n";
        result = result + "Polynomial f1: " + this.f1 + "\n";
        result = result + "Polynomial f2: " + this.f2 + "\n";
        result = result + "Polynomial f3: " + this.f3;
        return result;
    }
}

