/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.common.math.quadraticfields;

import de.flexiprovider.api.Registry;
import de.flexiprovider.api.SecureRandom;
import de.flexiprovider.api.exceptions.InvalidParameterException;
import de.flexiprovider.common.exceptions.NoQuadraticResidueException;
import de.flexiprovider.common.math.FlexiBigInt;
import de.flexiprovider.common.math.IntegerFunctions;
import de.flexiprovider.common.math.quadraticfields.QuadraticIdeal;

public class IQClassGroup {
    private static final int PRIME_CERTAINTY = 15;
    private static final int RANDOM_PRIME_POWER_IDEAL_EXPONENT = 5;
    private static final int RANDOM_PRIME_POWER_IDEAL_BITLENGTH = 70;
    private static final int RANDOM_IDEAL_ITERATIONS = 4;
    private SecureRandom prng;
    private FlexiBigInt discriminant;
    private final boolean reduceFlag = true;
    private FlexiBigInt sqrtDeltaThirds = null;
    private FlexiBigInt sqrtDeltaHalves = null;

    public IQClassGroup(FlexiBigInt discriminant, SecureRandom prng) {
        this.prng = prng == null ? Registry.getSecureRandom() : prng;
        this.discriminant = discriminant;
    }

    public IQClassGroup(FlexiBigInt discriminant) {
        this(discriminant, null);
    }

    public IQClassGroup(int bits, boolean primeDiscriminant, SecureRandom prng) {
        this.prng = prng == null ? Registry.getSecureRandom() : prng;
        do {
            this.discriminant = new FlexiBigInt(bits, this.prng).or(FlexiBigInt.valueOf(3L));
            this.discriminant = this.discriminant.setBit(bits - 1);
            if (!primeDiscriminant) continue;
            while (!this.discriminant.isProbablePrime(15)) {
                this.discriminant = this.discriminant.add(FlexiBigInt.valueOf(4L));
            }
        } while (this.discriminant.bitLength() != bits);
        this.discriminant = this.discriminant.negate();
    }

    public IQClassGroup(int bits, boolean primeDiscriminant) {
        this(bits, primeDiscriminant, null);
    }

    public FlexiBigInt getDiscriminant() {
        return this.discriminant;
    }

    public boolean isReduced(QuadraticIdeal I) {
        if (this.sqrtDeltaThirds == null) {
            this.sqrtDeltaThirds = IntegerFunctions.squareRoot(this.discriminant.abs().divide(FlexiBigInt.valueOf(3L)));
        }
        if (this.sqrtDeltaHalves == null) {
            this.sqrtDeltaHalves = IntegerFunctions.squareRoot(this.discriminant.abs().divide(FlexiBigInt.valueOf(2L)));
        }
        if (I.a.signum() <= 0 || I.a.compareTo(this.sqrtDeltaThirds) > 0) {
            return false;
        }
        if (I.b.compareTo(I.a.negate()) < 0 || I.b.compareTo(I.a) > 0) {
            return false;
        }
        if (I.a.compareTo(this.sqrtDeltaHalves) <= 0) {
            return true;
        }
        FlexiBigInt c = I.b.multiply(I.b).subtract(this.discriminant);
        if (I.a.compareTo(c = c.divide(I.a).divide(FlexiBigInt.valueOf(4L))) > 0) {
            return false;
        }
        return I.a.compareTo(c) != 0 || I.b.signum() >= 0;
    }

    public boolean isValid(QuadraticIdeal I) {
        FlexiBigInt tmp = I.b.multiply(I.b).subtract(this.discriminant);
        return tmp.remainder(I.a.multiply(FlexiBigInt.valueOf(4L))).signum() == 0;
    }

    private QuadraticIdeal reduce(FlexiBigInt a, FlexiBigInt b) {
        FlexiBigInt c;
        int sign = 1;
        if (a.compareTo(b) < 0 || a.negate().compareTo(b) >= 0) {
            b = a.subtract(a.subtract(b).mod(a.shiftLeft(1)));
        }
        if (b.signum() < 0) {
            b = b.abs();
            sign = -1;
        }
        if ((c = b.multiply(b).subtract(this.discriminant)).remainder(a.shiftLeft(2)).signum() != 0) {
            throw new InvalidParameterException("invalid ideal");
        }
        c = c.divide(a.shiftLeft(2));
        while (a.compareTo(c) > 0) {
            FlexiBigInt r;
            FlexiBigInt q;
            FlexiBigInt t = a;
            a = c;
            FlexiBigInt t1 = a.shiftLeft(1);
            if (b.bitLength() - t1.bitLength() > 2) {
                FlexiBigInt[] qr = b.divideAndRemainder(t1);
                q = qr[0];
                r = qr[1];
            } else {
                r = b;
                int q_int = 0;
                while (r.compareTo(t1) > 0) {
                    r = r.subtract(t1);
                    ++q_int;
                }
                q = FlexiBigInt.valueOf(q_int);
            }
            c = t.subtract(q.multiply(r.add(b)).shiftRight(1));
            if (a.compareTo(r) < 0) {
                b = t1.subtract(r);
                c = c.add(a).subtract(r);
                continue;
            }
            b = r;
            sign = -sign;
        }
        if (sign < 0) {
            b = b.negate();
        }
        if (a.compareTo(b) < 0 || a.negate().compareTo(b) >= 0) {
            b = a.subtract(a.subtract(b).remainder(a.shiftLeft(1)));
        }
        if (a.equals(c) && b.signum() < 0) {
            b = b.negate();
        }
        return new QuadraticIdeal(a, b);
    }

    public QuadraticIdeal reduce(QuadraticIdeal I) {
        return this.reduce(I.a, I.b);
    }

    public QuadraticIdeal invert(QuadraticIdeal I) {
        return new QuadraticIdeal(I.a, I.b.negate());
    }

    public QuadraticIdeal multiply(FlexiBigInt a1, FlexiBigInt b1, FlexiBigInt a2, FlexiBigInt b2) {
        FlexiBigInt[] temp = new FlexiBigInt[3];
        temp = IntegerFunctions.extgcd(a1, a2);
        FlexiBigInt d1 = temp[0];
        FlexiBigInt v = temp[1];
        FlexiBigInt w = temp[2];
        FlexiBigInt tb = a1.multiply(v).multiply(b2.subtract(b1));
        FlexiBigInt a3 = a1.multiply(a2);
        if (d1.compareTo(FlexiBigInt.ONE) != 0) {
            FlexiBigInt t1 = b1.add(b2).shiftRight(1);
            temp = IntegerFunctions.extgcd(d1, t1);
            FlexiBigInt d2 = temp[0];
            v = temp[1];
            w = temp[2];
            t1 = this.discriminant.subtract(b1.multiply(b1)).multiply(w);
            tb = t1.shiftRight(1).add(v.multiply(tb)).divide(d2);
            a3 = a3.divide(d2.multiply(d2));
        }
        FlexiBigInt b3 = b1.add(tb).mod(a3.shiftLeft(1));
        return this.reduce(a3, b3);
    }

    public QuadraticIdeal multiply(QuadraticIdeal I1, QuadraticIdeal I2) {
        return this.multiply(I1.a, I1.b, I2.a, I2.b);
    }

    public QuadraticIdeal divide(QuadraticIdeal I1, QuadraticIdeal I2) {
        return this.multiply(I1.a, I1.b, I2.a, I2.b.negate());
    }

    public QuadraticIdeal square(FlexiBigInt a, FlexiBigInt b) {
        FlexiBigInt[] temp = new FlexiBigInt[3];
        temp = IntegerFunctions.extgcd(a, b);
        FlexiBigInt d1 = temp[0];
        FlexiBigInt w = temp[2];
        FlexiBigInt a3 = a.divide(d1);
        a3 = a3.multiply(a3);
        FlexiBigInt t1 = this.discriminant.subtract(b.multiply(b)).divide(d1.shiftLeft(1));
        t1 = t1.multiply(w).add(b);
        FlexiBigInt b3 = t1.mod(a3.shiftLeft(1));
        return this.reduce(a3, b3);
    }

    public QuadraticIdeal square(QuadraticIdeal I) {
        return this.square(I.a, I.b);
    }

    public QuadraticIdeal one() {
        return new QuadraticIdeal(1, this.discriminant.testBit(0) ? 1 : 0);
    }

    public boolean isOne(QuadraticIdeal I) {
        return I.a.equals(FlexiBigInt.ONE) && !(this.discriminant.testBit(0) ^ I.b.equals(FlexiBigInt.ONE));
    }

    public QuadraticIdeal power(QuadraticIdeal I, FlexiBigInt n) {
        int sign;
        QuadraticIdeal T = this.one();
        if (n.signum() < 0) {
            n = n.abs();
            sign = -1;
        } else {
            sign = 1;
        }
        int t = n.bitLength();
        int c = 0;
        int e = n.testBit(0) ? 1 : 0;
        QuadraticIdeal T2 = I;
        int i = 0;
        while (i <= t) {
            int en = n.testBit(i + 1) ? 1 : 0;
            int cn = e + en + c >> 1;
            int d = e + c - 2 * cn;
            if (d > 0) {
                T = this.multiply(T, T2);
            } else if (d < 0) {
                T = this.divide(T, T2);
            }
            e = en;
            c = cn;
            T2 = this.square(T2);
            ++i;
        }
        return sign < 0 ? this.invert(T) : T;
    }

    public QuadraticIdeal power(QuadraticIdeal[] powI, FlexiBigInt n) {
        int sign;
        QuadraticIdeal T = this.one();
        if (n.signum() < 0) {
            n = n.abs();
            sign = -1;
        } else {
            sign = 1;
        }
        int t = n.bitLength();
        int c = 0;
        int e = n.testBit(0) ? 1 : 0;
        int i = 0;
        while (i <= t) {
            int en = n.testBit(i + 1) ? 1 : 0;
            int cn = e + en + c >> 1;
            int d = e + c - 2 * cn;
            if (d > 0) {
                T = this.multiply(T, powI[i]);
            } else if (d < 0) {
                T = this.divide(T, powI[i]);
            }
            e = en;
            c = cn;
            ++i;
        }
        return sign < 0 ? this.invert(T) : T;
    }

    public QuadraticIdeal[] precomputeGordonBrickell(QuadraticIdeal I, int n) {
        QuadraticIdeal[] powI = new QuadraticIdeal[n];
        int i = 0;
        while (i < n) {
            powI[i] = I;
            I = this.square(I);
            ++i;
        }
        return powI;
    }

    private int[] determineNAF(FlexiBigInt e, int wi, int b) {
        int power2wi = 1 << wi;
        int[] N = new int[b + 1];
        FlexiBigInt c = e.abs();
        int s = e.signum();
        int j = 0;
        while (c.signum() > 0) {
            int u;
            if (c.testBit(0)) {
                u = c.intValue() & (power2wi << 1) - 1;
                if ((u & power2wi) != 0) {
                    u -= power2wi << 1;
                }
                c = c.subtract(FlexiBigInt.valueOf(u));
            } else {
                u = 0;
            }
            N[j++] = s > 0 ? u : -u;
            c = c.shiftRight(1);
        }
        while (j <= b) {
            N[j++] = 0;
        }
        return N;
    }

    public QuadraticIdeal[][] precomputeSimPowerWNAF(QuadraticIdeal[] g, int w) {
        int power2w = 1 << w + 1;
        int count = power2w >> 1;
        QuadraticIdeal[][] gE = new QuadraticIdeal[g.length][count];
        int i = 0;
        while (i < g.length) {
            QuadraticIdeal A = this.square(g[i]);
            gE[i][0] = g[i];
            int j = 1;
            while (j < count) {
                gE[i][j] = this.multiply(gE[i][j - 1], A);
                ++j;
            }
            ++i;
        }
        return gE;
    }

    public QuadraticIdeal simPowerWNAF(QuadraticIdeal[][] gLUT, FlexiBigInt[] e, int w) {
        int k = e.length;
        int[][] N = new int[k][];
        int i = k - 1;
        int b = 0;
        while (i >= 0) {
            int bl = e[i].bitLength();
            if (bl > b) {
                b = bl;
            }
            --i;
        }
        i = k - 1;
        while (i >= 0) {
            N[i] = this.determineNAF(e[i], w, b);
            --i;
        }
        int j = b;
        QuadraticIdeal A = this.one();
        while (j >= 0) {
            A = this.square(A);
            i = 0;
            while (i < k) {
                int n = N[i][j];
                if (n != 0) {
                    A = n > 0 ? this.multiply(A, gLUT[i][n >> 1]) : this.divide(A, gLUT[i][-n >> 1]);
                }
                ++i;
            }
            --j;
        }
        return A;
    }

    public QuadraticIdeal simPower(QuadraticIdeal[] I, FlexiBigInt[] n) {
        int j;
        int l;
        int[] lut = new int[16];
        int maxBitLength = 0;
        FlexiBigInt[] e = new FlexiBigInt[n.length];
        int i = n.length - 1;
        while (i >= 0) {
            e[i] = n[i];
            --i;
        }
        int k = I.length;
        if (k > 10 || n.length != k) {
            return this.one();
        }
        QuadraticIdeal[] Q = new QuadraticIdeal[1 << k];
        Q[0] = this.one();
        i = 0;
        while (i < k) {
            if (e[i].signum() < 0) {
                Q[1 << i] = this.invert(I[i]);
                e[i] = e[i].abs();
            } else {
                Q[1 << i] = I[i];
            }
            l = e[i].bitLength();
            if (l > maxBitLength) {
                maxBitLength = l;
            }
            ++i;
        }
        l = 2;
        while (l <= k) {
            j = 0;
            while (j < l) {
                lut[j] = j;
                ++j;
            }
            while (lut[l - 1] < k) {
                int m1 = 1 << lut[0];
                int m2 = 0;
                j = 1;
                while (j < l) {
                    m2 |= 1 << lut[j];
                    ++j;
                }
                Q[m1 + m2] = this.multiply(Q[m1], Q[m2]);
                lut[0] = lut[0] + 1;
                j = 0;
                while (j < l - 1) {
                    if (lut[j] == lut[j + 1]) {
                        lut[j] = j;
                        int n2 = j + 1;
                        lut[n2] = lut[n2] + 1;
                    }
                    ++j;
                }
            }
            ++l;
        }
        QuadraticIdeal C = this.one();
        i = maxBitLength;
        while (i >= 0) {
            int b = 0;
            j = 0;
            while (j < k) {
                if (e[j].testBit(i)) {
                    b |= 1 << j;
                }
                ++j;
            }
            C = this.square(C);
            C = this.multiply(C, Q[b]);
            --i;
        }
        return C;
    }

    public QuadraticIdeal primePowerIdeal(FlexiBigInt p, int e) throws NoQuadraticResidueException {
        FlexiBigInt a = p;
        FlexiBigInt b = IntegerFunctions.ressol(this.discriminant.mod(p), p);
        if (this.discriminant.testBit(0) != b.testBit(0)) {
            b = b.add(p);
        }
        int j = 2;
        while (j <= e) {
            FlexiBigInt s = b.modInverse(p);
            FlexiBigInt t1 = this.discriminant.subtract(b.multiply(b));
            t1 = t1.shiftRight(2).divide(a).multiply(s).mod(p);
            b = b.add(t1.multiply(a).shiftLeft(1));
            a = a.multiply(p);
            ++j;
        }
        return this.reduce(a, b);
    }

    public QuadraticIdeal randomPrimePowerIdeal(int bits, int e) {
        FlexiBigInt p;
        while (IntegerFunctions.jacobi(this.discriminant.mod(p = new FlexiBigInt(bits, 20, this.prng)), p) != 1) {
        }
        try {
            return this.primePowerIdeal(p, e);
        }
        catch (NoQuadraticResidueException nqre) {
            return this.one();
        }
    }

    public QuadraticIdeal randomIdeal() {
        QuadraticIdeal I = this.randomPrimePowerIdeal(70, this.prng.nextInt() % 5);
        int i = 0;
        while (i < 4) {
            I = this.multiply(I, this.randomPrimePowerIdeal(70, this.prng.nextInt() % 5));
            ++i;
        }
        return I;
    }
}

