/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.common.mode;

import de.flexiprovider.api.Mode;
import de.flexiprovider.api.exceptions.InvalidAlgorithmParameterException;
import de.flexiprovider.api.exceptions.InvalidKeyException;
import de.flexiprovider.api.keys.SecretKey;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.common.mode.ModeParameterSpec;

public class CBC
extends Mode {
    private byte[] buf;
    private byte[] chainingBlock;

    protected final void initEncrypt(SecretKey key, ModeParameterSpec modeParams, AlgorithmParameterSpec cipherParams) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.initCipherEncrypt(key, cipherParams);
        this.initCommon(modeParams);
    }

    protected final void initDecrypt(SecretKey key, ModeParameterSpec modeParams, AlgorithmParameterSpec cipherParams) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.initCipherDecrypt(key, cipherParams);
        this.initCommon(modeParams);
    }

    private void initCommon(ModeParameterSpec modeParams) {
        this.blockSize = this.getCipherBlockSize();
        this.iv = new byte[this.blockSize];
        if (modeParams != null) {
            byte[] iv = modeParams.getIV();
            if (iv.length < this.blockSize) {
                System.arraycopy(iv, 0, this.iv, 0, iv.length);
            } else if (iv.length > this.blockSize) {
                System.arraycopy(iv, 0, this.iv, 0, this.blockSize);
            } else {
                this.iv = iv;
            }
        }
        this.buf = new byte[this.blockSize];
        this.chainingBlock = new byte[this.blockSize];
        this.reset();
    }

    protected final void nextChunkEncrypt(byte[] input, int inOff, byte[] output, int outOff) {
        int i = this.blockSize - 1;
        while (i >= 0) {
            int n = i;
            this.chainingBlock[n] = (byte)(this.chainingBlock[n] ^ input[inOff + i]);
            --i;
        }
        this.singleBlockEncrypt(this.chainingBlock, 0, output, outOff);
        System.arraycopy(output, outOff, this.chainingBlock, 0, this.blockSize);
    }

    protected final void nextChunkDecrypt(byte[] input, int inOff, byte[] output, int outOff) {
        this.singleBlockDecrypt(input, inOff, this.buf, 0);
        int i = this.blockSize - 1;
        while (i >= 0) {
            output[outOff + i] = (byte)(this.chainingBlock[i] ^ this.buf[i]);
            --i;
        }
        System.arraycopy(input, inOff, this.chainingBlock, 0, this.blockSize);
    }

    protected final void reset() {
        System.arraycopy(this.iv, 0, this.chainingBlock, 0, this.iv.length);
    }
}

