/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.common.mode;

import de.flexiprovider.api.Mode;
import de.flexiprovider.api.exceptions.InvalidAlgorithmParameterException;
import de.flexiprovider.api.exceptions.InvalidKeyException;
import de.flexiprovider.api.keys.SecretKey;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.common.mode.CFBParameterSpec;
import de.flexiprovider.common.mode.ModeParameterSpec;
import de.flexiprovider.common.mode.OFBParameterSpec;

public class CFB
extends Mode {
    private byte[] buf;
    private byte[] feedbackBlock;

    protected final void initEncrypt(SecretKey key, ModeParameterSpec modeParams, AlgorithmParameterSpec cipherParams) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.initCipherEncrypt(key, cipherParams);
        int cipherBlockSize = this.getCipherBlockSize();
        this.iv = new byte[cipherBlockSize];
        if (modeParams != null) {
            byte[] iv = modeParams.getIV();
            if (iv.length < cipherBlockSize) {
                System.arraycopy(iv, 0, this.iv, 0, iv.length);
            } else if (iv.length > cipherBlockSize) {
                System.arraycopy(iv, 0, this.iv, 0, cipherBlockSize);
            } else {
                this.iv = iv;
            }
        }
        if (modeParams instanceof CFBParameterSpec) {
            this.blockSize = ((OFBParameterSpec)modeParams).getBlockSize();
            if (this.blockSize > cipherBlockSize) {
                this.blockSize = cipherBlockSize;
            }
        } else {
            this.blockSize = cipherBlockSize;
        }
        this.buf = new byte[cipherBlockSize];
        this.feedbackBlock = new byte[cipherBlockSize];
        this.reset();
    }

    protected final void initDecrypt(SecretKey key, ModeParameterSpec modeParams, AlgorithmParameterSpec paramSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.initEncrypt(key, modeParams, paramSpec);
    }

    protected final void nextChunkEncrypt(byte[] input, int inOff, byte[] output, int outOff) {
        this.nextChunk(input, inOff, output, outOff);
        System.arraycopy(output, outOff, this.feedbackBlock, 0, this.blockSize);
    }

    protected final void nextChunkDecrypt(byte[] input, int inOff, byte[] output, int outOff) {
        this.nextChunk(input, inOff, output, outOff);
        System.arraycopy(input, inOff, this.feedbackBlock, 0, this.blockSize);
    }

    private void nextChunk(byte[] input, int inOff, byte[] output, int outOff) {
        this.singleBlockEncrypt(this.feedbackBlock, 0, this.buf, 0);
        int i = 0;
        while (i < this.blockSize) {
            output[outOff + i] = (byte)(this.buf[i] ^ input[inOff + i]);
            ++i;
        }
        System.arraycopy(this.feedbackBlock, 0, this.feedbackBlock, this.blockSize, this.feedbackBlock.length - this.blockSize);
    }

    protected final void reset() {
        System.arraycopy(this.iv, 0, this.feedbackBlock, 0, this.iv.length);
    }
}

