/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.common.mode;

import de.flexiprovider.api.Registry;
import de.flexiprovider.api.SecureRandom;
import de.flexiprovider.api.exceptions.InvalidAlgorithmParameterException;
import de.flexiprovider.api.parameters.AlgorithmParameterGenerator;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.api.parameters.AlgorithmParameters;
import de.flexiprovider.common.mode.ModeParamGenParameterSpec;
import de.flexiprovider.common.mode.ModeParameterSpec;
import de.flexiprovider.common.mode.ModeParameters;

public class ModeParameterGenerator
extends AlgorithmParameterGenerator {
    private int ivLength;
    private SecureRandom random;
    private boolean initialized;

    protected AlgorithmParameters getAlgorithmParameters() {
        return new ModeParameters();
    }

    public void init(AlgorithmParameterSpec genParams, SecureRandom random) throws InvalidAlgorithmParameterException {
        ModeParamGenParameterSpec modeGenParams;
        if (genParams == null) {
            modeGenParams = new ModeParamGenParameterSpec();
        } else if (genParams instanceof ModeParamGenParameterSpec) {
            modeGenParams = (ModeParamGenParameterSpec)genParams;
        } else {
            throw new InvalidAlgorithmParameterException("unsupported type");
        }
        this.ivLength = modeGenParams.getIVLength();
        this.random = random != null ? random : Registry.getSecureRandom();
        this.initialized = true;
    }

    public void init(int ivLength, SecureRandom random) {
        ModeParamGenParameterSpec genParams = new ModeParamGenParameterSpec(ivLength);
        try {
            this.init(genParams, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException("internal error");
        }
    }

    private void initDefault() {
        ModeParamGenParameterSpec defaultGenParams = new ModeParamGenParameterSpec();
        try {
            this.init(defaultGenParams, this.random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException("internal error");
        }
    }

    public AlgorithmParameterSpec generateParameters() {
        if (!this.initialized) {
            this.initDefault();
        }
        byte[] iv = new byte[this.ivLength];
        this.random.nextBytes(iv);
        return new ModeParameterSpec(iv);
    }
}

