/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.common.mode;

import codec.asn1.ASN1Exception;
import codec.asn1.ASN1OctetString;
import codec.asn1.ASN1Type;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.api.parameters.AlgorithmParameters;
import de.flexiprovider.common.mode.ModeParameterSpec;
import de.flexiprovider.common.util.ASN1Tools;
import de.flexiprovider.common.util.ByteUtils;
import java.io.IOException;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.IvParameterSpec;

public class ModeParameters
extends AlgorithmParameters {
    private byte[] iv;
    static /* synthetic */ Class class$de$flexiprovider$api$parameters$AlgorithmParameterSpec;
    static /* synthetic */ Class class$javax$crypto$spec$IvParameterSpec;
    static /* synthetic */ Class class$de$flexiprovider$common$mode$ModeParameterSpec;

    protected void engineInit(java.security.spec.AlgorithmParameterSpec params) throws InvalidParameterSpecException {
        if (params == null) {
            throw new InvalidParameterSpecException();
        }
        if (!(params instanceof AlgorithmParameterSpec)) {
            if (params instanceof IvParameterSpec) {
                this.iv = ((IvParameterSpec)params).getIV();
                return;
            }
            throw new InvalidParameterSpecException();
        }
        this.init((AlgorithmParameterSpec)params);
    }

    protected java.security.spec.AlgorithmParameterSpec engineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
        if (!(class$de$flexiprovider$api$parameters$AlgorithmParameterSpec == null ? (class$de$flexiprovider$api$parameters$AlgorithmParameterSpec = ModeParameters.class$("de.flexiprovider.api.parameters.AlgorithmParameterSpec")) : class$de$flexiprovider$api$parameters$AlgorithmParameterSpec).isAssignableFrom(paramSpec)) {
            if (paramSpec == (class$javax$crypto$spec$IvParameterSpec == null ? (class$javax$crypto$spec$IvParameterSpec = ModeParameters.class$("javax.crypto.spec.IvParameterSpec")) : class$javax$crypto$spec$IvParameterSpec)) {
                return this.getParameterSpec(class$de$flexiprovider$common$mode$ModeParameterSpec == null ? (class$de$flexiprovider$common$mode$ModeParameterSpec = ModeParameters.class$("de.flexiprovider.common.mode.ModeParameterSpec")) : class$de$flexiprovider$common$mode$ModeParameterSpec);
            }
            throw new InvalidParameterSpecException("Unsupported parameter specification.");
        }
        return this.getParameterSpec(paramSpec);
    }

    public final void init(AlgorithmParameterSpec paramSpec) throws de.flexiprovider.api.exceptions.InvalidParameterSpecException {
        if (paramSpec == null) {
            throw new de.flexiprovider.api.exceptions.InvalidParameterSpecException("Null parameters.");
        }
        if (!(paramSpec instanceof ModeParameterSpec)) {
            throw new de.flexiprovider.api.exceptions.InvalidParameterSpecException("Unsupported parameter specification.");
        }
        this.iv = ((ModeParameterSpec)paramSpec).getIV();
    }

    public final void init(byte[] encParams) throws IOException {
        ASN1OctetString asn1IV = new ASN1OctetString();
        try {
            ASN1Tools.derDecode(encParams, (ASN1Type)asn1IV);
        }
        catch (ASN1Exception e) {
            throw new IOException("Illegal encoding.");
        }
        this.iv = asn1IV.getByteArray();
    }

    public final void init(byte[] params, String format) throws IOException {
        if (format != "ASN.1") {
            throw new IOException("Unsupported encoding format.");
        }
        this.init(params);
    }

    public final byte[] getEncoded() {
        return ASN1Tools.derEncode((ASN1Type)new ASN1OctetString(this.iv));
    }

    public final byte[] getEncoded(String format) throws IOException {
        if (format != "ASN.1") {
            throw new IOException("Unsupported encoding format.");
        }
        return this.getEncoded();
    }

    public final AlgorithmParameterSpec getParameterSpec(Class paramSpec) throws de.flexiprovider.api.exceptions.InvalidParameterSpecException {
        if (!paramSpec.isAssignableFrom(class$de$flexiprovider$common$mode$ModeParameterSpec == null ? (class$de$flexiprovider$common$mode$ModeParameterSpec = ModeParameters.class$("de.flexiprovider.common.mode.ModeParameterSpec")) : class$de$flexiprovider$common$mode$ModeParameterSpec)) {
            throw new de.flexiprovider.api.exceptions.InvalidParameterSpecException("Unsupported parameter specification.");
        }
        return new ModeParameterSpec(this.iv);
    }

    public final String toString() {
        return "IV: " + ByteUtils.toHexString(this.iv);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

