/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.common.padding;

import de.flexiprovider.api.PaddingScheme;
import de.flexiprovider.api.exceptions.BadPaddingException;

public class PKCS5Padding
extends PaddingScheme {
    protected int padLength(int inLen) {
        return this.blockSize - inLen % this.blockSize;
    }

    protected void pad(byte[] input, int inOff, int inLen) {
        int padLength = this.padLength(inLen);
        int index = inOff + inLen;
        int i = 0;
        while (i < padLength) {
            input[index++] = (byte)padLength;
            ++i;
        }
    }

    protected int unpad(byte[] input, int inOff, int inLen) throws BadPaddingException {
        int padLength;
        int last = inOff + inLen - 1;
        if ((padLength = input[last--]) < 0 || padLength > inLen) {
            throw new BadPaddingException("unpadding failed");
        }
        int i = 1;
        while (i < padLength) {
            if (input[last--] != padLength) {
                throw new BadPaddingException("unpadding failed");
            }
            ++i;
        }
        return ++last;
    }
}

