/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.common.util;

import de.flexiprovider.common.math.FlexiBigInt;

public final class FlexiBigIntUtils {
    private FlexiBigIntUtils() {
    }

    public static boolean equals(FlexiBigInt[] a, FlexiBigInt[] b) {
        int flag = 0;
        if (a.length != b.length) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            flag |= a[i].compareTo(b[i]);
            ++i;
        }
        return flag == 0;
    }

    public static void fill(FlexiBigInt[] array, FlexiBigInt value) {
        int i = array.length - 1;
        while (i >= 0) {
            array[i] = value;
            --i;
        }
    }

    public static FlexiBigInt[] subArray(FlexiBigInt[] input, int start, int end) {
        FlexiBigInt[] result = new FlexiBigInt[end - start];
        System.arraycopy(input, start, result, 0, end - start);
        return result;
    }

    public static int[] toIntArray(FlexiBigInt[] input) {
        int[] result = new int[input.length];
        int i = 0;
        while (i < input.length) {
            result[i] = input[i].intValue();
            ++i;
        }
        return result;
    }

    public static int[] toIntArrayModQ(int q, FlexiBigInt[] input) {
        FlexiBigInt bq = FlexiBigInt.valueOf(q);
        int[] result = new int[input.length];
        int i = 0;
        while (i < input.length) {
            result[i] = input[i].mod(bq).intValue();
            ++i;
        }
        return result;
    }

    public static byte[] toMinimalByteArray(FlexiBigInt value) {
        byte[] valBytes = value.toByteArray();
        if (valBytes.length == 1 || (value.bitLength() & 7) != 0) {
            return valBytes;
        }
        byte[] result = new byte[value.bitLength() >> 3];
        System.arraycopy(valBytes, 1, result, 0, result.length);
        return result;
    }
}

