/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.common.util;

import de.flexiprovider.common.math.FlexiBigInt;
import de.flexiprovider.common.util.BigEndianConversions;
import de.flexiprovider.common.util.ByteUtils;

public final class IntUtils {
    private IntUtils() {
    }

    public static boolean equals(int[] left, int[] right) {
        if (left.length != right.length) {
            return false;
        }
        boolean result = true;
        int i = left.length - 1;
        while (i >= 0) {
            result &= left[i] == right[i];
            --i;
        }
        return result;
    }

    public static int[] clone(int[] array) {
        int[] result = new int[array.length];
        System.arraycopy(array, 0, result, 0, array.length);
        return result;
    }

    public static void fill(int[] array, int value) {
        int i = array.length - 1;
        while (i >= 0) {
            array[i] = value;
            --i;
        }
    }

    public static void quicksort(int[] source) {
        IntUtils.quicksort(source, 0, source.length - 1);
    }

    public static void quicksort(int[] source, int left, int right) {
        if (right > left) {
            int index = IntUtils.partition(source, left, right, right);
            IntUtils.quicksort(source, left, index - 1);
            IntUtils.quicksort(source, index + 1, right);
        }
    }

    private static int partition(int[] source, int left, int right, int pivotIndex) {
        int tmp;
        int pivot = source[pivotIndex];
        source[pivotIndex] = source[right];
        source[right] = pivot;
        int index = left;
        int i = left;
        while (i < right) {
            if (source[i] <= pivot) {
                tmp = source[index];
                source[index] = source[i];
                source[i] = tmp;
                ++index;
            }
            ++i;
        }
        tmp = source[index];
        source[index] = source[right];
        source[right] = tmp;
        return index;
    }

    public static int[] subArray(int[] input, int start, int end) {
        int[] result = new int[end - start];
        System.arraycopy(input, start, result, 0, end - start);
        return result;
    }

    public static FlexiBigInt[] toFlexiBigIntArray(int[] input) {
        FlexiBigInt[] result = new FlexiBigInt[input.length];
        int i = 0;
        while (i < input.length) {
            result[i] = FlexiBigInt.valueOf(input[i]);
            ++i;
        }
        return result;
    }

    public static String toString(int[] input) {
        String result = "";
        int i = 0;
        while (i < input.length) {
            result = result + input[i] + " ";
            ++i;
        }
        return result;
    }

    public static String toHexString(int[] input) {
        return ByteUtils.toHexString(BigEndianConversions.toByteArray(input));
    }
}

