/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.camellia;

import de.flexiprovider.api.BlockCipher;
import de.flexiprovider.api.exceptions.InvalidKeyException;
import de.flexiprovider.api.exceptions.NoSuchModeException;
import de.flexiprovider.api.keys.Key;
import de.flexiprovider.api.keys.SecretKey;
import de.flexiprovider.api.keys.SecretKeySpec;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.common.util.BigEndianConversions;
import de.flexiprovider.core.camellia.CamelliaKey;

public class Camellia
extends BlockCipher {
    private static final int blockSize = 16;
    private int keySize;
    private boolean keySizeIsMutable;
    private static final int[] KIDX1 = new int[]{0, 0, 4, 4, 0, 0, 4, 4, 4, 4, 0, 0, 4, 0, 4, 4, 0, 0, 0, 0, 4, 4, 0, 0, 4, 4};
    private static final int[] KIDX2 = new int[]{0, 0, 12, 12, 8, 8, 4, 4, 8, 8, 12, 12, 0, 0, 4, 4, 0, 0, 8, 8, 12, 12, 0, 0, 4, 4, 8, 8, 4, 4, 0, 0, 12, 12};
    private static final int[] KSFT1 = new int[]{0, 64, 0, 64, 15, 79, 15, 79, 30, 94, 45, 109, 45, 124, 60, 124, 77, 13, 94, 30, 94, 30, 111, 47, 111, 47};
    private static final int[] KSFT2 = new int[]{0, 64, 0, 64, 15, 79, 15, 79, 30, 94, 30, 94, 45, 109, 45, 109, 60, 124, 60, 124, 60, 124, 77, 13, 77, 13, 94, 30, 94, 30, 111, 47, 111, 47};
    private static final byte[] SIGMA = new byte[]{-96, -98, 102, 127, 59, -52, -112, -117, -74, 122, -24, 88, 76, -86, 115, -78, -58, -17, 55, 47, -23, 79, -126, -66, 84, -1, 83, -91, -15, -45, 111, 28, 16, -27, 39, -6, -34, 104, 45, 29, -80, 86, -120, -62, -77, -26, -63, -3};
    private static final byte[] S1 = new byte[]{112, -126, 44, -20, -77, 39, -64, -27, -28, -123, 87, 53, -22, 12, -82, 65, 35, -17, 107, -109, 69, 25, -91, 33, -19, 14, 79, 78, 29, 101, -110, -67, -122, -72, -81, -113, 124, -21, 31, -50, 62, 48, -36, 95, 94, -59, 11, 26, -90, -31, 57, -54, -43, 71, 93, 61, -39, 1, 90, -42, 81, 86, 108, 77, -117, 13, -102, 102, -5, -52, -80, 45, 116, 18, 43, 32, -16, -79, -124, -103, -33, 76, -53, -62, 52, 126, 118, 5, 109, -73, -87, 49, -47, 23, 4, -41, 20, 88, 58, 97, -34, 27, 17, 28, 50, 15, -100, 22, 83, 24, -14, 34, -2, 68, -49, -78, -61, -75, 122, -111, 36, 8, -24, -88, 96, -4, 105, 80, -86, -48, -96, 125, -95, -119, 98, -105, 84, 91, 30, -107, -32, -1, 100, -46, 16, -60, 0, 72, -93, -9, 117, -37, -118, 3, -26, -38, 9, 63, -35, -108, -121, 92, -125, 2, -51, 74, -112, 51, 115, 103, -10, -13, -99, 127, -65, -30, 82, -101, -40, 38, -56, 55, -58, 59, -127, -106, 111, 75, 19, -66, 99, 46, -23, 121, -89, -116, -97, 110, -68, -114, 41, -11, -7, -74, 47, -3, -76, 89, 120, -104, 6, 106, -25, 70, 113, -70, -44, 37, -85, 66, -120, -94, -115, -6, 114, 7, -71, 85, -8, -18, -84, 10, 54, 73, 42, 104, 60, 56, -15, -92, 64, 40, -45, 123, -69, -55, 67, -63, 21, -29, -83, -12, 119, -57, -128, -98};
    private static final byte[] S2 = new byte[]{-32, 5, 88, -39, 103, 78, -127, -53, -55, 11, -82, 106, -43, 24, 93, -126, 70, -33, -42, 39, -118, 50, 75, 66, -37, 28, -98, -100, 58, -54, 37, 123, 13, 113, 95, 31, -8, -41, 62, -99, 124, 96, -71, -66, -68, -117, 22, 52, 77, -61, 114, -107, -85, -114, -70, 122, -77, 2, -76, -83, -94, -84, -40, -102, 23, 26, 53, -52, -9, -103, 97, 90, -24, 36, 86, 64, -31, 99, 9, 51, -65, -104, -105, -123, 104, -4, -20, 10, -38, 111, 83, 98, -93, 46, 8, -81, 40, -80, 116, -62, -67, 54, 34, 56, 100, 30, 57, 44, -90, 48, -27, 68, -3, -120, -97, 101, -121, 107, -12, 35, 72, 16, -47, 81, -64, -7, -46, -96, 85, -95, 65, -6, 67, 19, -60, 47, -88, -74, 60, 43, -63, -1, -56, -91, 32, -119, 0, -112, 71, -17, -22, -73, 21, 6, -51, -75, 18, 126, -69, 41, 15, -72, 7, 4, -101, -108, 33, 102, -26, -50, -19, -25, 59, -2, 127, -59, -92, 55, -79, 76, -111, 110, -115, 118, 3, 45, -34, -106, 38, 125, -58, 92, -45, -14, 79, 25, 63, -36, 121, 29, 82, -21, -13, 109, 94, -5, 105, -78, -16, 49, 12, -44, -49, -116, -30, 117, -87, 74, 87, -124, 17, 69, 27, -11, -28, 14, 115, -86, -15, -35, 89, 20, 108, -110, 84, -48, 120, 112, -29, 73, -128, 80, -89, -10, 119, -109, -122, -125, 42, -57, 91, -23, -18, -113, 1, 61};
    private static final byte[] S3 = new byte[]{56, 65, 22, 118, -39, -109, 96, -14, 114, -62, -85, -102, 117, 6, 87, -96, -111, -9, -75, -55, -94, -116, -46, -112, -10, 7, -89, 39, -114, -78, 73, -34, 67, 92, -41, -57, 62, -11, -113, 103, 31, 24, 110, -81, 47, -30, -123, 13, 83, -16, -100, 101, -22, -93, -82, -98, -20, -128, 45, 107, -88, 43, 54, -90, -59, -122, 77, 51, -3, 102, 88, -106, 58, 9, -107, 16, 120, -40, 66, -52, -17, 38, -27, 97, 26, 63, 59, -126, -74, -37, -44, -104, -24, -117, 2, -21, 10, 44, 29, -80, 111, -115, -120, 14, 25, -121, 78, 11, -87, 12, 121, 17, 127, 34, -25, 89, -31, -38, 61, -56, 18, 4, 116, 84, 48, 126, -76, 40, 85, 104, 80, -66, -48, -60, 49, -53, 42, -83, 15, -54, 112, -1, 50, 105, 8, 98, 0, 36, -47, -5, -70, -19, 69, -127, 115, 109, -124, -97, -18, 74, -61, 46, -63, 1, -26, 37, 72, -103, -71, -77, 123, -7, -50, -65, -33, 113, 41, -51, 108, 19, 100, -101, 99, -99, -64, 75, -73, -91, -119, 95, -79, 23, -12, -68, -45, 70, -49, 55, 94, 71, -108, -6, -4, 91, -105, -2, 90, -84, 60, 76, 3, 53, -13, 35, -72, 93, 106, -110, -43, 33, 68, 81, -58, 125, 57, -125, -36, -86, 124, 119, 86, 5, 27, -92, 21, 52, 30, 28, -8, 82, 32, 20, -23, -67, -35, -28, -95, -32, -118, -15, -42, 122, -69, -29, 64, 79};
    private static final byte[] S4 = new byte[]{112, 44, -77, -64, -28, 87, -22, -82, 35, 107, 69, -91, -19, 79, 29, -110, -122, -81, 124, 31, 62, -36, 94, 11, -90, 57, -43, 93, -39, 90, 81, 108, -117, -102, -5, -80, 116, 43, -16, -124, -33, -53, 52, 118, 109, -87, -47, 4, 20, 58, -34, 17, 50, -100, 83, -14, -2, -49, -61, 122, 36, -24, 96, 105, -86, -96, -95, 98, 84, 30, -32, 100, 16, 0, -93, 117, -118, -26, 9, -35, -121, -125, -51, -112, 115, -10, -99, -65, 82, -40, -56, -58, -127, 111, 19, 99, -23, -89, -97, -68, 41, -7, 47, -76, 120, 6, -25, 113, -44, -85, -120, -115, 114, -71, -8, -84, 54, 42, 60, -15, 64, -45, -69, 67, 21, -83, 119, -128, -126, -20, 39, -27, -123, 53, 12, 65, -17, -109, 25, 33, 14, 78, 101, -67, -72, -113, -21, -50, 48, 95, -59, 26, -31, -54, 71, 61, 1, -42, 86, 77, 13, 102, -52, 45, 18, 32, -79, -103, 76, -62, 126, 5, -73, 49, 23, -41, 88, 97, 27, 28, 15, 22, 24, 34, 68, -78, -75, -111, 8, -88, -4, 80, -48, 125, -119, -105, 91, -107, -1, -46, -60, 72, -9, -37, 3, -38, 63, -108, 92, 2, 74, 51, 103, -13, 127, -30, -101, 38, 55, 59, -106, 75, -66, 46, 121, -116, 110, -114, -11, -74, -3, 89, -104, 106, 70, -70, 37, 66, -94, -6, 7, 85, -18, 10, 73, 104, 56, -92, 40, 123, -55, -63, -29, -12, -57, -98};
    private byte[] expandedKey = new byte[272];
    private int n;

    protected Camellia(String modeName, int keySize) {
        this.keySize = keySize;
        this.keySizeIsMutable = false;
        try {
            this.setMode(modeName);
        }
        catch (NoSuchModeException e) {
            throw new RuntimeException("Internal error: could not find mode '" + modeName + "'.");
        }
    }

    public Camellia() {
        this.keySizeIsMutable = true;
    }

    public String getName() {
        return "Camellia";
    }

    public int getKeySize(Key key) throws InvalidKeyException {
        if (!(key instanceof CamelliaKey) && !(key instanceof SecretKeySpec)) {
            throw new InvalidKeyException("Unsupported key.");
        }
        int keyLen = key.getEncoded().length;
        if (keyLen != 16 && keyLen != 24 && keyLen != 32) {
            throw new InvalidKeyException("invalid key size");
        }
        return keyLen << 3;
    }

    protected int getCipherBlockSize() {
        return 16;
    }

    protected void initCipherEncrypt(SecretKey key, AlgorithmParameterSpec params) throws InvalidKeyException {
        if (key == null || !(key instanceof CamelliaKey)) {
            throw new InvalidKeyException("unsupported type");
        }
        byte[] keyBytes = key.getEncoded();
        if (this.keySizeIsMutable) {
            this.keySize = keyBytes.length << 3;
        } else if (keyBytes.length != this.keySize >> 3) {
            throw new InvalidKeyException("key size does not match specified length");
        }
        this.keyExpansion(keyBytes);
    }

    protected void initCipherDecrypt(SecretKey key, AlgorithmParameterSpec params) throws InvalidKeyException {
        this.initCipherEncrypt(key, params);
    }

    private void keyExpansion(byte[] key) {
        int i;
        byte[] t = new byte[64];
        int[] u = new int[20];
        this.n = key.length << 3;
        if (this.n == 128) {
            i = 0;
            while (i < 16) {
                t[i] = key[i];
                ++i;
            }
            i = 16;
            while (i < 32) {
                t[i] = 0;
                ++i;
            }
        } else if (this.n == 192) {
            i = 0;
            while (i < 24) {
                t[i] = key[i];
                ++i;
            }
            i = 24;
            while (i < 32) {
                t[i] = (byte)((key[i - 8] ^ 0xFF) & 0xFF);
                ++i;
            }
        } else if (this.n == 256) {
            i = 0;
            while (i < 32) {
                t[i] = key[i];
                ++i;
            }
        }
        Camellia.xorBlock(t, 0, t, 16, t, 32);
        Camellia.camelliaFeistel(t, 32, SIGMA, 0, t, 40);
        Camellia.camelliaFeistel(t, 40, SIGMA, 8, t, 32);
        Camellia.xorBlock(t, 32, t, 0, t, 32);
        Camellia.camelliaFeistel(t, 32, SIGMA, 16, t, 40);
        Camellia.camelliaFeistel(t, 40, SIGMA, 24, t, 32);
        Camellia.toIntArray(t, 0, u, 0);
        Camellia.toIntArray(t, 32, u, 4);
        if (this.n == 128) {
            i = 0;
            while (i < 26) {
                Camellia.rotBlock(u, KIDX1[i + 0], KSFT1[i + 0], u, 16);
                Camellia.rotBlock(u, KIDX1[i + 1], KSFT1[i + 1], u, 18);
                Camellia.toByteArray(u, 16, this.expandedKey, i << 3);
                i += 2;
            }
        } else {
            Camellia.xorBlock(t, 32, t, 16, t, 48);
            Camellia.camelliaFeistel(t, 48, SIGMA, 32, t, 56);
            Camellia.camelliaFeistel(t, 56, SIGMA, 40, t, 48);
            Camellia.toIntArray(t, 16, u, 8);
            Camellia.toIntArray(t, 48, u, 12);
            i = 0;
            while (i < 34) {
                Camellia.rotBlock(u, KIDX2[i + 0], KSFT2[i + 0], u, 16);
                Camellia.rotBlock(u, KIDX2[i + 1], KSFT2[i + 1], u, 18);
                Camellia.toByteArray(u, 16, this.expandedKey, i << 3);
                i += 2;
            }
        }
    }

    protected void singleBlockEncrypt(byte[] input, int inOff, byte[] output, int outOff) {
        Camellia.xorBlock(input, inOff, this.expandedKey, 0, output, outOff);
        int i = 0;
        while (i < 3) {
            Camellia.camelliaFeistel(output, outOff, this.expandedKey, 16 + (i << 4), output, outOff + 8);
            Camellia.camelliaFeistel(output, outOff + 8, this.expandedKey, 24 + (i << 4), output, outOff);
            ++i;
        }
        Camellia.camelliaFLlayer(output, outOff, this.expandedKey, 64, this.expandedKey, 72);
        i = 0;
        while (i < 3) {
            Camellia.camelliaFeistel(output, outOff, this.expandedKey, 80 + (i << 4), output, outOff + 8);
            Camellia.camelliaFeistel(output, outOff + 8, this.expandedKey, 88 + (i << 4), output, outOff);
            ++i;
        }
        Camellia.camelliaFLlayer(output, outOff, this.expandedKey, 128, this.expandedKey, 136);
        i = 0;
        while (i < 3) {
            Camellia.camelliaFeistel(output, outOff, this.expandedKey, 144 + (i << 4), output, outOff + 8);
            Camellia.camelliaFeistel(output, outOff + 8, this.expandedKey, 152 + (i << 4), output, outOff);
            ++i;
        }
        if (this.n == 128) {
            Camellia.swapHalves(output, outOff);
            Camellia.xorBlock(output, outOff, this.expandedKey, 192, output, outOff);
        } else {
            Camellia.camelliaFLlayer(output, outOff, this.expandedKey, 192, this.expandedKey, 200);
            i = 0;
            while (i < 3) {
                Camellia.camelliaFeistel(output, outOff + 0, this.expandedKey, 208 + (i << 4), output, outOff + 8);
                Camellia.camelliaFeistel(output, outOff + 8, this.expandedKey, 216 + (i << 4), output, outOff);
                ++i;
            }
            Camellia.swapHalves(output, outOff);
            Camellia.xorBlock(output, outOff, this.expandedKey, 256, output, outOff);
        }
    }

    protected void singleBlockDecrypt(byte[] input, int inOff, byte[] output, int outOff) {
        int i;
        if (this.n == 128) {
            Camellia.xorBlock(input, inOff, this.expandedKey, 192, output, outOff);
        } else {
            Camellia.xorBlock(input, inOff, this.expandedKey, 256, output, outOff);
            i = 2;
            while (i >= 0) {
                Camellia.camelliaFeistel(output, outOff, this.expandedKey, 216 + (i << 4), output, outOff + 8);
                Camellia.camelliaFeistel(output, outOff + 8, this.expandedKey, 208 + (i << 4), output, outOff);
                --i;
            }
            Camellia.camelliaFLlayer(output, outOff, this.expandedKey, 200, this.expandedKey, 192);
        }
        i = 2;
        while (i >= 0) {
            Camellia.camelliaFeistel(output, outOff, this.expandedKey, 152 + (i << 4), output, outOff + 8);
            Camellia.camelliaFeistel(output, outOff + 8, this.expandedKey, 144 + (i << 4), output, outOff);
            --i;
        }
        Camellia.camelliaFLlayer(output, outOff, this.expandedKey, 136, this.expandedKey, 128);
        i = 2;
        while (i >= 0) {
            Camellia.camelliaFeistel(output, outOff, this.expandedKey, 88 + (i << 4), output, outOff + 8);
            Camellia.camelliaFeistel(output, outOff + 8, this.expandedKey, 80 + (i << 4), output, outOff);
            --i;
        }
        Camellia.camelliaFLlayer(output, outOff, this.expandedKey, 72, this.expandedKey, 64);
        i = 2;
        while (i >= 0) {
            Camellia.camelliaFeistel(output, outOff, this.expandedKey, 24 + (i << 4), output, outOff + 8);
            Camellia.camelliaFeistel(output, outOff + 8, this.expandedKey, 16 + (i << 4), output, outOff);
            --i;
        }
        Camellia.swapHalves(output, outOff);
        Camellia.xorBlock(output, outOff, this.expandedKey, 0, output, outOff);
    }

    private static void xorBlock(byte[] x, int offx, byte[] y, int offy, byte[] z, int offz) {
        int i = 15;
        while (i >= 0) {
            z[offz++] = (byte)(x[offx++] ^ y[offy++]);
            --i;
        }
    }

    private static void rotBlock(int[] x, int offx, int n, int[] y, int offy) {
        int r = n & 0x1F;
        if (r != 0) {
            y[offy] = x[offx + (n >>> 5 & 3)] << r | x[offx + ((n >>> 5) + 1 & 3)] >>> 32 - r;
            y[offy + 1] = x[offx + ((n >>> 5) + 1 & 3)] << r | x[offx + ((n >>> 5) + 2 & 3)] >>> 32 - r;
        } else {
            y[offy] = x[offx + (n >>> 5 & 3)];
            y[offy + 1] = x[offx + ((n >>> 5) + 1 & 3)];
        }
    }

    private static void swapHalves(byte[] x, int offx) {
        int i = 0;
        while (i < 8) {
            byte t = x[offx];
            x[offx] = x[offx + 8];
            x[offx + 8] = t;
            ++i;
            ++offx;
        }
    }

    private static void camelliaFeistel(byte[] x, int offx, byte[] k, int offk, byte[] y, int offy) {
        byte[] t = new byte[]{S1[(x[offx++] ^ k[offk++]) & 0xFF], S2[(x[offx++] ^ k[offk++]) & 0xFF], S3[(x[offx++] ^ k[offk++]) & 0xFF], S4[(x[offx++] ^ k[offk++]) & 0xFF], S2[(x[offx++] ^ k[offk++]) & 0xFF], S3[(x[offx++] ^ k[offk++]) & 0xFF], S4[(x[offx++] ^ k[offk++]) & 0xFF], S1[(x[offx] ^ k[offk]) & 0xFF]};
        int n = offy++;
        y[n] = (byte)(y[n] ^ (t[0] ^ t[2] ^ t[3] ^ t[5] ^ t[6] ^ t[7]));
        int n2 = offy++;
        y[n2] = (byte)(y[n2] ^ (t[0] ^ t[1] ^ t[3] ^ t[4] ^ t[6] ^ t[7]));
        int n3 = offy++;
        y[n3] = (byte)(y[n3] ^ (t[0] ^ t[1] ^ t[2] ^ t[4] ^ t[5] ^ t[7]));
        int n4 = offy++;
        y[n4] = (byte)(y[n4] ^ (t[1] ^ t[2] ^ t[3] ^ t[4] ^ t[5] ^ t[6]));
        int n5 = offy++;
        y[n5] = (byte)(y[n5] ^ (t[0] ^ t[1] ^ t[5] ^ t[6] ^ t[7]));
        int n6 = offy++;
        y[n6] = (byte)(y[n6] ^ (t[1] ^ t[2] ^ t[4] ^ t[6] ^ t[7]));
        int n7 = offy++;
        y[n7] = (byte)(y[n7] ^ (t[2] ^ t[3] ^ t[4] ^ t[5] ^ t[7]));
        int n8 = offy;
        y[n8] = (byte)(y[n8] ^ (t[0] ^ t[3] ^ t[4] ^ t[5] ^ t[6]));
    }

    private static void camelliaFLlayer(byte[] x, int offx, byte[] kl, int offkl, byte[] kr, int offkr) {
        int[] t = new int[4];
        int[] u = new int[4];
        int[] v = new int[4];
        Camellia.toIntArray(x, offx, t, 0);
        Camellia.toIntArray(kl, offkl, u, 0);
        Camellia.toIntArray(kr, offkr, v, 0);
        t[1] = t[1] ^ ((t[0] & u[0]) << 1 | (t[0] & u[0]) >>> 31);
        t[0] = t[0] ^ (t[1] | u[1]);
        t[2] = t[2] ^ (t[3] | v[1]);
        t[3] = t[3] ^ ((t[2] & v[0]) << 1 | (t[2] & v[0]) >>> 31);
        Camellia.toByteArray(t, 0, x, offx);
    }

    private static void toIntArray(byte[] input, int inOff, int[] output, int outOff) {
        int i = 3;
        while (i >= 0) {
            output[outOff] = BigEndianConversions.OS2IP(input, inOff);
            --i;
            inOff += 4;
            ++outOff;
        }
    }

    private static void toByteArray(int[] input, int inOff, byte[] output, int outOff) {
        int i = 3;
        while (i >= 0) {
            BigEndianConversions.I2OSP(input[inOff], output, outOff);
            --i;
            ++inOff;
            outOff += 4;
        }
    }

    public static class Camellia256_CBC
    extends Camellia {
        public static final String OID = "1.2.392.200011.61.1.1.1.4";

        public Camellia256_CBC() {
            super("CBC", 256);
        }
    }

    public static class Camellia192_CBC
    extends Camellia {
        public static final String OID = "1.2.392.200011.61.1.1.1.3";

        public Camellia192_CBC() {
            super("CBC", 192);
        }
    }

    public static class Camellia128_CBC
    extends Camellia {
        public static final String OID = "1.2.392.200011.61.1.1.1.2";

        public Camellia128_CBC() {
            super("CBC", 128);
        }
    }
}

