/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.desede;

import de.flexiprovider.api.Registry;
import de.flexiprovider.api.SecureRandom;
import de.flexiprovider.api.exceptions.InvalidKeyException;
import de.flexiprovider.api.keys.SecretKey;
import de.flexiprovider.api.keys.SecretKeyGenerator;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.core.desede.DESKeySpec;
import de.flexiprovider.core.desede.DESedeKey;

public class DESedeKeyGenerator
extends SecretKeyGenerator {
    private SecureRandom random;
    private boolean initialized;

    public void init(AlgorithmParameterSpec params, SecureRandom random) {
        this.init(random);
    }

    public void init(int strength, SecureRandom random) {
        this.init(random);
    }

    public void init(SecureRandom random) {
        this.random = random != null ? random : Registry.getSecureRandom();
        this.initialized = true;
    }

    public SecretKey generateKey() {
        if (!this.initialized) {
            this.init(Registry.getSecureRandom());
        }
        byte[] des_keyBytes = new byte[8];
        byte[] des_ede_keyBytes = new byte[24];
        int count = 0;
        do {
            this.random.nextBytes(des_keyBytes);
            this.setOddParity(des_keyBytes);
            try {
                if (DESKeySpec.isWeak(des_keyBytes, 0)) {
                    continue;
                }
            }
            catch (InvalidKeyException e) {
                throw new RuntimeException(e.getMessage());
            }
            System.arraycopy(des_keyBytes, 0, des_ede_keyBytes, count * 8, 8);
            ++count;
        } while (count < 3);
        return new DESedeKey(des_ede_keyBytes);
    }

    private void setOddParity(byte[] bytes) {
        int i = 0;
        while (i < bytes.length) {
            int b = bytes[i];
            bytes[i] = (b = (b >> 1 ^ b >> 2 ^ b >> 3 ^ b >> 4 ^ b >> 5 ^ b >> 6 ^ b >> 7) & 1) != 0 ? (byte)(bytes[i] & 0xFE) : (byte)(bytes[i] | 1);
            ++i;
        }
    }
}

