/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.dsa;

import codec.asn1.ASN1Exception;
import codec.asn1.ASN1Integer;
import codec.asn1.ASN1Sequence;
import codec.asn1.ASN1Type;
import de.flexiprovider.api.exceptions.InvalidParameterSpecException;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.api.parameters.AlgorithmParameters;
import de.flexiprovider.common.math.FlexiBigInt;
import de.flexiprovider.common.util.ASN1Tools;
import de.flexiprovider.core.dsa.DSAParameterSpec;
import java.io.IOException;
import java.util.ArrayList;

public class DSAParameters
extends AlgorithmParameters {
    public static final String OID = "1.2.840.10040.4.1";
    public static final String ALTERNATIVE_OID = "1.3.14.3.2.12";
    private FlexiBigInt p;
    private FlexiBigInt q;
    private FlexiBigInt g;
    static /* synthetic */ Class class$de$flexiprovider$core$dsa$DSAParameterSpec;

    public void init(AlgorithmParameterSpec params) throws InvalidParameterSpecException {
        if (!(params instanceof DSAParameterSpec)) {
            throw new InvalidParameterSpecException("unsupported type");
        }
        DSAParameterSpec dsaSpec = (DSAParameterSpec)params;
        this.p = dsaSpec.getPrimeP();
        this.q = dsaSpec.getPrimeQ();
        this.g = dsaSpec.getBaseG();
    }

    public void init(byte[] encParams) throws IOException {
        try {
            DSAASN1Parameters asn1dsaParams = new DSAASN1Parameters();
            ASN1Tools.derDecode(encParams, (ASN1Type)asn1dsaParams);
            this.p = asn1dsaParams.getP();
            this.q = asn1dsaParams.getQ();
            this.g = asn1dsaParams.getG();
        }
        catch (ASN1Exception ae) {
            throw new IOException("unable to decode parameters.");
        }
    }

    public void init(byte[] encParams, String format) throws IOException {
        if (!format.equals("ASN.1")) {
            throw new IOException("unsupported format");
        }
        this.init(encParams);
    }

    public byte[] getEncoded() {
        DSAASN1Parameters asn1dsaParams = new DSAASN1Parameters(this.p, this.q, this.g);
        return ASN1Tools.derEncode((ASN1Type)asn1dsaParams);
    }

    public byte[] getEncoded(String format) throws IOException {
        if (!format.equals("ASN.1")) {
            throw new IOException("unsupported format");
        }
        return this.getEncoded();
    }

    public AlgorithmParameterSpec getParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
        if (paramSpec == null || !paramSpec.isAssignableFrom(class$de$flexiprovider$core$dsa$DSAParameterSpec == null ? (class$de$flexiprovider$core$dsa$DSAParameterSpec = DSAParameters.class$("de.flexiprovider.core.dsa.DSAParameterSpec")) : class$de$flexiprovider$core$dsa$DSAParameterSpec)) {
            throw new InvalidParameterSpecException("unsupported type");
        }
        return new DSAParameterSpec(this.p, this.q, this.g);
    }

    public String toString() {
        return "p: 0x" + this.p.toString(16) + "\n" + "q: 0x" + this.q.toString(16) + "\n" + "g: 0x" + this.g.toString(16);
    }

    protected DSAASN1Parameters getASN1Parameters() {
        return new DSAASN1Parameters(this.p, this.q, this.g);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class DSAASN1Parameters
    extends ASN1Sequence {
        private ASN1Integer p;
        private ASN1Integer q;
        private ASN1Integer g;

        public DSAASN1Parameters() {
            super(3);
            this.p = new ASN1Integer();
            this.q = new ASN1Integer();
            this.g = new ASN1Integer();
            ((ArrayList)((Object)this)).add(this.p);
            ((ArrayList)((Object)this)).add(this.q);
            ((ArrayList)((Object)this)).add(this.g);
        }

        public DSAASN1Parameters(FlexiBigInt p, FlexiBigInt q, FlexiBigInt g) {
            super(3);
            this.p = ASN1Tools.createInteger(p);
            this.q = ASN1Tools.createInteger(q);
            this.g = ASN1Tools.createInteger(g);
            ((ArrayList)((Object)this)).add(this.p);
            ((ArrayList)((Object)this)).add(this.q);
            ((ArrayList)((Object)this)).add(this.g);
        }

        public FlexiBigInt getG() {
            return ASN1Tools.getFlexiBigInt(this.g);
        }

        public FlexiBigInt getP() {
            return ASN1Tools.getFlexiBigInt(this.p);
        }

        public FlexiBigInt getQ() {
            return ASN1Tools.getFlexiBigInt(this.q);
        }
    }
}

