/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.dsa;

import codec.asn1.ASN1Integer;
import codec.asn1.ASN1ObjectIdentifier;
import codec.asn1.ASN1Type;
import de.flexiprovider.api.exceptions.InvalidParameterSpecException;
import de.flexiprovider.common.math.FlexiBigInt;
import de.flexiprovider.common.util.ASN1Tools;
import de.flexiprovider.core.dsa.DSAParameterSpec;
import de.flexiprovider.core.dsa.DSAParameters;
import de.flexiprovider.core.dsa.DSAPublicKeySpec;
import de.flexiprovider.core.dsa.interfaces.DSAKey;
import de.flexiprovider.core.dsa.interfaces.DSAParams;

public class DSAPublicKey
extends de.flexiprovider.core.dsa.interfaces.DSAPublicKey
implements DSAKey {
    private FlexiBigInt y;
    private DSAParams params;

    protected DSAPublicKey(FlexiBigInt y, DSAParams params) {
        this.y = y;
        this.params = params;
    }

    protected DSAPublicKey(DSAPublicKeySpec keySpec) {
        this(keySpec.getValueY(), new DSAParameterSpec(keySpec.getPrimeP(), keySpec.getPrimeQ(), keySpec.getBaseG()));
    }

    public String getAlgorithm() {
        return "DSA";
    }

    public DSAParams getParameters() {
        return this.params;
    }

    public FlexiBigInt getValueY() {
        return this.y;
    }

    public String toString() {
        String out = "public y:  0x" + this.y.toString(16) + "\n" + "p:         0x" + this.params.getPrimeP().toString(16) + "\n" + "q:         0x" + this.params.getPrimeQ().toString(16) + "\n" + "g:         0x" + this.params.getBaseG().toString(16) + "\n";
        return out;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof DSAPublicKey)) {
            return false;
        }
        DSAPublicKey otherKey = (DSAPublicKey)obj;
        boolean value = this.y.equals(otherKey.y);
        value &= this.params.getBaseG().equals(otherKey.params.getBaseG());
        value &= this.params.getPrimeP().equals(otherKey.params.getPrimeP());
        return value &= this.params.getPrimeQ().equals(otherKey.params.getPrimeQ());
    }

    public int hashCode() {
        return this.y.hashCode() + this.params.getBaseG().hashCode() + this.params.getPrimeP().hashCode() + this.params.getPrimeQ().hashCode();
    }

    protected ASN1ObjectIdentifier getOID() {
        return new ASN1ObjectIdentifier("1.2.840.10040.4.1");
    }

    protected ASN1Type getAlgParams() {
        DSAParameters dsaParams = new DSAParameters();
        DSAParameterSpec dsaParamSpec = new DSAParameterSpec(this.params.getPrimeP(), this.params.getPrimeQ(), this.params.getBaseG());
        try {
            dsaParams.init(dsaParamSpec);
        }
        catch (InvalidParameterSpecException e) {
            throw new RuntimeException("internal error");
        }
        return dsaParams.getASN1Parameters();
    }

    protected byte[] getKeyData() {
        ASN1Integer keyData = new ASN1Integer(this.y.toByteArray());
        return ASN1Tools.derEncode((ASN1Type)keyData);
    }
}

