/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.dsa.interfaces;

import de.flexiprovider.api.keys.KeyFactory;
import de.flexiprovider.core.dsa.DSAPrivateKeySpec;
import de.flexiprovider.core.dsa.DSAPublicKeySpec;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;

public abstract class DSAKeyFactory
extends KeyFactory {
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec != null && !(keySpec instanceof de.flexiprovider.api.keys.KeySpec) && keySpec instanceof java.security.spec.DSAPublicKeySpec) {
            DSAPublicKeySpec dsaKeySpec = new DSAPublicKeySpec((java.security.spec.DSAPublicKeySpec)keySpec);
            return super.engineGeneratePublic(dsaKeySpec);
        }
        return super.engineGeneratePublic(keySpec);
    }

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec != null && !(keySpec instanceof de.flexiprovider.api.keys.KeySpec) && keySpec instanceof java.security.spec.DSAPrivateKeySpec) {
            DSAPrivateKeySpec dsaKeySpec = new DSAPrivateKeySpec((java.security.spec.DSAPrivateKeySpec)keySpec);
            return super.engineGeneratePrivate(dsaKeySpec);
        }
        return super.engineGeneratePrivate(keySpec);
    }
}

