/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.kdf;

import de.flexiprovider.api.KeyDerivation;
import de.flexiprovider.api.MessageDigest;
import de.flexiprovider.api.exceptions.InvalidAlgorithmParameterException;
import de.flexiprovider.api.exceptions.InvalidKeyException;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.common.util.ByteUtils;
import de.flexiprovider.core.kdf.KDFParameterSpec;
import de.flexiprovider.core.md.SHA1;

public class KDF1
extends KeyDerivation {
    private MessageDigest md = new SHA1();
    private byte[] z;
    private byte[] sharedInfo;

    public void init(byte[] secret, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (secret == null) {
            throw new InvalidKeyException("null");
        }
        this.z = ByteUtils.clone(secret);
        if (!(params instanceof KDFParameterSpec)) {
            throw new InvalidAlgorithmParameterException("unsupported type");
        }
        this.sharedInfo = ((KDFParameterSpec)params).getSharedInfo();
        if (this.sharedInfo == null) {
            throw new InvalidAlgorithmParameterException("shared information must not be null");
        }
    }

    public byte[] deriveKey(int keySize) {
        byte[] both = ByteUtils.concatenate(this.z, this.sharedInfo);
        return this.md.digest(both);
    }
}

