/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.kdf;

import de.flexiprovider.api.KeyDerivation;
import de.flexiprovider.api.MessageDigest;
import de.flexiprovider.api.exceptions.DigestException;
import de.flexiprovider.api.exceptions.InvalidAlgorithmParameterException;
import de.flexiprovider.api.exceptions.InvalidKeyException;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.common.util.ByteUtils;
import de.flexiprovider.core.kdf.KDFParameterSpec;
import de.flexiprovider.core.md.SHA1;

public class X963
extends KeyDerivation {
    private MessageDigest md = new SHA1();
    private byte[] z;
    private byte[] sharedInfo;

    public void init(byte[] secret, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (secret == null) {
            throw new InvalidKeyException("null");
        }
        this.z = ByteUtils.clone(secret);
        if (params != null) {
            if (!(params instanceof KDFParameterSpec)) {
                throw new InvalidAlgorithmParameterException("unsupported type");
            }
            this.sharedInfo = ((KDFParameterSpec)params).getSharedInfo();
        }
    }

    public byte[] deriveKey(int keySize) {
        if (keySize < 0) {
            return null;
        }
        int mdLength = this.md.getDigestLength();
        int d = keySize / mdLength;
        int t = keySize % mdLength;
        byte[] result = new byte[keySize];
        byte[] counter = new byte[4];
        try {
            int i = 0;
            while (i < d) {
                counter = this.increase(counter);
                this.md.update(this.z);
                this.md.update(counter);
                this.md.update(this.sharedInfo);
                this.md.digest(result, i * mdLength, mdLength);
                ++i;
            }
        }
        catch (DigestException e) {
            throw new RuntimeException("internal error");
        }
        if (t != 0) {
            counter = this.increase(counter);
            this.md.update(this.z);
            this.md.update(counter);
            this.md.update(this.sharedInfo);
            byte[] last = this.md.digest();
            System.arraycopy(last, 0, result, d * mdLength, t);
        }
        return result;
    }

    private byte[] increase(byte[] b) {
        int[] i;
        (i = new int[]{(256 + b[0]) % 256, (256 + b[1]) % 256, (256 + b[2]) % 256, (256 + b[3]) % 256})[0] = i[0] + 1;
        if ((i = new int[]{(256 + b[0]) % 256, (256 + b[1]) % 256, (256 + b[2]) % 256, (256 + b[3]) % 256})[0] == 256 && (i[1] = i[1] + 1) == 256 && (i[2] = i[2] + 1) == 256) {
            i[3] = i[3] + 1;
        }
        b[0] = (byte)i[0];
        b[1] = (byte)i[1];
        b[2] = (byte)i[2];
        b[3] = (byte)i[3];
        return b;
    }
}

