/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.mac;

import de.flexiprovider.api.BlockCipher;
import de.flexiprovider.api.Mac;
import de.flexiprovider.api.Registry;
import de.flexiprovider.api.SecureRandom;
import de.flexiprovider.api.exceptions.InvalidAlgorithmParameterException;
import de.flexiprovider.api.exceptions.InvalidKeyException;
import de.flexiprovider.api.exceptions.NoSuchModeException;
import de.flexiprovider.api.exceptions.NoSuchPaddingException;
import de.flexiprovider.api.keys.SecretKey;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.core.desede.DESede;
import de.flexiprovider.core.idea.IDEA;
import de.flexiprovider.core.rc2.RC2;
import de.flexiprovider.core.rijndael.Rijndael;
import java.io.ByteArrayOutputStream;

public abstract class CBCMac
extends Mac {
    private BlockCipher cipher;
    private SecureRandom sr;
    private int macLength;
    private ByteArrayOutputStream cipherInput;

    protected CBCMac(BlockCipher blockCipher) {
        this.cipher = blockCipher;
        try {
            this.cipher.setMode("CBC");
        }
        catch (NoSuchModeException e) {
            throw new RuntimeException("Internal error: could not find mode 'CBC'.");
        }
        try {
            this.cipher.setPadding("NoPadding");
        }
        catch (NoSuchPaddingException e) {
            throw new RuntimeException("Internal error: could not find padding 'NoPadding'.");
        }
        this.sr = Registry.getSecureRandom();
    }

    public int getMacLength() {
        return this.macLength;
    }

    public void init(SecretKey key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.cipher.initEncrypt(key, params, this.sr);
        this.cipherInput = new ByteArrayOutputStream();
        this.macLength = this.cipher.getBlockSize();
    }

    public void update(byte input) {
        if (this.cipher == null) {
            throw new IllegalStateException("MAC not initialized");
        }
        this.cipherInput.write(input);
    }

    public void update(byte[] input, int inOff, int inLen) {
        if (this.cipher == null) {
            throw new IllegalStateException("MAC not initialized");
        }
        this.cipherInput.write(input, inOff, inLen);
    }

    public byte[] doFinal() {
        byte[] macValue = new byte[this.macLength];
        int len = this.cipherInput.size();
        if (len % this.macLength != 0 || len == 0) {
            int x = this.macLength - len % this.macLength;
            int i = 0;
            while (i < x) {
                this.cipherInput.write(0);
                ++i;
            }
        }
        try {
            byte[] result = this.cipher.doFinal(this.cipherInput.toByteArray());
            System.arraycopy(result, result.length - this.macLength, macValue, 0, this.macLength);
        }
        catch (Exception e) {
            System.err.println("doFinal failed");
            e.printStackTrace();
        }
        this.reset();
        return macValue;
    }

    public void reset() {
        this.cipherInput = new ByteArrayOutputStream();
    }

    public static class Twofish
    extends CBCMac {
        public Twofish() {
            super(new de.flexiprovider.core.twofish.Twofish());
        }
    }

    public static class Shacal2
    extends CBCMac {
        public Shacal2() {
            super(new de.flexiprovider.core.shacal2.Shacal2());
        }
    }

    public static class Shacal
    extends CBCMac {
        public Shacal() {
            super(new de.flexiprovider.core.shacal.Shacal());
        }
    }

    public static class Serpent
    extends CBCMac {
        public Serpent() {
            super(new de.flexiprovider.core.serpent.Serpent());
        }
    }

    public static class SAFERPlusPlus
    extends CBCMac {
        public SAFERPlusPlus() {
            super(new de.flexiprovider.core.saferplusplus.SAFERPlusPlus());
        }
    }

    public static class SAFERPlus
    extends CBCMac {
        public SAFERPlus() {
            super(new de.flexiprovider.core.saferplus.SAFERPlus());
        }
    }

    public static class RC6
    extends CBCMac {
        public RC6() {
            super(new de.flexiprovider.core.rc6.RC6());
        }
    }

    public static class RC5
    extends CBCMac {
        public RC5() {
            super(new de.flexiprovider.core.rc5.RC5());
        }
    }

    public static class RC2
    extends CBCMac {
        public RC2() {
            super(new RC2.RC2_CBC());
        }
    }

    public static class Misty1
    extends CBCMac {
        public Misty1() {
            super(new de.flexiprovider.core.misty1.Misty1());
        }
    }

    public static class MARS
    extends CBCMac {
        public MARS() {
            super(new de.flexiprovider.core.mars.MARS());
        }
    }

    public static class IDEA
    extends CBCMac {
        public IDEA() {
            super(new IDEA.IDEA_CBC());
        }
    }

    public static class DESede
    extends CBCMac {
        public DESede() {
            super(new DESede.DESede_CBC());
        }
    }

    public static class Camellia
    extends CBCMac {
        public Camellia() {
            super(new de.flexiprovider.core.camellia.Camellia());
        }
    }

    public static class AES256
    extends CBCMac {
        public AES256() {
            super(new Rijndael.AES.AES256_CBC());
        }
    }

    public static class AES192
    extends CBCMac {
        public AES192() {
            super(new Rijndael.AES.AES192_CBC());
        }
    }

    public static class AES128
    extends CBCMac {
        public AES128() {
            super(new Rijndael.AES.AES128_CBC());
        }
    }
}

