/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.mac;

import de.flexiprovider.api.BlockCipher;
import de.flexiprovider.api.Mac;
import de.flexiprovider.api.Registry;
import de.flexiprovider.api.SecureRandom;
import de.flexiprovider.api.exceptions.InvalidAlgorithmParameterException;
import de.flexiprovider.api.exceptions.InvalidKeyException;
import de.flexiprovider.api.exceptions.NoSuchModeException;
import de.flexiprovider.api.exceptions.NoSuchPaddingException;
import de.flexiprovider.api.keys.SecretKey;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.core.rijndael.Rijndael;
import java.io.ByteArrayOutputStream;

public class CMac
extends Mac {
    private ByteArrayOutputStream cipher1Input;
    private BlockCipher cipher;
    private BlockCipher cipher2;
    private SecureRandom sr;
    private int blockSize;
    private int macLength;
    private static final int R64 = 27;
    private static final int R128 = 135;
    private byte[] K1;
    private byte[] K2;

    protected CMac(BlockCipher blockCipher) {
        this.cipher = blockCipher;
        try {
            this.cipher2 = (BlockCipher)blockCipher.getClass().newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        try {
            this.cipher.setMode("CBC");
            this.cipher2.setMode("CBC");
        }
        catch (NoSuchModeException e) {
            throw new RuntimeException("Internal error: could not find mode 'CBC'.");
        }
        try {
            this.cipher.setPadding("NoPadding");
            this.cipher2.setPadding("NoPadding");
        }
        catch (NoSuchPaddingException e) {
            throw new RuntimeException("Internal error: could not find padding 'NoPadding'.");
        }
        this.macLength = this.cipher.getBlockSize();
        this.sr = Registry.getSecureRandom();
    }

    public byte[] doFinal() {
        int j;
        byte[] mess;
        byte[] macValue = new byte[this.macLength];
        if (this.cipher == null) {
            throw new IllegalStateException("MAC not initialized");
        }
        int r = this.cipher1Input.size() % this.blockSize;
        if (r != 0 || this.cipher1Input.size() == 0) {
            this.cipher1Input.write(-128);
            while (this.cipher1Input.size() % this.blockSize != 0) {
                this.cipher1Input.write(0);
            }
            mess = this.cipher1Input.toByteArray();
            j = mess.length;
            int i = 0;
            while (i < this.blockSize) {
                int n = j - this.blockSize + i;
                mess[n] = (byte)(mess[n] ^ this.K2[i]);
                ++i;
            }
        } else {
            mess = this.cipher1Input.toByteArray();
            j = mess.length;
            int i = 0;
            while (i < this.blockSize) {
                int n = j - this.blockSize + i;
                mess[n] = (byte)(mess[n] ^ this.K1[i]);
                ++i;
            }
        }
        try {
            byte[] result = this.cipher.doFinal(mess);
            System.arraycopy(result, result.length - (int)Math.ceil((double)this.macLength / (double)this.blockSize) * this.blockSize, macValue, 0, this.macLength);
        }
        catch (Exception e) {
            System.err.println("dowhile encrypting failed");
            e.printStackTrace();
        }
        this.reset();
        return macValue;
    }

    public int getMacLength() {
        if (this.cipher == null) {
            throw new IllegalStateException("MAC not initialized");
        }
        return this.macLength;
    }

    public void init(SecretKey key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.cipher.initEncrypt(key, params, this.sr);
        this.cipher2.initEncrypt(key, params, this.sr);
        this.keySchedule(key.getEncoded());
        this.cipher1Input = new ByteArrayOutputStream();
    }

    public void keySchedule(byte[] key) {
        this.blockSize = this.cipher.getBlockSize();
        int MSB = 0;
        int R = this.blockSize == 8 ? 27 : 135;
        this.K2 = new byte[this.blockSize];
        this.K1 = new byte[this.blockSize];
        try {
            this.K1 = this.cipher2.doFinal(this.K1);
            MSB = this.K1[0] & 0x80;
        }
        catch (Exception e) {
            System.err.println("dowhile encrypting failed");
            e.printStackTrace();
        }
        int i = 0;
        while (i < this.blockSize - 1) {
            this.K1[i] = (byte)(this.K1[i] << 1 | (this.K1[i + 1] & 0xFF) >>> 7);
            ++i;
        }
        this.K1[this.blockSize - 1] = (byte)(this.K1[this.blockSize - 1] << 1);
        if (MSB != 0) {
            this.K1[this.blockSize - 1] = (byte)(this.K1[this.blockSize - 1] ^ R);
        }
        System.arraycopy(this.K1, 0, this.K2, 0, this.blockSize);
        MSB = this.K2[0] & 0x80;
        int i2 = 0;
        while (i2 < this.blockSize - 1) {
            this.K2[i2] = (byte)(this.K2[i2] << 1 | (this.K2[i2 + 1] & 0xFF) >>> 7);
            ++i2;
        }
        this.K2[this.blockSize - 1] = (byte)(this.K2[this.blockSize - 1] << 1);
        if (MSB != 0) {
            this.K2[this.blockSize - 1] = (byte)(this.K2[this.blockSize - 1] ^ R);
        }
    }

    public void reset() {
        this.cipher1Input = new ByteArrayOutputStream();
    }

    public void update(byte b) {
        if (this.cipher == null) {
            throw new IllegalStateException("MAC not initialized");
        }
        this.cipher1Input.write(b);
    }

    public void update(byte[] bytes, int offset, int len) {
        if (this.cipher == null) {
            throw new IllegalStateException("MAC not initialized");
        }
        this.cipher1Input.write(bytes, offset, len);
    }

    public static class AES256
    extends CMac {
        public AES256() {
            super(new Rijndael.AES.AES256_CBC());
        }
    }

    public static class AES192
    extends CMac {
        public AES192() {
            super(new Rijndael.AES.AES192_CBC());
        }
    }

    public static class AES128
    extends CMac {
        public AES128() {
            super(new Rijndael.AES.AES128_CBC());
        }
    }

    public static class DESede
    extends CMac {
        public DESede() {
            super(new de.flexiprovider.core.desede.DESede());
        }
    }
}

