/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.mac;

import de.flexiprovider.api.keys.SecretKey;
import de.flexiprovider.common.util.ByteUtils;

public class HMacKey
implements SecretKey {
    private byte[] keyBytes;

    protected HMacKey(byte[] keyBytes) {
        this.keyBytes = ByteUtils.clone(keyBytes);
    }

    public String getAlgorithm() {
        return "Hmac";
    }

    public byte[] getEncoded() {
        return ByteUtils.clone(this.keyBytes);
    }

    public String getFormat() {
        return "RAW";
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof HMacKey)) {
            return false;
        }
        return ByteUtils.equals(this.keyBytes, ((HMacKey)other).keyBytes);
    }

    public int hashCode() {
        return this.keyBytes.hashCode();
    }
}

