/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.mac;

import de.flexiprovider.api.Mac;
import de.flexiprovider.api.exceptions.InvalidKeyException;
import de.flexiprovider.api.keys.SecretKey;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.common.util.LittleEndianConversions;

public abstract class TwoTrackMac
extends Mac {
    private byte[] buffer = new byte[64];
    private int[] x = new int[16];
    private int count;
    private boolean last_step = false;
    private int MAClength;
    private int[] keyinput = new int[5];
    private int[] state_l = new int[5];
    private int[] state_r = new int[5];

    protected TwoTrackMac(int len) {
        this.MAClength = len == 160 || len == 128 || len == 96 || len == 64 || len == 32 ? len : 160;
    }

    public int getMacLength() {
        return this.MAClength >> 3;
    }

    public void init(SecretKey key, AlgorithmParameterSpec params) throws InvalidKeyException {
        byte[] myKey = key.getEncoded();
        if (myKey.length != 20) {
            throw new InvalidKeyException("invalid key size");
        }
        int i = 0;
        while (i <= 4) {
            this.keyinput[i] = LittleEndianConversions.OS2IP(myKey, 4 * i);
            ++i;
        }
        int i2 = 0;
        while (i2 <= 4) {
            this.state_l[i2] = this.keyinput[i2];
            this.state_r[i2] = this.keyinput[i2];
            ++i2;
        }
    }

    public void update(byte b) {
        this.buffer[this.count & 0x3F] = b;
        if ((this.count & 0x3F) == 63) {
            this.x[0] = LittleEndianConversions.OS2IP(this.buffer, 0);
            this.x[1] = LittleEndianConversions.OS2IP(this.buffer, 4);
            this.x[2] = LittleEndianConversions.OS2IP(this.buffer, 8);
            this.x[3] = LittleEndianConversions.OS2IP(this.buffer, 12);
            this.x[4] = LittleEndianConversions.OS2IP(this.buffer, 16);
            this.x[5] = LittleEndianConversions.OS2IP(this.buffer, 20);
            this.x[6] = LittleEndianConversions.OS2IP(this.buffer, 24);
            this.x[7] = LittleEndianConversions.OS2IP(this.buffer, 28);
            this.x[8] = LittleEndianConversions.OS2IP(this.buffer, 32);
            this.x[9] = LittleEndianConversions.OS2IP(this.buffer, 36);
            this.x[10] = LittleEndianConversions.OS2IP(this.buffer, 40);
            this.x[11] = LittleEndianConversions.OS2IP(this.buffer, 44);
            this.x[12] = LittleEndianConversions.OS2IP(this.buffer, 48);
            this.x[13] = LittleEndianConversions.OS2IP(this.buffer, 52);
            this.x[14] = LittleEndianConversions.OS2IP(this.buffer, 56);
            this.x[15] = LittleEndianConversions.OS2IP(this.buffer, 60);
            this.processBlock();
        }
        ++this.count;
    }

    /*
     * Unable to fully structure code
     */
    public void update(byte[] bytes, int offset, int len) {
        while (len > 0 & (this.count & 63) != 0) {
            this.update(bytes[offset++]);
            --len;
        }
        if (len != 0) ** GOTO lbl27
        return;
lbl-1000:
        // 1 sources

        {
            this.x[0] = LittleEndianConversions.OS2IP(bytes, offset);
            this.x[1] = LittleEndianConversions.OS2IP(bytes, offset += 4);
            this.x[2] = LittleEndianConversions.OS2IP(bytes, offset += 4);
            this.x[3] = LittleEndianConversions.OS2IP(bytes, offset += 4);
            this.x[4] = LittleEndianConversions.OS2IP(bytes, offset += 4);
            this.x[5] = LittleEndianConversions.OS2IP(bytes, offset += 4);
            this.x[6] = LittleEndianConversions.OS2IP(bytes, offset += 4);
            this.x[7] = LittleEndianConversions.OS2IP(bytes, offset += 4);
            this.x[8] = LittleEndianConversions.OS2IP(bytes, offset += 4);
            this.x[9] = LittleEndianConversions.OS2IP(bytes, offset += 4);
            this.x[10] = LittleEndianConversions.OS2IP(bytes, offset += 4);
            this.x[11] = LittleEndianConversions.OS2IP(bytes, offset += 4);
            this.x[12] = LittleEndianConversions.OS2IP(bytes, offset += 4);
            this.x[13] = LittleEndianConversions.OS2IP(bytes, offset += 4);
            this.x[14] = LittleEndianConversions.OS2IP(bytes, offset += 4);
            this.x[15] = LittleEndianConversions.OS2IP(bytes, offset += 4);
            offset += 4;
            this.count += 64;
            len -= 64;
            this.processBlock();
lbl27:
            // 2 sources

            ** while (len >= 64)
        }
lbl28:
        // 1 sources

        if (len > 0) {
            System.arraycopy(bytes, offset, this.buffer, 0, len);
            this.count += len;
        }
    }

    public byte[] doFinal() {
        byte[] mac = new byte[this.MAClength >> 3];
        this.padMessageMac();
        if (this.MAClength == 160) {
            LittleEndianConversions.I2OSP(this.state_l[0], mac, 0);
            LittleEndianConversions.I2OSP(this.state_l[1], mac, 4);
            LittleEndianConversions.I2OSP(this.state_l[2], mac, 8);
            LittleEndianConversions.I2OSP(this.state_l[3], mac, 12);
            LittleEndianConversions.I2OSP(this.state_l[4], mac, 16);
        } else if (this.MAClength == 128) {
            LittleEndianConversions.I2OSP(this.state_l[0] + this.state_l[1] + this.state_l[3], mac, 0);
            LittleEndianConversions.I2OSP(this.state_l[1] + this.state_l[2] + this.state_l[4], mac, 4);
            LittleEndianConversions.I2OSP(this.state_l[2] + this.state_l[3] + this.state_l[0], mac, 8);
            LittleEndianConversions.I2OSP(this.state_l[3] + this.state_l[4] + this.state_l[1], mac, 12);
        } else if (this.MAClength == 96) {
            LittleEndianConversions.I2OSP(this.state_l[0] + this.state_l[1] + this.state_l[3], mac, 0);
            LittleEndianConversions.I2OSP(this.state_l[1] + this.state_l[2] + this.state_l[4], mac, 4);
            LittleEndianConversions.I2OSP(this.state_l[2] + this.state_l[3] + this.state_l[0], mac, 8);
        } else if (this.MAClength == 64) {
            LittleEndianConversions.I2OSP(this.state_l[0] + this.state_l[1] + this.state_l[3], mac, 0);
            LittleEndianConversions.I2OSP(this.state_l[1] + this.state_l[2] + this.state_l[4], mac, 4);
        } else if (this.MAClength == 32) {
            LittleEndianConversions.I2OSP(this.state_l[0] + this.state_l[1] + this.state_l[2] + this.state_l[3] + this.state_l[4], mac, 0);
        }
        this.reset();
        return mac;
    }

    public void reset() {
        int i = 0;
        while (i <= 4) {
            this.state_l[i] = this.keyinput[i];
            this.state_r[i] = this.keyinput[i];
            ++i;
        }
        this.count = 0;
        this.last_step = false;
    }

    private void padMessageMac() {
        long len = this.count << 3;
        this.update((byte)-128);
        while ((this.count & 0x3F) != 56) {
            this.update((byte)0);
        }
        int i = 0;
        while (i < 14) {
            this.x[i] = LittleEndianConversions.OS2IP(this.buffer, 4 * i);
            ++i;
        }
        this.x[14] = (int)(len & 0xFFFFFFFFFFFFFFFFL);
        this.x[15] = (int)(len >>> 32 & 0xFFFFFFFFFFFFFFFFL);
        this.last_step = true;
        this.processBlock();
    }

    private synchronized void processBlock() {
        int Er;
        int Dr;
        int Cr;
        int Br;
        int Ar;
        int El;
        int Dl;
        int Cl;
        int Bl;
        int Al;
        int[] C = new int[5];
        int[] D = new int[5];
        if (!this.last_step) {
            Al = this.state_l[0];
            Bl = this.state_l[1];
            Cl = this.state_l[2];
            Dl = this.state_l[3];
            El = this.state_l[4];
            Ar = this.state_r[0];
            Br = this.state_r[1];
            Cr = this.state_r[2];
            Dr = this.state_r[3];
            Er = this.state_r[4];
        } else {
            Al = this.state_r[0];
            Bl = this.state_r[1];
            Cl = this.state_r[2];
            Dl = this.state_r[3];
            El = this.state_r[4];
            Ar = this.state_l[0];
            Br = this.state_l[1];
            Cr = this.state_l[2];
            Dr = this.state_l[3];
            Er = this.state_l[4];
        }
        Al = this.rotateLeft(Al + this.F(Bl, Cl, Dl) + this.x[0], 11) + El;
        Cl = this.rotateLeft(Cl, 10);
        El = this.rotateLeft(El + this.F(Al, Bl, Cl) + this.x[1], 14) + Dl;
        Bl = this.rotateLeft(Bl, 10);
        Dl = this.rotateLeft(Dl + this.F(El, Al, Bl) + this.x[2], 15) + Cl;
        Al = this.rotateLeft(Al, 10);
        Cl = this.rotateLeft(Cl + this.F(Dl, El, Al) + this.x[3], 12) + Bl;
        El = this.rotateLeft(El, 10);
        Bl = this.rotateLeft(Bl + this.F(Cl, Dl, El) + this.x[4], 5) + Al;
        Dl = this.rotateLeft(Dl, 10);
        Al = this.rotateLeft(Al + this.F(Bl, Cl, Dl) + this.x[5], 8) + El;
        Cl = this.rotateLeft(Cl, 10);
        El = this.rotateLeft(El + this.F(Al, Bl, Cl) + this.x[6], 7) + Dl;
        Bl = this.rotateLeft(Bl, 10);
        Dl = this.rotateLeft(Dl + this.F(El, Al, Bl) + this.x[7], 9) + Cl;
        Al = this.rotateLeft(Al, 10);
        Cl = this.rotateLeft(Cl + this.F(Dl, El, Al) + this.x[8], 11) + Bl;
        El = this.rotateLeft(El, 10);
        Bl = this.rotateLeft(Bl + this.F(Cl, Dl, El) + this.x[9], 13) + Al;
        Dl = this.rotateLeft(Dl, 10);
        Al = this.rotateLeft(Al + this.F(Bl, Cl, Dl) + this.x[10], 14) + El;
        Cl = this.rotateLeft(Cl, 10);
        El = this.rotateLeft(El + this.F(Al, Bl, Cl) + this.x[11], 15) + Dl;
        Bl = this.rotateLeft(Bl, 10);
        Dl = this.rotateLeft(Dl + this.F(El, Al, Bl) + this.x[12], 6) + Cl;
        Al = this.rotateLeft(Al, 10);
        Cl = this.rotateLeft(Cl + this.F(Dl, El, Al) + this.x[13], 7) + Bl;
        El = this.rotateLeft(El, 10);
        Bl = this.rotateLeft(Bl + this.F(Cl, Dl, El) + this.x[14], 9) + Al;
        Dl = this.rotateLeft(Dl, 10);
        Al = this.rotateLeft(Al + this.F(Bl, Cl, Dl) + this.x[15], 8) + El;
        Cl = this.rotateLeft(Cl, 10);
        Ar = this.rotateLeft(Ar + this.L(Br, Cr, Dr) + this.x[5] + 1352829926, 8) + Er;
        Cr = this.rotateLeft(Cr, 10);
        Er = this.rotateLeft(Er + this.L(Ar, Br, Cr) + this.x[14] + 1352829926, 9) + Dr;
        Br = this.rotateLeft(Br, 10);
        Dr = this.rotateLeft(Dr + this.L(Er, Ar, Br) + this.x[7] + 1352829926, 9) + Cr;
        Ar = this.rotateLeft(Ar, 10);
        Cr = this.rotateLeft(Cr + this.L(Dr, Er, Ar) + this.x[0] + 1352829926, 11) + Br;
        Er = this.rotateLeft(Er, 10);
        Br = this.rotateLeft(Br + this.L(Cr, Dr, Er) + this.x[9] + 1352829926, 13) + Ar;
        Dr = this.rotateLeft(Dr, 10);
        Ar = this.rotateLeft(Ar + this.L(Br, Cr, Dr) + this.x[2] + 1352829926, 15) + Er;
        Cr = this.rotateLeft(Cr, 10);
        Er = this.rotateLeft(Er + this.L(Ar, Br, Cr) + this.x[11] + 1352829926, 15) + Dr;
        Br = this.rotateLeft(Br, 10);
        Dr = this.rotateLeft(Dr + this.L(Er, Ar, Br) + this.x[4] + 1352829926, 5) + Cr;
        Ar = this.rotateLeft(Ar, 10);
        Cr = this.rotateLeft(Cr + this.L(Dr, Er, Ar) + this.x[13] + 1352829926, 7) + Br;
        Er = this.rotateLeft(Er, 10);
        Br = this.rotateLeft(Br + this.L(Cr, Dr, Er) + this.x[6] + 1352829926, 7) + Ar;
        Dr = this.rotateLeft(Dr, 10);
        Ar = this.rotateLeft(Ar + this.L(Br, Cr, Dr) + this.x[15] + 1352829926, 8) + Er;
        Cr = this.rotateLeft(Cr, 10);
        Er = this.rotateLeft(Er + this.L(Ar, Br, Cr) + this.x[8] + 1352829926, 11) + Dr;
        Br = this.rotateLeft(Br, 10);
        Dr = this.rotateLeft(Dr + this.L(Er, Ar, Br) + this.x[1] + 1352829926, 14) + Cr;
        Ar = this.rotateLeft(Ar, 10);
        Cr = this.rotateLeft(Cr + this.L(Dr, Er, Ar) + this.x[10] + 1352829926, 14) + Br;
        Er = this.rotateLeft(Er, 10);
        Br = this.rotateLeft(Br + this.L(Cr, Dr, Er) + this.x[3] + 1352829926, 12) + Ar;
        Dr = this.rotateLeft(Dr, 10);
        Ar = this.rotateLeft(Ar + this.L(Br, Cr, Dr) + this.x[12] + 1352829926, 6) + Er;
        Cr = this.rotateLeft(Cr, 10);
        El = this.rotateLeft(El + this.G(Al, Bl, Cl) + this.x[7] + 1518500249, 7) + Dl;
        Bl = this.rotateLeft(Bl, 10);
        Dl = this.rotateLeft(Dl + this.G(El, Al, Bl) + this.x[4] + 1518500249, 6) + Cl;
        Al = this.rotateLeft(Al, 10);
        Cl = this.rotateLeft(Cl + this.G(Dl, El, Al) + this.x[13] + 1518500249, 8) + Bl;
        El = this.rotateLeft(El, 10);
        Bl = this.rotateLeft(Bl + this.G(Cl, Dl, El) + this.x[1] + 1518500249, 13) + Al;
        Dl = this.rotateLeft(Dl, 10);
        Al = this.rotateLeft(Al + this.G(Bl, Cl, Dl) + this.x[10] + 1518500249, 11) + El;
        Cl = this.rotateLeft(Cl, 10);
        El = this.rotateLeft(El + this.G(Al, Bl, Cl) + this.x[6] + 1518500249, 9) + Dl;
        Bl = this.rotateLeft(Bl, 10);
        Dl = this.rotateLeft(Dl + this.G(El, Al, Bl) + this.x[15] + 1518500249, 7) + Cl;
        Al = this.rotateLeft(Al, 10);
        Cl = this.rotateLeft(Cl + this.G(Dl, El, Al) + this.x[3] + 1518500249, 15) + Bl;
        El = this.rotateLeft(El, 10);
        Bl = this.rotateLeft(Bl + this.G(Cl, Dl, El) + this.x[12] + 1518500249, 7) + Al;
        Dl = this.rotateLeft(Dl, 10);
        Al = this.rotateLeft(Al + this.G(Bl, Cl, Dl) + this.x[0] + 1518500249, 12) + El;
        Cl = this.rotateLeft(Cl, 10);
        El = this.rotateLeft(El + this.G(Al, Bl, Cl) + this.x[9] + 1518500249, 15) + Dl;
        Bl = this.rotateLeft(Bl, 10);
        Dl = this.rotateLeft(Dl + this.G(El, Al, Bl) + this.x[5] + 1518500249, 9) + Cl;
        Al = this.rotateLeft(Al, 10);
        Cl = this.rotateLeft(Cl + this.G(Dl, El, Al) + this.x[2] + 1518500249, 11) + Bl;
        El = this.rotateLeft(El, 10);
        Bl = this.rotateLeft(Bl + this.G(Cl, Dl, El) + this.x[14] + 1518500249, 7) + Al;
        Dl = this.rotateLeft(Dl, 10);
        Al = this.rotateLeft(Al + this.G(Bl, Cl, Dl) + this.x[11] + 1518500249, 13) + El;
        Cl = this.rotateLeft(Cl, 10);
        El = this.rotateLeft(El + this.G(Al, Bl, Cl) + this.x[8] + 1518500249, 12) + Dl;
        Bl = this.rotateLeft(Bl, 10);
        Er = this.rotateLeft(Er + this.K(Ar, Br, Cr) + this.x[6] + 1548603684, 9) + Dr;
        Br = this.rotateLeft(Br, 10);
        Dr = this.rotateLeft(Dr + this.K(Er, Ar, Br) + this.x[11] + 1548603684, 13) + Cr;
        Ar = this.rotateLeft(Ar, 10);
        Cr = this.rotateLeft(Cr + this.K(Dr, Er, Ar) + this.x[3] + 1548603684, 15) + Br;
        Er = this.rotateLeft(Er, 10);
        Br = this.rotateLeft(Br + this.K(Cr, Dr, Er) + this.x[7] + 1548603684, 7) + Ar;
        Dr = this.rotateLeft(Dr, 10);
        Ar = this.rotateLeft(Ar + this.K(Br, Cr, Dr) + this.x[0] + 1548603684, 12) + Er;
        Cr = this.rotateLeft(Cr, 10);
        Er = this.rotateLeft(Er + this.K(Ar, Br, Cr) + this.x[13] + 1548603684, 8) + Dr;
        Br = this.rotateLeft(Br, 10);
        Dr = this.rotateLeft(Dr + this.K(Er, Ar, Br) + this.x[5] + 1548603684, 9) + Cr;
        Ar = this.rotateLeft(Ar, 10);
        Cr = this.rotateLeft(Cr + this.K(Dr, Er, Ar) + this.x[10] + 1548603684, 11) + Br;
        Er = this.rotateLeft(Er, 10);
        Br = this.rotateLeft(Br + this.K(Cr, Dr, Er) + this.x[14] + 1548603684, 7) + Ar;
        Dr = this.rotateLeft(Dr, 10);
        Ar = this.rotateLeft(Ar + this.K(Br, Cr, Dr) + this.x[15] + 1548603684, 7) + Er;
        Cr = this.rotateLeft(Cr, 10);
        Er = this.rotateLeft(Er + this.K(Ar, Br, Cr) + this.x[8] + 1548603684, 12) + Dr;
        Br = this.rotateLeft(Br, 10);
        Dr = this.rotateLeft(Dr + this.K(Er, Ar, Br) + this.x[12] + 1548603684, 7) + Cr;
        Ar = this.rotateLeft(Ar, 10);
        Cr = this.rotateLeft(Cr + this.K(Dr, Er, Ar) + this.x[4] + 1548603684, 6) + Br;
        Er = this.rotateLeft(Er, 10);
        Br = this.rotateLeft(Br + this.K(Cr, Dr, Er) + this.x[9] + 1548603684, 15) + Ar;
        Dr = this.rotateLeft(Dr, 10);
        Ar = this.rotateLeft(Ar + this.K(Br, Cr, Dr) + this.x[1] + 1548603684, 13) + Er;
        Cr = this.rotateLeft(Cr, 10);
        Er = this.rotateLeft(Er + this.K(Ar, Br, Cr) + this.x[2] + 1548603684, 11) + Dr;
        Br = this.rotateLeft(Br, 10);
        Dl = this.rotateLeft(Dl + this.H(El, Al, Bl) + this.x[3] + 1859775393, 11) + Cl;
        Al = this.rotateLeft(Al, 10);
        Cl = this.rotateLeft(Cl + this.H(Dl, El, Al) + this.x[10] + 1859775393, 13) + Bl;
        El = this.rotateLeft(El, 10);
        Bl = this.rotateLeft(Bl + this.H(Cl, Dl, El) + this.x[14] + 1859775393, 6) + Al;
        Dl = this.rotateLeft(Dl, 10);
        Al = this.rotateLeft(Al + this.H(Bl, Cl, Dl) + this.x[4] + 1859775393, 7) + El;
        Cl = this.rotateLeft(Cl, 10);
        El = this.rotateLeft(El + this.H(Al, Bl, Cl) + this.x[9] + 1859775393, 14) + Dl;
        Bl = this.rotateLeft(Bl, 10);
        Dl = this.rotateLeft(Dl + this.H(El, Al, Bl) + this.x[15] + 1859775393, 9) + Cl;
        Al = this.rotateLeft(Al, 10);
        Cl = this.rotateLeft(Cl + this.H(Dl, El, Al) + this.x[8] + 1859775393, 13) + Bl;
        El = this.rotateLeft(El, 10);
        Bl = this.rotateLeft(Bl + this.H(Cl, Dl, El) + this.x[1] + 1859775393, 15) + Al;
        Dl = this.rotateLeft(Dl, 10);
        Al = this.rotateLeft(Al + this.H(Bl, Cl, Dl) + this.x[2] + 1859775393, 14) + El;
        Cl = this.rotateLeft(Cl, 10);
        El = this.rotateLeft(El + this.H(Al, Bl, Cl) + this.x[7] + 1859775393, 8) + Dl;
        Bl = this.rotateLeft(Bl, 10);
        Dl = this.rotateLeft(Dl + this.H(El, Al, Bl) + this.x[0] + 1859775393, 13) + Cl;
        Al = this.rotateLeft(Al, 10);
        Cl = this.rotateLeft(Cl + this.H(Dl, El, Al) + this.x[6] + 1859775393, 6) + Bl;
        El = this.rotateLeft(El, 10);
        Bl = this.rotateLeft(Bl + this.H(Cl, Dl, El) + this.x[13] + 1859775393, 5) + Al;
        Dl = this.rotateLeft(Dl, 10);
        Al = this.rotateLeft(Al + this.H(Bl, Cl, Dl) + this.x[11] + 1859775393, 12) + El;
        Cl = this.rotateLeft(Cl, 10);
        El = this.rotateLeft(El + this.H(Al, Bl, Cl) + this.x[5] + 1859775393, 7) + Dl;
        Bl = this.rotateLeft(Bl, 10);
        Dl = this.rotateLeft(Dl + this.H(El, Al, Bl) + this.x[12] + 1859775393, 5) + Cl;
        Al = this.rotateLeft(Al, 10);
        Dr = this.rotateLeft(Dr + this.H(Er, Ar, Br) + this.x[15] + 1836072691, 9) + Cr;
        Ar = this.rotateLeft(Ar, 10);
        Cr = this.rotateLeft(Cr + this.H(Dr, Er, Ar) + this.x[5] + 1836072691, 7) + Br;
        Er = this.rotateLeft(Er, 10);
        Br = this.rotateLeft(Br + this.H(Cr, Dr, Er) + this.x[1] + 1836072691, 15) + Ar;
        Dr = this.rotateLeft(Dr, 10);
        Ar = this.rotateLeft(Ar + this.H(Br, Cr, Dr) + this.x[3] + 1836072691, 11) + Er;
        Cr = this.rotateLeft(Cr, 10);
        Er = this.rotateLeft(Er + this.H(Ar, Br, Cr) + this.x[7] + 1836072691, 8) + Dr;
        Br = this.rotateLeft(Br, 10);
        Dr = this.rotateLeft(Dr + this.H(Er, Ar, Br) + this.x[14] + 1836072691, 6) + Cr;
        Ar = this.rotateLeft(Ar, 10);
        Cr = this.rotateLeft(Cr + this.H(Dr, Er, Ar) + this.x[6] + 1836072691, 6) + Br;
        Er = this.rotateLeft(Er, 10);
        Br = this.rotateLeft(Br + this.H(Cr, Dr, Er) + this.x[9] + 1836072691, 14) + Ar;
        Dr = this.rotateLeft(Dr, 10);
        Ar = this.rotateLeft(Ar + this.H(Br, Cr, Dr) + this.x[11] + 1836072691, 12) + Er;
        Cr = this.rotateLeft(Cr, 10);
        Er = this.rotateLeft(Er + this.H(Ar, Br, Cr) + this.x[8] + 1836072691, 13) + Dr;
        Br = this.rotateLeft(Br, 10);
        Dr = this.rotateLeft(Dr + this.H(Er, Ar, Br) + this.x[12] + 1836072691, 5) + Cr;
        Ar = this.rotateLeft(Ar, 10);
        Cr = this.rotateLeft(Cr + this.H(Dr, Er, Ar) + this.x[2] + 1836072691, 14) + Br;
        Er = this.rotateLeft(Er, 10);
        Br = this.rotateLeft(Br + this.H(Cr, Dr, Er) + this.x[10] + 1836072691, 13) + Ar;
        Dr = this.rotateLeft(Dr, 10);
        Ar = this.rotateLeft(Ar + this.H(Br, Cr, Dr) + this.x[0] + 1836072691, 13) + Er;
        Cr = this.rotateLeft(Cr, 10);
        Er = this.rotateLeft(Er + this.H(Ar, Br, Cr) + this.x[4] + 1836072691, 7) + Dr;
        Br = this.rotateLeft(Br, 10);
        Dr = this.rotateLeft(Dr + this.H(Er, Ar, Br) + this.x[13] + 1836072691, 5) + Cr;
        Ar = this.rotateLeft(Ar, 10);
        Cl = this.rotateLeft(Cl + this.K(Dl, El, Al) + this.x[1] + -1894007588, 11) + Bl;
        El = this.rotateLeft(El, 10);
        Bl = this.rotateLeft(Bl + this.K(Cl, Dl, El) + this.x[9] + -1894007588, 12) + Al;
        Dl = this.rotateLeft(Dl, 10);
        Al = this.rotateLeft(Al + this.K(Bl, Cl, Dl) + this.x[11] + -1894007588, 14) + El;
        Cl = this.rotateLeft(Cl, 10);
        El = this.rotateLeft(El + this.K(Al, Bl, Cl) + this.x[10] + -1894007588, 15) + Dl;
        Bl = this.rotateLeft(Bl, 10);
        Dl = this.rotateLeft(Dl + this.K(El, Al, Bl) + this.x[0] + -1894007588, 14) + Cl;
        Al = this.rotateLeft(Al, 10);
        Cl = this.rotateLeft(Cl + this.K(Dl, El, Al) + this.x[8] + -1894007588, 15) + Bl;
        El = this.rotateLeft(El, 10);
        Bl = this.rotateLeft(Bl + this.K(Cl, Dl, El) + this.x[12] + -1894007588, 9) + Al;
        Dl = this.rotateLeft(Dl, 10);
        Al = this.rotateLeft(Al + this.K(Bl, Cl, Dl) + this.x[4] + -1894007588, 8) + El;
        Cl = this.rotateLeft(Cl, 10);
        El = this.rotateLeft(El + this.K(Al, Bl, Cl) + this.x[13] + -1894007588, 9) + Dl;
        Bl = this.rotateLeft(Bl, 10);
        Dl = this.rotateLeft(Dl + this.K(El, Al, Bl) + this.x[3] + -1894007588, 14) + Cl;
        Al = this.rotateLeft(Al, 10);
        Cl = this.rotateLeft(Cl + this.K(Dl, El, Al) + this.x[7] + -1894007588, 5) + Bl;
        El = this.rotateLeft(El, 10);
        Bl = this.rotateLeft(Bl + this.K(Cl, Dl, El) + this.x[15] + -1894007588, 6) + Al;
        Dl = this.rotateLeft(Dl, 10);
        Al = this.rotateLeft(Al + this.K(Bl, Cl, Dl) + this.x[14] + -1894007588, 8) + El;
        Cl = this.rotateLeft(Cl, 10);
        El = this.rotateLeft(El + this.K(Al, Bl, Cl) + this.x[5] + -1894007588, 6) + Dl;
        Bl = this.rotateLeft(Bl, 10);
        Dl = this.rotateLeft(Dl + this.K(El, Al, Bl) + this.x[6] + -1894007588, 5) + Cl;
        Al = this.rotateLeft(Al, 10);
        Cl = this.rotateLeft(Cl + this.K(Dl, El, Al) + this.x[2] + -1894007588, 12) + Bl;
        El = this.rotateLeft(El, 10);
        Cr = this.rotateLeft(Cr + this.G(Dr, Er, Ar) + this.x[8] + 2053994217, 15) + Br;
        Er = this.rotateLeft(Er, 10);
        Br = this.rotateLeft(Br + this.G(Cr, Dr, Er) + this.x[6] + 2053994217, 5) + Ar;
        Dr = this.rotateLeft(Dr, 10);
        Ar = this.rotateLeft(Ar + this.G(Br, Cr, Dr) + this.x[4] + 2053994217, 8) + Er;
        Cr = this.rotateLeft(Cr, 10);
        Er = this.rotateLeft(Er + this.G(Ar, Br, Cr) + this.x[1] + 2053994217, 11) + Dr;
        Br = this.rotateLeft(Br, 10);
        Dr = this.rotateLeft(Dr + this.G(Er, Ar, Br) + this.x[3] + 2053994217, 14) + Cr;
        Ar = this.rotateLeft(Ar, 10);
        Cr = this.rotateLeft(Cr + this.G(Dr, Er, Ar) + this.x[11] + 2053994217, 14) + Br;
        Er = this.rotateLeft(Er, 10);
        Br = this.rotateLeft(Br + this.G(Cr, Dr, Er) + this.x[15] + 2053994217, 6) + Ar;
        Dr = this.rotateLeft(Dr, 10);
        Ar = this.rotateLeft(Ar + this.G(Br, Cr, Dr) + this.x[0] + 2053994217, 14) + Er;
        Cr = this.rotateLeft(Cr, 10);
        Er = this.rotateLeft(Er + this.G(Ar, Br, Cr) + this.x[5] + 2053994217, 6) + Dr;
        Br = this.rotateLeft(Br, 10);
        Dr = this.rotateLeft(Dr + this.G(Er, Ar, Br) + this.x[12] + 2053994217, 9) + Cr;
        Ar = this.rotateLeft(Ar, 10);
        Cr = this.rotateLeft(Cr + this.G(Dr, Er, Ar) + this.x[2] + 2053994217, 12) + Br;
        Er = this.rotateLeft(Er, 10);
        Br = this.rotateLeft(Br + this.G(Cr, Dr, Er) + this.x[13] + 2053994217, 9) + Ar;
        Dr = this.rotateLeft(Dr, 10);
        Ar = this.rotateLeft(Ar + this.G(Br, Cr, Dr) + this.x[9] + 2053994217, 12) + Er;
        Cr = this.rotateLeft(Cr, 10);
        Er = this.rotateLeft(Er + this.G(Ar, Br, Cr) + this.x[7] + 2053994217, 5) + Dr;
        Br = this.rotateLeft(Br, 10);
        Dr = this.rotateLeft(Dr + this.G(Er, Ar, Br) + this.x[10] + 2053994217, 15) + Cr;
        Ar = this.rotateLeft(Ar, 10);
        Cr = this.rotateLeft(Cr + this.G(Dr, Er, Ar) + this.x[14] + 2053994217, 8) + Br;
        Er = this.rotateLeft(Er, 10);
        Bl = this.rotateLeft(Bl + this.L(Cl, Dl, El) + this.x[4] + -1454113458, 9) + Al;
        Dl = this.rotateLeft(Dl, 10);
        Al = this.rotateLeft(Al + this.L(Bl, Cl, Dl) + this.x[0] + -1454113458, 15) + El;
        Cl = this.rotateLeft(Cl, 10);
        El = this.rotateLeft(El + this.L(Al, Bl, Cl) + this.x[5] + -1454113458, 5) + Dl;
        Bl = this.rotateLeft(Bl, 10);
        Dl = this.rotateLeft(Dl + this.L(El, Al, Bl) + this.x[9] + -1454113458, 11) + Cl;
        Al = this.rotateLeft(Al, 10);
        Cl = this.rotateLeft(Cl + this.L(Dl, El, Al) + this.x[7] + -1454113458, 6) + Bl;
        El = this.rotateLeft(El, 10);
        Bl = this.rotateLeft(Bl + this.L(Cl, Dl, El) + this.x[12] + -1454113458, 8) + Al;
        Dl = this.rotateLeft(Dl, 10);
        Al = this.rotateLeft(Al + this.L(Bl, Cl, Dl) + this.x[2] + -1454113458, 13) + El;
        Cl = this.rotateLeft(Cl, 10);
        El = this.rotateLeft(El + this.L(Al, Bl, Cl) + this.x[10] + -1454113458, 12) + Dl;
        Bl = this.rotateLeft(Bl, 10);
        Dl = this.rotateLeft(Dl + this.L(El, Al, Bl) + this.x[14] + -1454113458, 5) + Cl;
        Al = this.rotateLeft(Al, 10);
        Cl = this.rotateLeft(Cl + this.L(Dl, El, Al) + this.x[1] + -1454113458, 12) + Bl;
        El = this.rotateLeft(El, 10);
        Bl = this.rotateLeft(Bl + this.L(Cl, Dl, El) + this.x[3] + -1454113458, 13) + Al;
        Dl = this.rotateLeft(Dl, 10);
        Al = this.rotateLeft(Al + this.L(Bl, Cl, Dl) + this.x[8] + -1454113458, 14) + El;
        Cl = this.rotateLeft(Cl, 10);
        El = this.rotateLeft(El + this.L(Al, Bl, Cl) + this.x[11] + -1454113458, 11) + Dl;
        Bl = this.rotateLeft(Bl, 10);
        Dl = this.rotateLeft(Dl + this.L(El, Al, Bl) + this.x[6] + -1454113458, 8) + Cl;
        Al = this.rotateLeft(Al, 10);
        Cl = this.rotateLeft(Cl + this.L(Dl, El, Al) + this.x[15] + -1454113458, 5) + Bl;
        El = this.rotateLeft(El, 10);
        Bl = this.rotateLeft(Bl + this.L(Cl, Dl, El) + this.x[13] + -1454113458, 6) + Al;
        Dl = this.rotateLeft(Dl, 10);
        Br = this.rotateLeft(Br + this.F(Cr, Dr, Er) + this.x[12], 8) + Ar;
        Dr = this.rotateLeft(Dr, 10);
        Ar = this.rotateLeft(Ar + this.F(Br, Cr, Dr) + this.x[15], 5) + Er;
        Cr = this.rotateLeft(Cr, 10);
        Er = this.rotateLeft(Er + this.F(Ar, Br, Cr) + this.x[10], 12) + Dr;
        Br = this.rotateLeft(Br, 10);
        Dr = this.rotateLeft(Dr + this.F(Er, Ar, Br) + this.x[4], 9) + Cr;
        Ar = this.rotateLeft(Ar, 10);
        Cr = this.rotateLeft(Cr + this.F(Dr, Er, Ar) + this.x[1], 12) + Br;
        Er = this.rotateLeft(Er, 10);
        Br = this.rotateLeft(Br + this.F(Cr, Dr, Er) + this.x[5], 5) + Ar;
        Dr = this.rotateLeft(Dr, 10);
        Ar = this.rotateLeft(Ar + this.F(Br, Cr, Dr) + this.x[8], 14) + Er;
        Cr = this.rotateLeft(Cr, 10);
        Er = this.rotateLeft(Er + this.F(Ar, Br, Cr) + this.x[7], 6) + Dr;
        Br = this.rotateLeft(Br, 10);
        Dr = this.rotateLeft(Dr + this.F(Er, Ar, Br) + this.x[6], 8) + Cr;
        Ar = this.rotateLeft(Ar, 10);
        Cr = this.rotateLeft(Cr + this.F(Dr, Er, Ar) + this.x[2], 13) + Br;
        Er = this.rotateLeft(Er, 10);
        Br = this.rotateLeft(Br + this.F(Cr, Dr, Er) + this.x[13], 6) + Ar;
        Dr = this.rotateLeft(Dr, 10);
        Ar = this.rotateLeft(Ar + this.F(Br, Cr, Dr) + this.x[14], 5) + Er;
        Cr = this.rotateLeft(Cr, 10);
        Er = this.rotateLeft(Er + this.F(Ar, Br, Cr) + this.x[0], 15) + Dr;
        Br = this.rotateLeft(Br, 10);
        Dr = this.rotateLeft(Dr + this.F(Er, Ar, Br) + this.x[3], 13) + Cr;
        Ar = this.rotateLeft(Ar, 10);
        Cr = this.rotateLeft(Cr + this.F(Dr, Er, Ar) + this.x[9], 11) + Br;
        Er = this.rotateLeft(Er, 10);
        Br = this.rotateLeft(Br + this.F(Cr, Dr, Er) + this.x[11], 11) + Ar;
        Dr = this.rotateLeft(Dr, 10);
        if (this.last_step) {
            int[] tmp = new int[]{Al, Bl, Cl, Dl, El};
            Al = Ar;
            Bl = Br;
            Cl = Cr;
            Dl = Dr;
            El = Er;
            Ar = tmp[0];
            Br = tmp[1];
            Cr = tmp[2];
            Dr = tmp[3];
            Er = tmp[4];
            C[0] = Al - this.state_l[0];
            D[0] = Ar - this.state_r[0];
            C[1] = Bl - this.state_l[1];
            D[1] = Br - this.state_r[1];
            C[2] = Cl - this.state_l[2];
            D[2] = Cr - this.state_r[2];
            C[3] = Dl - this.state_l[3];
            D[3] = Dr - this.state_r[3];
            C[4] = El - this.state_l[4];
            D[4] = Er - this.state_r[4];
            this.state_l[0] = C[0] - D[0];
            this.state_l[1] = C[1] - D[1];
            this.state_l[2] = C[2] - D[2];
            this.state_l[3] = C[3] - D[3];
            this.state_l[4] = C[4] - D[4];
        } else {
            C[0] = Al - this.state_l[0];
            D[0] = Ar - this.state_r[0];
            C[1] = Bl - this.state_l[1];
            D[1] = Br - this.state_r[1];
            C[2] = Cl - this.state_l[2];
            D[2] = Cr - this.state_r[2];
            C[3] = Dl - this.state_l[3];
            D[3] = Dr - this.state_r[3];
            C[4] = El - this.state_l[4];
            D[4] = Er - this.state_r[4];
            this.state_l[0] = C[1] + C[4] - D[3];
            this.state_l[1] = C[2] - D[4];
            this.state_l[2] = C[3] - D[0];
            this.state_l[3] = C[4] - D[1];
            this.state_l[4] = C[0] - D[2];
            this.state_r[0] = C[3] - D[4];
            this.state_r[1] = C[4] + C[2] - D[0];
            this.state_r[2] = C[0] - D[1];
            this.state_r[3] = C[1] - D[2];
            this.state_r[4] = C[2] - D[3];
        }
    }

    private int F(int u, int v, int w) {
        return u ^ v ^ w;
    }

    private int G(int u, int v, int w) {
        return u & v | ~u & w;
    }

    private int H(int u, int v, int w) {
        return (u | ~v) ^ w;
    }

    private int K(int u, int v, int w) {
        return u & w | v & ~w;
    }

    private int L(int u, int v, int w) {
        return u ^ (v | ~w);
    }

    private int rotateLeft(int x, int n) {
        return x << n | x >>> 32 - n;
    }

    public static class TTMac160
    extends TwoTrackMac {
        public TTMac160() {
            super(160);
        }
    }

    public static class TTMac128
    extends TwoTrackMac {
        public TTMac128() {
            super(128);
        }
    }

    public static class TTMac96
    extends TwoTrackMac {
        public TTMac96() {
            super(96);
        }
    }

    public static class TTMac64
    extends TwoTrackMac {
        public TTMac64() {
            super(64);
        }
    }

    public static class TTMac32
    extends TwoTrackMac {
        public TTMac32() {
            super(32);
        }
    }
}

