/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.md;

import de.flexiprovider.api.MessageDigest;
import de.flexiprovider.common.util.BigEndianConversions;

public class DHA256
extends MessageDigest {
    private static final int[] H0 = new int[]{1779033703, -1150833019, 1013904242, -1521486534, 1359893119, -1694144372, 528734635, 1541459225};
    private static final int[] K = new int[]{1116352408, 1899447441, -1245643825, -373957723, 961987163, 1508970993, -1841331548, -1424204075, -670586216, 310598401, 607225278, 1426881987, 1925078388, -2132889090, -1680079193, -1046744716, -459576895, -272742522, 264347078, 604807628, 770255983, 1249150122, 1555081692, 1996064986, -1740746414, -1473132947, -1341970488, -1084653625, -958395405, -710438585, 113926993, 338241895, 666307205, 773529912, 1294757372, 1396182291, 1695183700, 1986661051, -2117940946, -1838011259, -1564481375, -1474664885, -1035236496, -949202525, -778901479, -694614492, -200395387, 275423344, 430227734, 506948616, 659060556, 883997877, 958139571, 1322822218, 1537002063, 1747873779, 1955562222, 2024104815, -2067236844, -1933114872, -1866530822, -1538233109, -1090935817, -965641998};
    private static final int DHA256_DIGEST_LENGTH = 32;
    private byte[] buffer;
    private long count;
    private int[] H = new int[8];

    public DHA256() {
        this.buffer = new byte[64];
        this.reset();
    }

    public int getDigestLength() {
        return 32;
    }

    public synchronized void update(byte[] input, int inOff, int inLen) {
        int bufOffset = (int)this.count & 0x3F;
        while (inLen > 0) {
            int copyLen = 64 - bufOffset;
            copyLen = inLen > copyLen ? copyLen : inLen;
            System.arraycopy(input, inOff, this.buffer, bufOffset, copyLen);
            inLen -= copyLen;
            inOff += copyLen;
            this.count += (long)copyLen;
            bufOffset = bufOffset + copyLen & 0x3F;
            if (bufOffset != 0) continue;
            this.processBlock();
        }
    }

    public synchronized void update(byte input) {
        this.buffer[(int)this.count & 0x3F] = input;
        if ((int)(this.count & 0x3FL) == 63) {
            this.processBlock();
        }
        ++this.count;
    }

    public synchronized byte[] digest() {
        this.pad();
        byte[] digestValue = new byte[32];
        int i = 0;
        while (i < 8) {
            BigEndianConversions.I2OSP(this.H[i], digestValue, i << 2);
            ++i;
        }
        this.reset();
        return digestValue;
    }

    public void reset() {
        this.H[0] = H0[0];
        this.H[1] = H0[1];
        this.H[2] = H0[2];
        this.H[3] = H0[3];
        this.H[4] = H0[4];
        this.H[5] = H0[5];
        this.H[6] = H0[6];
        this.H[7] = H0[7];
        this.count = 0L;
    }

    private synchronized void processBlock() {
        int[] W = new int[64];
        int a = this.H[0];
        int b = this.H[1];
        int c = this.H[2];
        int d = this.H[3];
        int e = this.H[4];
        int f = this.H[5];
        int g = this.H[6];
        int h = this.H[7];
        W[0] = BigEndianConversions.OS2IP(this.buffer, 0);
        W[1] = BigEndianConversions.OS2IP(this.buffer, 4);
        W[2] = BigEndianConversions.OS2IP(this.buffer, 8);
        W[3] = BigEndianConversions.OS2IP(this.buffer, 12);
        W[4] = BigEndianConversions.OS2IP(this.buffer, 16);
        W[5] = BigEndianConversions.OS2IP(this.buffer, 20);
        W[6] = BigEndianConversions.OS2IP(this.buffer, 24);
        W[7] = BigEndianConversions.OS2IP(this.buffer, 28);
        W[8] = BigEndianConversions.OS2IP(this.buffer, 32);
        W[9] = BigEndianConversions.OS2IP(this.buffer, 36);
        W[10] = BigEndianConversions.OS2IP(this.buffer, 40);
        W[11] = BigEndianConversions.OS2IP(this.buffer, 44);
        W[12] = BigEndianConversions.OS2IP(this.buffer, 48);
        W[13] = BigEndianConversions.OS2IP(this.buffer, 52);
        W[14] = BigEndianConversions.OS2IP(this.buffer, 56);
        W[15] = BigEndianConversions.OS2IP(this.buffer, 60);
        W[16] = DHA256.sigma1(W[1]) + W[7] + DHA256.sigma0(W[15]) + W[0];
        W[17] = DHA256.sigma1(W[2]) + W[8] + DHA256.sigma0(W[16]) + W[1];
        W[18] = DHA256.sigma1(W[3]) + W[9] + DHA256.sigma0(W[17]) + W[2];
        W[19] = DHA256.sigma1(W[4]) + W[10] + DHA256.sigma0(W[18]) + W[3];
        W[20] = DHA256.sigma1(W[5]) + W[11] + DHA256.sigma0(W[19]) + W[4];
        W[21] = DHA256.sigma1(W[6]) + W[12] + DHA256.sigma0(W[20]) + W[5];
        W[22] = DHA256.sigma1(W[7]) + W[13] + DHA256.sigma0(W[21]) + W[6];
        W[23] = DHA256.sigma1(W[8]) + W[14] + DHA256.sigma0(W[22]) + W[7];
        W[24] = DHA256.sigma1(W[9]) + W[15] + DHA256.sigma0(W[23]) + W[8];
        W[25] = DHA256.sigma1(W[10]) + W[16] + DHA256.sigma0(W[24]) + W[9];
        W[26] = DHA256.sigma1(W[11]) + W[17] + DHA256.sigma0(W[25]) + W[10];
        W[27] = DHA256.sigma1(W[12]) + W[18] + DHA256.sigma0(W[26]) + W[11];
        W[28] = DHA256.sigma1(W[13]) + W[19] + DHA256.sigma0(W[27]) + W[12];
        W[29] = DHA256.sigma1(W[14]) + W[20] + DHA256.sigma0(W[28]) + W[13];
        W[30] = DHA256.sigma1(W[15]) + W[21] + DHA256.sigma0(W[29]) + W[14];
        W[31] = DHA256.sigma1(W[16]) + W[22] + DHA256.sigma0(W[30]) + W[15];
        W[32] = DHA256.sigma1(W[17]) + W[23] + DHA256.sigma0(W[31]) + W[16];
        W[33] = DHA256.sigma1(W[18]) + W[24] + DHA256.sigma0(W[32]) + W[17];
        W[34] = DHA256.sigma1(W[19]) + W[25] + DHA256.sigma0(W[33]) + W[18];
        W[35] = DHA256.sigma1(W[20]) + W[26] + DHA256.sigma0(W[34]) + W[19];
        W[36] = DHA256.sigma1(W[21]) + W[27] + DHA256.sigma0(W[35]) + W[20];
        W[37] = DHA256.sigma1(W[22]) + W[28] + DHA256.sigma0(W[36]) + W[21];
        W[38] = DHA256.sigma1(W[23]) + W[29] + DHA256.sigma0(W[37]) + W[22];
        W[39] = DHA256.sigma1(W[24]) + W[30] + DHA256.sigma0(W[38]) + W[23];
        W[40] = DHA256.sigma1(W[25]) + W[31] + DHA256.sigma0(W[39]) + W[24];
        W[41] = DHA256.sigma1(W[26]) + W[32] + DHA256.sigma0(W[40]) + W[25];
        W[42] = DHA256.sigma1(W[27]) + W[33] + DHA256.sigma0(W[41]) + W[26];
        W[43] = DHA256.sigma1(W[28]) + W[34] + DHA256.sigma0(W[42]) + W[27];
        W[44] = DHA256.sigma1(W[29]) + W[35] + DHA256.sigma0(W[43]) + W[28];
        W[45] = DHA256.sigma1(W[30]) + W[36] + DHA256.sigma0(W[44]) + W[29];
        W[46] = DHA256.sigma1(W[31]) + W[37] + DHA256.sigma0(W[45]) + W[30];
        W[47] = DHA256.sigma1(W[32]) + W[38] + DHA256.sigma0(W[46]) + W[31];
        W[48] = DHA256.sigma1(W[33]) + W[39] + DHA256.sigma0(W[47]) + W[32];
        W[49] = DHA256.sigma1(W[34]) + W[40] + DHA256.sigma0(W[48]) + W[33];
        W[50] = DHA256.sigma1(W[35]) + W[41] + DHA256.sigma0(W[49]) + W[34];
        W[51] = DHA256.sigma1(W[36]) + W[42] + DHA256.sigma0(W[50]) + W[35];
        W[52] = DHA256.sigma1(W[37]) + W[43] + DHA256.sigma0(W[51]) + W[36];
        W[53] = DHA256.sigma1(W[38]) + W[44] + DHA256.sigma0(W[52]) + W[37];
        W[54] = DHA256.sigma1(W[39]) + W[45] + DHA256.sigma0(W[53]) + W[38];
        W[55] = DHA256.sigma1(W[40]) + W[46] + DHA256.sigma0(W[54]) + W[39];
        W[56] = DHA256.sigma1(W[41]) + W[47] + DHA256.sigma0(W[55]) + W[40];
        W[57] = DHA256.sigma1(W[42]) + W[48] + DHA256.sigma0(W[56]) + W[41];
        W[58] = DHA256.sigma1(W[43]) + W[49] + DHA256.sigma0(W[57]) + W[42];
        W[59] = DHA256.sigma1(W[44]) + W[50] + DHA256.sigma0(W[58]) + W[43];
        W[60] = DHA256.sigma1(W[45]) + W[51] + DHA256.sigma0(W[59]) + W[44];
        W[61] = DHA256.sigma1(W[46]) + W[52] + DHA256.sigma0(W[60]) + W[45];
        W[62] = DHA256.sigma1(W[47]) + W[53] + DHA256.sigma0(W[61]) + W[46];
        W[63] = DHA256.sigma1(W[48]) + W[54] + DHA256.sigma0(W[62]) + W[47];
        int i = 0;
        while (i < 64) {
            int T1 = ((h << 19 | h >>> 13) ^ (h << 29 | h >>> 3) ^ h) + (f & g ^ g & h ^ f & h) + e + K[i] + W[i];
            int T2 = ((d << 11 | d >>> 21) ^ (d << 25 | d >>> 7) ^ d) + (~b & d ^ b & c) + a + K[i] + W[i];
            a = b;
            b = c << 17 | c >>> 15;
            c = d;
            d = T1;
            e = f;
            f = g << 2 | g >>> 30;
            g = h;
            h = T2;
            ++i;
        }
        this.H[0] = this.H[0] + a;
        this.H[1] = this.H[1] + b;
        this.H[2] = this.H[2] + c;
        this.H[3] = this.H[3] + d;
        this.H[4] = this.H[4] + e;
        this.H[5] = this.H[5] + f;
        this.H[6] = this.H[6] + g;
        this.H[7] = this.H[7] + h;
    }

    private void pad() {
        int i;
        long bitLength = this.count << 3;
        this.buffer[(int)this.count & 0x3F] = -128;
        ++this.count;
        if ((int)(this.count & 0x3FL) > 56) {
            i = (int)this.count & 0x3F;
            while (i < 64) {
                this.buffer[i] = 0;
                ++this.count;
                ++i;
            }
            this.processBlock();
        } else if ((int)(this.count & 0x3FL) == 0) {
            this.processBlock();
        }
        i = (int)this.count & 0x3F;
        while (i < 56) {
            this.buffer[i] = 0;
            ++i;
        }
        BigEndianConversions.I2OSP(bitLength, this.buffer, 56);
        this.processBlock();
    }

    private static int sigma0(int x) {
        return (x << 7 | x >>> 25) ^ (x << 22 | x >>> 10) ^ x;
    }

    private static int sigma1(int x) {
        return (x << 13 | x >>> 19) ^ (x << 27 | x >>> 5) ^ x;
    }
}

