/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.md;

import de.flexiprovider.api.MessageDigest;
import de.flexiprovider.common.util.BigEndianConversions;

public class FORK256
extends MessageDigest {
    private static final int[] H0 = new int[]{1779033703, -1150833019, 1013904242, -1521486534, 1359893119, -1694144372, 528734635, 1541459225};
    private static final int[] K = new int[]{1116352408, 1899447441, -1245643825, -373957723, 961987163, 1508970993, -1841331548, -1424204075, -670586216, 310598401, 607225278, 1426881987, 1925078388, -2132889090, -1680079193, -1046744716};
    private static final int FORK256_DIGEST_LENGTH = 32;
    private byte[] buffer;
    private long count;
    private int[] H = new int[8];
    private int a;
    private int b;
    private int c;
    private int d;
    private int e;
    private int f;
    private int g;
    private int h;

    public FORK256() {
        this.buffer = new byte[64];
        this.reset();
    }

    public int getDigestLength() {
        return 32;
    }

    public synchronized void update(byte[] input, int offset, int len) {
        int bufOffset = (int)this.count & 0x3F;
        while (len > 0) {
            int copyLen = 64 - bufOffset;
            copyLen = len > copyLen ? copyLen : len;
            System.arraycopy(input, offset, this.buffer, bufOffset, copyLen);
            len -= copyLen;
            offset += copyLen;
            this.count += (long)copyLen;
            bufOffset = bufOffset + copyLen & 0x3F;
            if (bufOffset != 0) continue;
            this.processBlock();
        }
    }

    public synchronized void update(byte input) {
        this.buffer[(int)this.count & 0x3F] = input;
        if ((int)(this.count & 0x3FL) == 63) {
            this.processBlock();
        }
        ++this.count;
    }

    public synchronized byte[] digest() {
        this.pad();
        byte[] digestValue = new byte[32];
        int i = 0;
        while (i < 8) {
            BigEndianConversions.I2OSP(this.H[i], digestValue, i << 2);
            ++i;
        }
        this.reset();
        return digestValue;
    }

    public void reset() {
        this.H[0] = H0[0];
        this.H[1] = H0[1];
        this.H[2] = H0[2];
        this.H[3] = H0[3];
        this.H[4] = H0[4];
        this.H[5] = H0[5];
        this.H[6] = H0[6];
        this.H[7] = H0[7];
        this.count = 0L;
    }

    private synchronized void processBlock() {
        int[] W = new int[16];
        int[] tmp1 = new int[8];
        int[] tmp2 = new int[8];
        int[] tmp3 = new int[8];
        int[] tmp4 = new int[8];
        W[0] = BigEndianConversions.OS2IP(this.buffer, 0);
        W[1] = BigEndianConversions.OS2IP(this.buffer, 4);
        W[2] = BigEndianConversions.OS2IP(this.buffer, 8);
        W[3] = BigEndianConversions.OS2IP(this.buffer, 12);
        W[4] = BigEndianConversions.OS2IP(this.buffer, 16);
        W[5] = BigEndianConversions.OS2IP(this.buffer, 20);
        W[6] = BigEndianConversions.OS2IP(this.buffer, 24);
        W[7] = BigEndianConversions.OS2IP(this.buffer, 28);
        W[8] = BigEndianConversions.OS2IP(this.buffer, 32);
        W[9] = BigEndianConversions.OS2IP(this.buffer, 36);
        W[10] = BigEndianConversions.OS2IP(this.buffer, 40);
        W[11] = BigEndianConversions.OS2IP(this.buffer, 44);
        W[12] = BigEndianConversions.OS2IP(this.buffer, 48);
        W[13] = BigEndianConversions.OS2IP(this.buffer, 52);
        W[14] = BigEndianConversions.OS2IP(this.buffer, 56);
        W[15] = BigEndianConversions.OS2IP(this.buffer, 60);
        this.a = this.H[0];
        this.b = this.H[1];
        this.c = this.H[2];
        this.d = this.H[3];
        this.e = this.H[4];
        this.f = this.H[5];
        this.g = this.H[6];
        this.h = this.H[7];
        this.STEP(W[0], W[1], K[0], K[1]);
        this.STEP(W[2], W[3], K[2], K[3]);
        this.STEP(W[4], W[5], K[4], K[5]);
        this.STEP(W[6], W[7], K[6], K[7]);
        this.STEP(W[8], W[9], K[8], K[9]);
        this.STEP(W[10], W[11], K[10], K[11]);
        this.STEP(W[12], W[13], K[12], K[13]);
        this.STEP(W[14], W[15], K[14], K[15]);
        tmp1[0] = this.a;
        tmp1[1] = this.b;
        tmp1[2] = this.c;
        tmp1[3] = this.d;
        tmp1[4] = this.e;
        tmp1[5] = this.f;
        tmp1[6] = this.g;
        tmp1[7] = this.h;
        this.a = this.H[0];
        this.b = this.H[1];
        this.c = this.H[2];
        this.d = this.H[3];
        this.e = this.H[4];
        this.f = this.H[5];
        this.g = this.H[6];
        this.h = this.H[7];
        this.STEP(W[14], W[15], K[15], K[14]);
        this.STEP(W[11], W[9], K[13], K[12]);
        this.STEP(W[8], W[10], K[11], K[10]);
        this.STEP(W[3], W[4], K[9], K[8]);
        this.STEP(W[2], W[13], K[7], K[6]);
        this.STEP(W[0], W[5], K[5], K[4]);
        this.STEP(W[6], W[7], K[3], K[2]);
        this.STEP(W[12], W[1], K[1], K[0]);
        tmp2[0] = this.a;
        tmp2[1] = this.b;
        tmp2[2] = this.c;
        tmp2[3] = this.d;
        tmp2[4] = this.e;
        tmp2[5] = this.f;
        tmp2[6] = this.g;
        tmp2[7] = this.h;
        this.a = this.H[0];
        this.b = this.H[1];
        this.c = this.H[2];
        this.d = this.H[3];
        this.e = this.H[4];
        this.f = this.H[5];
        this.g = this.H[6];
        this.h = this.H[7];
        this.STEP(W[7], W[6], K[1], K[0]);
        this.STEP(W[10], W[14], K[3], K[2]);
        this.STEP(W[13], W[2], K[5], K[4]);
        this.STEP(W[9], W[12], K[7], K[6]);
        this.STEP(W[11], W[4], K[9], K[8]);
        this.STEP(W[15], W[8], K[11], K[10]);
        this.STEP(W[5], W[0], K[13], K[12]);
        this.STEP(W[1], W[3], K[15], K[14]);
        tmp3[0] = this.a;
        tmp3[1] = this.b;
        tmp3[2] = this.c;
        tmp3[3] = this.d;
        tmp3[4] = this.e;
        tmp3[5] = this.f;
        tmp3[6] = this.g;
        tmp3[7] = this.h;
        this.a = this.H[0];
        this.b = this.H[1];
        this.c = this.H[2];
        this.d = this.H[3];
        this.e = this.H[4];
        this.f = this.H[5];
        this.g = this.H[6];
        this.h = this.H[7];
        this.STEP(W[5], W[12], K[14], K[15]);
        this.STEP(W[1], W[8], K[12], K[13]);
        this.STEP(W[15], W[0], K[10], K[11]);
        this.STEP(W[13], W[11], K[8], K[9]);
        this.STEP(W[3], W[10], K[6], K[7]);
        this.STEP(W[9], W[2], K[4], K[5]);
        this.STEP(W[7], W[14], K[2], K[3]);
        this.STEP(W[4], W[6], K[0], K[1]);
        tmp4[0] = this.a;
        tmp4[1] = this.b;
        tmp4[2] = this.c;
        tmp4[3] = this.d;
        tmp4[4] = this.e;
        tmp4[5] = this.f;
        tmp4[6] = this.g;
        tmp4[7] = this.h;
        int i = 0;
        while (i <= 7) {
            int n = i;
            this.H[n] = this.H[n] + (tmp1[i] + tmp2[i] ^ tmp3[i] + tmp4[i]);
            ++i;
        }
    }

    private void pad() {
        int i;
        long bitLength = this.count << 3;
        this.buffer[(int)this.count & 0x3F] = -128;
        ++this.count;
        if ((int)(this.count & 0x3FL) > 56) {
            i = (int)this.count & 0x3F;
            while (i < 64) {
                this.buffer[i] = 0;
                ++this.count;
                ++i;
            }
            this.processBlock();
        } else if ((int)(this.count & 0x3FL) == 0) {
            this.processBlock();
        }
        i = (int)this.count & 0x3F;
        while (i < 56) {
            this.buffer[i] = 0;
            ++i;
        }
        BigEndianConversions.I2OSP(bitLength, this.buffer, 56);
        this.processBlock();
    }

    private void STEP(int m1, int m2, int d1, int d2) {
        int t1 = FORK256.G(this.e + m2);
        int t2 = FORK256.F(this.e + m2 + d2);
        int t3 = FORK256.F(this.a + m1);
        int t4 = FORK256.G(this.a + m1 + d1);
        int tmp = this.h + (t1 << 21 | t1 >>> 11) ^ (t2 << 17 | t2 >>> 15);
        this.h = this.g + (t1 << 9 | t1 >>> 23) ^ (t2 << 5 | t2 >>> 27);
        this.g = this.f + (t1 | t1 >>> 32) ^ (t2 | t2 >>> 32);
        this.f = this.e + m2 + d2;
        this.e = this.d + (t3 << 17 | t3 >>> 15) ^ (t4 << 21 | t4 >>> 11);
        this.d = this.c + (t3 << 5 | t3 >>> 27) ^ (t4 << 9 | t4 >>> 23);
        this.c = this.b + (t3 | t3 >>> 32) ^ (t4 | t4 >>> 32);
        this.b = this.a + m1 + d1;
        this.a = tmp;
    }

    private static int F(int x) {
        return x + ((x << 7 | x >>> 25) ^ (x << 22 | x >>> 10));
    }

    private static int G(int x) {
        return x ^ (x << 13 | x >>> 19) + (x << 27 | x >>> 5);
    }
}

