/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.md;

import de.flexiprovider.api.MessageDigest;
import de.flexiprovider.common.util.LittleEndianConversions;

public abstract class MDFamilyDigest
extends MessageDigest {
    private int digestLength;
    private byte[] buffer = new byte[64];
    private int count;
    protected int[] x = new int[16];
    protected int[] state = null;

    protected MDFamilyDigest(int digestLength) {
        this.digestLength = digestLength;
        this.reset();
    }

    protected void initMessageDigest(int[] initialState) {
        if (this.state == null) {
            this.state = new int[initialState.length];
        }
        System.arraycopy(initialState, 0, this.state, 0, initialState.length);
        this.count = 0;
    }

    public int getDigestLength() {
        return this.digestLength;
    }

    public synchronized void update(byte b) {
        this.buffer[this.count & 0x3F] = b;
        if ((this.count & 0x3F) == 63) {
            int i = 15;
            while (i >= 0) {
                this.x[i] = LittleEndianConversions.OS2IP(this.buffer, 4 * i);
                --i;
            }
            this.processBlock();
        }
        ++this.count;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void update(byte[] bytes, int offset, int len) {
        while (len > 0 & (this.count & 63) != 0) {
            this.update(bytes[offset++]);
            --len;
        }
        if (len != 0) ** GOTO lbl16
        return;
lbl-1000:
        // 1 sources

        {
            i = 0;
            while (i <= 15) {
                this.x[i] = LittleEndianConversions.OS2IP(bytes, offset);
                offset += 4;
                ++i;
            }
            this.count += 64;
            len -= 64;
            this.processBlock();
lbl16:
            // 2 sources

            ** while (len >= 64)
        }
lbl17:
        // 1 sources

        if (len > 0) {
            System.arraycopy(bytes, offset, this.buffer, 0, len);
            this.count += len;
        }
    }

    protected void padMessageDigest() {
        long len = this.count << 3;
        this.update((byte)-128);
        while ((this.count & 0x3F) != 56) {
            this.update((byte)0);
        }
        int i = 0;
        while (i < 14) {
            this.x[i] = LittleEndianConversions.OS2IP(this.buffer, 4 * i);
            ++i;
        }
        this.x[14] = (int)(len & 0xFFFFFFFFFFFFFFFFL);
        this.x[15] = (int)(len >>> 32 & 0xFFFFFFFFFFFFFFFFL);
        this.processBlock();
    }

    protected abstract void processBlock();

    protected static int rotateLeft(int x, int n) {
        return x << n | x >>> 32 - n;
    }
}

