/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.md;

import de.flexiprovider.common.util.LittleEndianConversions;
import de.flexiprovider.core.md.MDFamilyDigest;

public final class RIPEMD128
extends MDFamilyDigest {
    public static final String OID = "1.3.36.3.2.2";
    private static final int[] initState = new int[]{1732584193, -271733879, -1732584194, 271733878};
    private static final int RIPEMD128_DIGEST_LENGTH = 16;
    private static final int[] Zl = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 7, 4, 13, 1, 10, 6, 15, 3, 12, 0, 9, 5, 2, 14, 11, 8, 3, 10, 14, 4, 9, 15, 8, 1, 2, 7, 0, 6, 13, 11, 5, 12, 1, 9, 11, 10, 0, 8, 12, 4, 13, 3, 7, 15, 14, 5, 6, 2};
    private static final int[] Zr = new int[]{5, 14, 7, 0, 9, 2, 11, 4, 13, 6, 15, 8, 1, 10, 3, 12, 6, 11, 3, 7, 0, 13, 5, 10, 14, 15, 8, 12, 4, 9, 1, 2, 15, 5, 1, 3, 7, 14, 6, 9, 11, 8, 12, 2, 10, 0, 4, 13, 8, 6, 4, 1, 3, 11, 15, 0, 5, 12, 2, 13, 9, 7, 10, 14};
    private static final int[] Sl = new int[]{11, 14, 15, 12, 5, 8, 7, 9, 11, 13, 14, 15, 6, 7, 9, 8, 7, 6, 8, 13, 11, 9, 7, 15, 7, 12, 15, 9, 11, 7, 13, 12, 11, 13, 6, 7, 14, 9, 13, 15, 14, 8, 13, 6, 5, 12, 7, 5, 11, 12, 14, 15, 14, 15, 9, 8, 9, 14, 5, 6, 8, 6, 5, 12};
    private static final int[] Sr = new int[]{8, 9, 9, 11, 13, 15, 15, 5, 7, 7, 8, 11, 14, 14, 12, 6, 9, 13, 15, 7, 12, 8, 9, 11, 7, 7, 12, 7, 6, 15, 13, 11, 9, 7, 15, 11, 8, 6, 6, 14, 12, 13, 5, 14, 13, 13, 7, 5, 15, 5, 8, 11, 14, 14, 6, 14, 6, 9, 12, 9, 12, 5, 15, 8};

    public RIPEMD128() {
        super(16);
    }

    public void reset() {
        this.initMessageDigest(initState);
    }

    public synchronized byte[] digest() {
        byte[] digest = new byte[16];
        this.padMessageDigest();
        LittleEndianConversions.I2OSP(this.state[0], digest, 0);
        LittleEndianConversions.I2OSP(this.state[1], digest, 4);
        LittleEndianConversions.I2OSP(this.state[2], digest, 8);
        LittleEndianConversions.I2OSP(this.state[3], digest, 12);
        this.reset();
        return digest;
    }

    protected synchronized void processBlock() {
        int Al = this.state[0];
        int Bl = this.state[1];
        int Cl = this.state[2];
        int Dl = this.state[3];
        int Ar = this.state[0];
        int Br = this.state[1];
        int Cr = this.state[2];
        int Dr = this.state[3];
        int t = 0;
        int j = 0;
        j = 0;
        while (j < 16) {
            t = Al + RIPEMD128.F(Bl, Cl, Dl) + this.x[Zl[j]];
            Al = Dl;
            Dl = Cl;
            Cl = Bl;
            Bl = MDFamilyDigest.rotateLeft(t, Sl[j]);
            t = Ar + RIPEMD128.K(Br, Cr, Dr) + this.x[Zr[j]] + 1352829926;
            Ar = Dr;
            Dr = Cr;
            Cr = Br;
            Br = MDFamilyDigest.rotateLeft(t, Sr[j]);
            ++j;
        }
        j = 16;
        while (j < 32) {
            t = Al + RIPEMD128.G(Bl, Cl, Dl) + this.x[Zl[j]] + 1518500249;
            Al = Dl;
            Dl = Cl;
            Cl = Bl;
            Bl = MDFamilyDigest.rotateLeft(t, Sl[j]);
            t = Ar + RIPEMD128.H(Br, Cr, Dr) + this.x[Zr[j]] + 1548603684;
            Ar = Dr;
            Dr = Cr;
            Cr = Br;
            Br = MDFamilyDigest.rotateLeft(t, Sr[j]);
            ++j;
        }
        j = 32;
        while (j < 48) {
            t = Al + RIPEMD128.H(Bl, Cl, Dl) + this.x[Zl[j]] + 1859775393;
            Al = Dl;
            Dl = Cl;
            Cl = Bl;
            Bl = MDFamilyDigest.rotateLeft(t, Sl[j]);
            t = Ar + RIPEMD128.G(Br, Cr, Dr) + this.x[Zr[j]] + 1836072691;
            Ar = Dr;
            Dr = Cr;
            Cr = Br;
            Br = MDFamilyDigest.rotateLeft(t, Sr[j]);
            ++j;
        }
        j = 48;
        while (j < 64) {
            t = Al + RIPEMD128.K(Bl, Cl, Dl) + this.x[Zl[j]] + -1894007588;
            Al = Dl;
            Dl = Cl;
            Cl = Bl;
            Bl = MDFamilyDigest.rotateLeft(t, Sl[j]);
            t = Ar + RIPEMD128.F(Br, Cr, Dr) + this.x[Zr[j]];
            Ar = Dr;
            Dr = Cr;
            Cr = Br;
            Br = MDFamilyDigest.rotateLeft(t, Sr[j]);
            ++j;
        }
        this.state[1] = this.state[2] + Dl + Ar;
        this.state[2] = this.state[3] + Al + Br;
        this.state[3] = this.state[0] + Bl + Cr;
        this.state[0] = Cl += this.state[1] + Dr;
    }

    private static int F(int u, int v, int w) {
        return u ^ v ^ w;
    }

    private static int G(int u, int v, int w) {
        return u & v | ~u & w;
    }

    private static int H(int u, int v, int w) {
        return (u | ~v) ^ w;
    }

    private static int K(int u, int v, int w) {
        return u & w | v & ~w;
    }
}

