/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.md;

import de.flexiprovider.api.MessageDigest;
import de.flexiprovider.common.util.BigEndianConversions;

public abstract class SHA224_256
extends MessageDigest {
    private static final int[] K = new int[]{1116352408, 1899447441, -1245643825, -373957723, 961987163, 1508970993, -1841331548, -1424204075, -670586216, 310598401, 607225278, 1426881987, 1925078388, -2132889090, -1680079193, -1046744716, -459576895, -272742522, 264347078, 604807628, 770255983, 1249150122, 1555081692, 1996064986, -1740746414, -1473132947, -1341970488, -1084653625, -958395405, -710438585, 113926993, 338241895, 666307205, 773529912, 1294757372, 1396182291, 1695183700, 1986661051, -2117940946, -1838011259, -1564481375, -1474664885, -1035236496, -949202525, -778901479, -694614492, -200395387, 275423344, 430227734, 506948616, 659060556, 883997877, 958139571, 1322822218, 1537002063, 1747873779, 1955562222, 2024104815, -2067236844, -1933114872, -1866530822, -1538233109, -1090935817, -965641998};
    private int[] W;
    private int[] H = new int[8];
    private byte[] buffer;
    private long count;
    private int digestLength;

    protected SHA224_256(int digestLength) {
        this.W = new int[64];
        this.buffer = new byte[64];
        this.digestLength = digestLength;
        this.reset();
    }

    protected void initMessageDigest(int[] initialState) {
        this.count = 0L;
        System.arraycopy(initialState, 0, this.H, 0, initialState.length);
    }

    private static int s0(int x) {
        return (x >>> 7 | x << 25) ^ (x >>> 18 | x << 14) ^ x >>> 3;
    }

    private static int s1(int x) {
        return (x >>> 17 | x << 15) ^ (x >>> 19 | x << 13) ^ x >>> 10;
    }

    private void processBlock() {
        int a = this.H[0];
        int b = this.H[1];
        int c = this.H[2];
        int d = this.H[3];
        int e = this.H[4];
        int f = this.H[5];
        int g = this.H[6];
        int h = this.H[7];
        int i = 0;
        while (i < 64) {
            int i2 = i << 2;
            this.W[i] = i < 16 ? (this.buffer[i2] & 0xFF) << 24 | (this.buffer[++i2] & 0xFF) << 16 | (this.buffer[++i2] & 0xFF) << 8 | this.buffer[++i2] & 0xFF : SHA224_256.s1(this.W[i - 2]) + this.W[i - 7] + SHA224_256.s0(this.W[i - 15]) + this.W[i - 16];
            int T1 = ((e >>> 6 | e << 26) ^ (e >>> 11 | e << 21) ^ (e >>> 25 | e << 7)) + (e & f ^ ~e & g) + h + K[i] + this.W[i];
            int T2 = ((a >>> 2 | a << 30) ^ (a >>> 13 | a << 19) ^ (a >>> 22 | a << 10)) + (a & b ^ a & c ^ b & c);
            h = g;
            g = f;
            f = e;
            e = d + T1;
            d = c;
            c = b;
            b = a;
            a = T1 + T2;
            ++i;
        }
        this.H[0] = this.H[0] + a;
        this.H[1] = this.H[1] + b;
        this.H[2] = this.H[2] + c;
        this.H[3] = this.H[3] + d;
        this.H[4] = this.H[4] + e;
        this.H[5] = this.H[5] + f;
        this.H[6] = this.H[6] + g;
        this.H[7] = this.H[7] + h;
    }

    private void pad() {
        int i;
        long bitLength = this.count << 3;
        this.buffer[(int)this.count & 0x3F] = -128;
        ++this.count;
        if ((int)(this.count & 0x3FL) > 56) {
            i = (int)this.count & 0x3F;
            while (i < 64) {
                this.buffer[i] = 0;
                ++this.count;
                ++i;
            }
            this.processBlock();
        } else if ((int)(this.count & 0x3FL) == 0) {
            this.processBlock();
        }
        i = (int)this.count & 0x3F;
        while (i < 56) {
            this.buffer[i] = 0;
            ++i;
        }
        BigEndianConversions.I2OSP(bitLength, this.buffer, 56);
        this.processBlock();
    }

    public int getDigestLength() {
        return this.digestLength;
    }

    public synchronized void update(byte input) {
        this.buffer[(int)this.count & 0x3F] = input;
        if ((int)(this.count & 0x3FL) == 63) {
            this.processBlock();
        }
        ++this.count;
    }

    public synchronized void update(byte[] input, int inOff, int inLen) {
        int bufOff = (int)this.count & 0x3F;
        while (inLen > 0) {
            int copyLen = 64 - bufOff;
            copyLen = inLen > copyLen ? copyLen : inLen;
            System.arraycopy(input, inOff, this.buffer, bufOff, copyLen);
            inLen -= copyLen;
            inOff += copyLen;
            this.count += (long)copyLen;
            bufOff = bufOff + copyLen & 0x3F;
            if (bufOff != 0) continue;
            this.processBlock();
        }
    }

    public synchronized byte[] digest() {
        this.pad();
        byte[] digestValue = new byte[this.digestLength];
        int i = this.digestLength >> 2;
        while (--i >= 0) {
            BigEndianConversions.I2OSP(this.H[i], digestValue, i << 2);
        }
        this.reset();
        return digestValue;
    }
}

