/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.mersa;

import codec.CorruptedCodeException;
import codec.asn1.ASN1Integer;
import codec.asn1.ASN1Sequence;
import codec.asn1.ASN1Type;
import codec.pkcs8.PrivateKeyInfo;
import codec.x509.SubjectPublicKeyInfo;
import de.flexiprovider.api.exceptions.InvalidKeyException;
import de.flexiprovider.api.exceptions.InvalidKeySpecException;
import de.flexiprovider.api.keys.Key;
import de.flexiprovider.api.keys.KeyFactory;
import de.flexiprovider.api.keys.KeySpec;
import de.flexiprovider.api.keys.PrivateKey;
import de.flexiprovider.api.keys.PublicKey;
import de.flexiprovider.common.math.FlexiBigInt;
import de.flexiprovider.common.util.ASN1Tools;
import de.flexiprovider.core.mersa.MeRSAPrivateKey;
import de.flexiprovider.core.mersa.MeRSAPrivateKeySpec;
import de.flexiprovider.core.rsa.RSAPublicKey;
import de.flexiprovider.core.rsa.RSAPublicKeySpec;
import de.flexiprovider.pki.PKCS8EncodedKeySpec;
import de.flexiprovider.pki.X509EncodedKeySpec;

public class MeRSAKeyFactory
extends KeyFactory {
    static /* synthetic */ Class class$de$flexiprovider$pki$X509EncodedKeySpec;
    static /* synthetic */ Class class$de$flexiprovider$core$rsa$RSAPublicKeySpec;
    static /* synthetic */ Class class$de$flexiprovider$pki$PKCS8EncodedKeySpec;
    static /* synthetic */ Class class$de$flexiprovider$core$mersa$MeRSAPrivateKeySpec;

    public PrivateKey generatePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof MeRSAPrivateKeySpec) {
            return new MeRSAPrivateKey((MeRSAPrivateKeySpec)keySpec);
        }
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            byte[] encKey = ((PKCS8EncodedKeySpec)keySpec).getEncoded();
            PrivateKeyInfo pki = new PrivateKeyInfo();
            try {
                ASN1Tools.derDecode(encKey, (ASN1Type)pki);
            }
            catch (Exception ce) {
                throw new InvalidKeySpecException("Unable to decode PKCS8EncodedKeySpec.");
            }
            try {
                ASN1Sequence encPrivKey = (ASN1Sequence)pki.getDecodedRawKey();
                if (encPrivKey.size() == 11) {
                    FlexiBigInt modulus = ASN1Tools.getFlexiBigInt((ASN1Integer)encPrivKey.get(1));
                    FlexiBigInt publicExponent = ASN1Tools.getFlexiBigInt((ASN1Integer)encPrivKey.get(2));
                    FlexiBigInt exponentK = ASN1Tools.getFlexiBigInt((ASN1Integer)encPrivKey.get(3));
                    FlexiBigInt privateExponent = ASN1Tools.getFlexiBigInt((ASN1Integer)encPrivKey.get(4));
                    FlexiBigInt primeP = ASN1Tools.getFlexiBigInt((ASN1Integer)encPrivKey.get(5));
                    FlexiBigInt primeQ = ASN1Tools.getFlexiBigInt((ASN1Integer)encPrivKey.get(6));
                    FlexiBigInt exponentP = ASN1Tools.getFlexiBigInt((ASN1Integer)encPrivKey.get(7));
                    FlexiBigInt exponentQ = ASN1Tools.getFlexiBigInt((ASN1Integer)encPrivKey.get(8));
                    FlexiBigInt e_inv_p = ASN1Tools.getFlexiBigInt((ASN1Integer)encPrivKey.get(9));
                    FlexiBigInt crtCoefficient = ASN1Tools.getFlexiBigInt((ASN1Integer)encPrivKey.get(10));
                    return new MeRSAPrivateKey(modulus, publicExponent, privateExponent, primeP, primeQ, exponentP, exponentQ, crtCoefficient, exponentK, e_inv_p);
                }
            }
            catch (CorruptedCodeException cce) {
                throw new InvalidKeySpecException("Unable to decode PKCS8EncodedKeySpec.");
            }
        }
        throw new InvalidKeySpecException("MeRSAKeyFactory: Unknown KeySpec type.");
    }

    public PublicKey generatePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof RSAPublicKeySpec) {
            return new RSAPublicKey((RSAPublicKeySpec)keySpec);
        }
        if (keySpec instanceof X509EncodedKeySpec) {
            byte[] enc = ((X509EncodedKeySpec)keySpec).getEncoded();
            SubjectPublicKeyInfo spki = new SubjectPublicKeyInfo();
            try {
                ASN1Tools.derDecode(enc, (ASN1Type)spki);
            }
            catch (Exception ce) {
                throw new InvalidKeySpecException("Unable to decode X509EncodedKeySpec.");
            }
            try {
                ASN1Sequence encPubKey = (ASN1Sequence)spki.getDecodedRawKey();
                if (encPubKey.size() == 2) {
                    FlexiBigInt modulus = ASN1Tools.getFlexiBigInt((ASN1Integer)encPubKey.get(0));
                    FlexiBigInt publicExponent = ASN1Tools.getFlexiBigInt((ASN1Integer)encPubKey.get(1));
                    return new RSAPublicKey(modulus, publicExponent);
                }
            }
            catch (CorruptedCodeException cce) {
                throw new InvalidKeySpecException("Unable to decode X509EncodedKeySpec.");
            }
        }
        throw new InvalidKeySpecException("RSAKeyFactory: Unknown KeySpec type.");
    }

    public KeySpec getKeySpec(Key key, Class keySpec) throws InvalidKeySpecException {
        if (key instanceof RSAPublicKey) {
            if ((class$de$flexiprovider$pki$X509EncodedKeySpec == null ? (class$de$flexiprovider$pki$X509EncodedKeySpec = MeRSAKeyFactory.class$("de.flexiprovider.pki.X509EncodedKeySpec")) : class$de$flexiprovider$pki$X509EncodedKeySpec).isAssignableFrom(keySpec)) {
                return new X509EncodedKeySpec(key.getEncoded());
            }
            if ((class$de$flexiprovider$core$rsa$RSAPublicKeySpec == null ? (class$de$flexiprovider$core$rsa$RSAPublicKeySpec = MeRSAKeyFactory.class$("de.flexiprovider.core.rsa.RSAPublicKeySpec")) : class$de$flexiprovider$core$rsa$RSAPublicKeySpec).isAssignableFrom(keySpec)) {
                RSAPublicKey rsaPublicKey = (RSAPublicKey)key;
                return new RSAPublicKeySpec(rsaPublicKey.getN(), rsaPublicKey.getE());
            }
        } else if (key instanceof MeRSAPrivateKey) {
            if ((class$de$flexiprovider$pki$PKCS8EncodedKeySpec == null ? (class$de$flexiprovider$pki$PKCS8EncodedKeySpec = MeRSAKeyFactory.class$("de.flexiprovider.pki.PKCS8EncodedKeySpec")) : class$de$flexiprovider$pki$PKCS8EncodedKeySpec).isAssignableFrom(keySpec)) {
                return new PKCS8EncodedKeySpec(key.getEncoded());
            }
            MeRSAPrivateKey rsaPrivCrtKey = (MeRSAPrivateKey)key;
            if ((class$de$flexiprovider$core$mersa$MeRSAPrivateKeySpec == null ? (class$de$flexiprovider$core$mersa$MeRSAPrivateKeySpec = MeRSAKeyFactory.class$("de.flexiprovider.core.mersa.MeRSAPrivateKeySpec")) : class$de$flexiprovider$core$mersa$MeRSAPrivateKeySpec).isAssignableFrom(keySpec)) {
                return new MeRSAPrivateKeySpec(rsaPrivCrtKey.getN(), rsaPrivCrtKey.getE(), rsaPrivCrtKey.getD(), rsaPrivCrtKey.getP(), rsaPrivCrtKey.getQ(), rsaPrivCrtKey.getDp(), rsaPrivCrtKey.getDq(), rsaPrivCrtKey.getCRTCoeff(), rsaPrivCrtKey.getK(), rsaPrivCrtKey.getEInvP());
            }
        } else {
            throw new InvalidKeySpecException("Unsupported key type: " + key.getClass() + ".");
        }
        throw new InvalidKeySpecException("Unknown key specification: " + keySpec + ".");
    }

    public Key translateKey(Key key) throws InvalidKeyException {
        if (key instanceof MeRSAPrivateKey) {
            if (key instanceof MeRSAPrivateKey) {
                return key;
            }
            MeRSAPrivateKey rsaKey = (MeRSAPrivateKey)key;
            return new MeRSAPrivateKey(rsaKey.getN(), rsaKey.getE(), rsaKey.getD(), rsaKey.getP(), rsaKey.getQ(), rsaKey.getDp(), rsaKey.getDq(), rsaKey.getCRTCoeff(), rsaKey.getK(), rsaKey.getEInvP());
        }
        if (key instanceof RSAPublicKey) {
            if (key instanceof RSAPublicKey) {
                return key;
            }
            RSAPublicKey rsaKey = (RSAPublicKey)key;
            return new RSAPublicKey(rsaKey.getN(), rsaKey.getE());
        }
        throw new InvalidKeyException("Unsupported key type.");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

