/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.mersa;

import codec.asn1.ASN1Integer;
import codec.asn1.ASN1Null;
import codec.asn1.ASN1ObjectIdentifier;
import codec.asn1.ASN1Sequence;
import codec.asn1.ASN1Type;
import de.flexiprovider.common.math.FlexiBigInt;
import de.flexiprovider.common.util.ASN1Tools;
import de.flexiprovider.core.mersa.MeRSAPrivateKeySpec;
import de.flexiprovider.core.rsa.RSAPrivateCrtKey;

public class MeRSAPrivateKey
extends RSAPrivateCrtKey {
    private FlexiBigInt k;
    private FlexiBigInt eInvP;

    protected MeRSAPrivateKey(FlexiBigInt n, FlexiBigInt e, FlexiBigInt d, FlexiBigInt p, FlexiBigInt q, FlexiBigInt dP, FlexiBigInt dQ, FlexiBigInt crtCoeff, FlexiBigInt k, FlexiBigInt eInvP) {
        super(n, e, d, p, q, dP, dQ, crtCoeff);
        this.eInvP = eInvP;
        this.crtCoeff = crtCoeff;
    }

    protected MeRSAPrivateKey(MeRSAPrivateKeySpec keySpec) {
        this(keySpec.getN(), keySpec.getE(), keySpec.getD(), keySpec.getP(), keySpec.getQ(), keySpec.getDp(), keySpec.getDq(), keySpec.getCRTCoeff(), keySpec.getK(), keySpec.getEInvP());
    }

    public FlexiBigInt getK() {
        return this.k;
    }

    public FlexiBigInt getEInvP() {
        return this.eInvP;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof MeRSAPrivateKey)) {
            return false;
        }
        MeRSAPrivateKey otherKey = (MeRSAPrivateKey)other;
        return this.n.equals(otherKey.n) && this.p.equals(otherKey.p) && this.q.equals(otherKey.q) && this.d.equals(otherKey.d) && this.e.equals(otherKey.e) && this.dP.equals(otherKey.dP) && this.dQ.equals(otherKey.dQ) && this.k.equals(otherKey.k) && this.eInvP.equals(otherKey.eInvP) && this.crtCoeff.equals(otherKey.crtCoeff);
    }

    public String toString() {
        String out = "";
        out = out + "modulus n:            0x" + this.n.toString(16) + "\n";
        out = out + "public exponent e:    0x" + this.e.toString(16) + "\n";
        out = out + "exponent k:           0x" + this.k.toString(16) + "\n";
        out = out + "private exponent d:   0x" + this.d.toString(16) + "\n";
        out = out + "prime P:              0x" + this.p.toString(16) + "\n";
        out = out + "prime Q:              0x" + this.q.toString(16) + "\n";
        out = out + "prime exponent P:     0x" + this.dP.toString(16) + "\n";
        out = out + "prime exponent Q:     0x" + this.dQ.toString(16) + "\n";
        out = out + "inverse of e mod p:   0x" + this.dQ.toString(16) + "\n";
        out = out + "crt coefficient:      0x" + this.crtCoeff.toString(16) + "\n";
        return out;
    }

    public int hashCode() {
        return this.n.hashCode() + this.e.hashCode() + this.k.hashCode() + this.d.hashCode() + this.p.hashCode() + this.q.hashCode() + this.dP.hashCode() + this.dQ.hashCode() + this.eInvP.hashCode() + this.crtCoeff.hashCode();
    }

    protected ASN1ObjectIdentifier getOID() {
        return new ASN1ObjectIdentifier();
    }

    protected ASN1Type getAlgParams() {
        return new ASN1Null();
    }

    protected byte[] getKeyData() {
        ASN1Sequence keyData = new ASN1Sequence();
        keyData.add(new ASN1Integer(0));
        keyData.add(ASN1Tools.createInteger(this.n));
        keyData.add(ASN1Tools.createInteger(this.e));
        keyData.add(ASN1Tools.createInteger(this.k));
        keyData.add(ASN1Tools.createInteger(this.d));
        keyData.add(ASN1Tools.createInteger(this.p));
        keyData.add(ASN1Tools.createInteger(this.q));
        keyData.add(ASN1Tools.createInteger(this.dP));
        keyData.add(ASN1Tools.createInteger(this.dQ));
        keyData.add(ASN1Tools.createInteger(this.eInvP));
        keyData.add(ASN1Tools.createInteger(this.crtCoeff));
        return ASN1Tools.derEncode((ASN1Type)keyData);
    }
}

