/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.misty1;

import de.flexiprovider.api.Registry;
import de.flexiprovider.api.SecureRandom;
import de.flexiprovider.api.keys.SecretKey;
import de.flexiprovider.api.keys.SecretKeyGenerator;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.core.misty1.Misty1Key;

public class Misty1KeyGenerator
extends SecretKeyGenerator {
    public static final int MISTY1_KEY_SIZE = 16;
    private SecureRandom random;
    private boolean initialized;

    public void init(AlgorithmParameterSpec params, SecureRandom random) {
        this.init(random);
    }

    public void init(int strength, SecureRandom random) {
        this.init(random);
    }

    public void init(SecureRandom random) {
        this.random = random != null ? random : Registry.getSecureRandom();
        this.initialized = true;
    }

    public SecretKey generateKey() {
        if (!this.initialized) {
            this.init(Registry.getSecureRandom());
        }
        byte[] bytes = new byte[16];
        this.random.nextBytes(bytes);
        return new Misty1Key(bytes);
    }
}

