/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.mprsa;

import de.flexiprovider.api.AsymmetricBlockCipher;
import de.flexiprovider.api.MessageDigest;
import de.flexiprovider.api.Registry;
import de.flexiprovider.api.SecureRandom;
import de.flexiprovider.api.exceptions.InvalidKeyException;
import de.flexiprovider.api.exceptions.InvalidParameterException;
import de.flexiprovider.api.exceptions.InvalidParameterSpecException;
import de.flexiprovider.api.exceptions.NoSuchAlgorithmException;
import de.flexiprovider.api.keys.Key;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.api.parameters.AlgorithmParameters;
import de.flexiprovider.common.math.FlexiBigInt;
import de.flexiprovider.core.mprsa.MpRSAOperations;
import de.flexiprovider.core.mprsa.MpRSAPrivateKey;
import de.flexiprovider.core.rsa.PKCS1Exception;
import de.flexiprovider.core.rsa.PKCS1Operations;
import de.flexiprovider.core.rsa.RSAOAEPParameterSpec;
import de.flexiprovider.core.rsa.RSAOAEPParameters;
import de.flexiprovider.core.rsa.interfaces.RSAPublicKey;
import java.io.IOException;

public class MpRSA
extends AsymmetricBlockCipher {
    private SecureRandom sr;
    private RSAPublicKey pubKey;
    private MpRSAPrivateKey privKey;
    private MessageDigest md;

    public final String getName() {
        return "MeRSA";
    }

    public int getKeySize(Key key) throws InvalidKeyException {
        if (key instanceof MpRSAPrivateKey) {
            return ((MpRSAPrivateKey)key).getN().bitLength();
        }
        if (key instanceof RSAPublicKey) {
            return ((RSAPublicKey)key).getN().bitLength();
        }
        throw new InvalidKeyException("MpRSA: engineGetKeySize() - the key is not suitable for RSA the algorithm!");
    }

    protected void initCipherEncrypt(Key key, AlgorithmParameterSpec params, SecureRandom secureRandom) throws InvalidKeyException {
        if (!(key instanceof RSAPublicKey)) {
            throw new InvalidKeyException("MpRSA: initEncrypt - RSASSA-OAEP needs an RSAPublicKey for encrypting data.");
        }
        if (params == null) {
            this.initParams(new RSAOAEPParameterSpec());
        } else if (params instanceof RSAOAEPParameterSpec) {
            this.initParams((RSAOAEPParameterSpec)params);
        } else {
            throw new InvalidParameterException("MpRSA: initEncrypt - Invalid parameter specifaction!");
        }
        this.pubKey = (RSAPublicKey)key;
        this.privKey = null;
        this.sr = secureRandom;
        this.cipherTextSize = this.pubKey.getN().bitLength() + 7 >> 3;
        this.maxPlainTextSize = this.cipherTextSize - (this.md.getDigestLength() << 1) - 2;
        if (this.maxPlainTextSize <= 0) {
            throw new InvalidParameterException("MpRSA: initEncrypt - Please use larger modulus!");
        }
    }

    protected void initCipherDecrypt(Key key, AlgorithmParameterSpec params) throws InvalidKeyException {
        if (params == null) {
            this.initParams(new RSAOAEPParameterSpec());
        } else if (params instanceof RSAOAEPParameterSpec) {
            this.initParams((RSAOAEPParameterSpec)params);
        } else {
            throw new InvalidParameterException("MpRSA: initDecrypt - Invalid parameter specifaction!");
        }
        if (!(key instanceof MpRSAPrivateKey)) {
            throw new InvalidKeyException("MpRSA: initDecrypt - RSASSA-OAEP needs a RSAPublicKey for encrypting data.");
        }
        this.privKey = (MpRSAPrivateKey)key;
        this.pubKey = null;
        this.sr = Registry.getSecureRandom();
        this.cipherTextSize = this.privKey.getN().bitLength() + 7 >> 3;
        this.maxPlainTextSize = this.cipherTextSize - (this.md.getDigestLength() << 1) - 2;
        if (this.maxPlainTextSize <= 0) {
            throw new InvalidParameterException("MpRSA: initDecrypt - Please use larger modulus!");
        }
    }

    private void initParams(RSAOAEPParameterSpec paramSpec) {
        byte[] paramBytes;
        String mdOID = paramSpec.getMD();
        try {
            this.md = Registry.getMessageDigest(mdOID);
            RSAOAEPParameters params = new RSAOAEPParameters();
            ((AlgorithmParameters)params).init(paramSpec);
            paramBytes = ((AlgorithmParameters)params).getEncoded();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("did not find message digest '" + mdOID + "'");
        }
        catch (InvalidParameterSpecException e) {
            throw new RuntimeException("internal error");
        }
        catch (IOException e) {
            throw new RuntimeException("internal error");
        }
        this.md.update(paramBytes);
    }

    protected byte[] messageEncrypt(byte[] input) {
        byte[] C = null;
        byte[] EM = null;
        byte[] M = input;
        FlexiBigInt c = null;
        FlexiBigInt m = null;
        try {
            EM = PKCS1Operations.EME_OAEP_ENCODE(M, null, this.cipherTextSize, this.md, this.sr);
            m = PKCS1Operations.OS2IP(EM);
            c = MpRSAOperations.MpRSAEP(this.pubKey, m);
            C = PKCS1Operations.I2OSP(c, this.cipherTextSize);
        }
        catch (PKCS1Exception pkcs1e) {
            throw new RuntimeException("MpRSA: messageEncryptInternal error occured during PKCS#1 / RSASSA-OAEP encryption.");
        }
        return C;
    }

    protected byte[] messageDecrypt(byte[] input) {
        if (input.length != this.cipherTextSize) {
            throw new RuntimeException("MpRSA: messageDecrypt - decryption error");
        }
        if (this.cipherTextSize < (this.md.getDigestLength() << 1) + 2) {
            new RuntimeException("MpRSA: messageDecrypt - decryption error");
        }
        byte[] EM = null;
        byte[] M = null;
        FlexiBigInt c = PKCS1Operations.OS2IP(input);
        FlexiBigInt m = null;
        try {
            m = MpRSAOperations.MpRSADP(this.privKey, c);
            EM = PKCS1Operations.I2OSP(m, this.cipherTextSize);
            M = PKCS1Operations.EME_OAEP_DECODE(EM, null, this.cipherTextSize, this.md);
        }
        catch (PKCS1Exception ex) {
            throw new RuntimeException("MpRSA: PKCS1Exception - " + ex.getMessage());
        }
        return M;
    }
}

