/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.mprsa;

import de.flexiprovider.api.MessageDigest;
import de.flexiprovider.api.Registry;
import de.flexiprovider.api.SecureRandom;
import de.flexiprovider.api.Signature;
import de.flexiprovider.api.exceptions.InvalidAlgorithmParameterException;
import de.flexiprovider.api.exceptions.InvalidKeyException;
import de.flexiprovider.api.exceptions.NoSuchAlgorithmException;
import de.flexiprovider.api.exceptions.SignatureException;
import de.flexiprovider.api.keys.PrivateKey;
import de.flexiprovider.api.keys.PublicKey;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.common.math.FlexiBigInt;
import de.flexiprovider.core.mprsa.MpRSAOperations;
import de.flexiprovider.core.mprsa.MpRSAPrivateKey;
import de.flexiprovider.core.rsa.PKCS1Exception;
import de.flexiprovider.core.rsa.PKCS1Operations;
import de.flexiprovider.core.rsa.PSSParameterSpec;
import de.flexiprovider.core.rsa.interfaces.RSAPublicKey;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class MpRSASignaturePSS
extends Signature {
    private PSSParameterSpec params = new PSSParameterSpec();
    private MessageDigest md;
    SecureRandom random;
    private int cipherBlockSize;
    private int modBits;
    private RSAPublicKey pubKey;
    private MpRSAPrivateKey privKey;
    private ByteArrayOutputStream baos;

    protected final void engineSetParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        if (!(params instanceof PSSParameterSpec)) {
            throw new InvalidAlgorithmParameterException("params is not a PSSParameterSpec");
        }
        this.params = (PSSParameterSpec)params;
    }

    private void initCommon() throws InvalidKeyException {
        try {
            this.md = Registry.getMessageDigest(this.params.getMD());
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new InvalidKeyException("message digest SHA1 not found (key may be valid nonetheless).");
        }
        this.cipherBlockSize = this.modBits + 7 >> 3;
        this.baos = new ByteArrayOutputStream();
    }

    public void initSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        if (!(privateKey instanceof MpRSAPrivateKey)) {
            throw new InvalidKeyException("key is not an instance of MpRSAPrivateKey");
        }
        this.privKey = (MpRSAPrivateKey)privateKey;
        this.modBits = this.privKey.getN().bitLength();
        this.random = random != null ? random : Registry.getSecureRandom();
        this.initCommon();
    }

    public void initVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof RSAPublicKey)) {
            throw new InvalidKeyException("key is not an instance of RSAPublicKey");
        }
        this.pubKey = (RSAPublicKey)publicKey;
        this.modBits = this.pubKey.getN().bitLength();
        this.initCommon();
    }

    public void setParameters(AlgorithmParameterSpec params) {
    }

    public void update(byte b) {
        this.baos.write(b);
    }

    public void update(byte[] b, int offset, int length) {
        this.baos.write(b, offset, length);
    }

    private byte[] getMessage() throws IOException {
        byte[] msg = this.baos.toByteArray();
        this.baos.close();
        this.baos.reset();
        return msg;
    }

    public byte[] sign() throws SignatureException {
        FlexiBigInt s;
        byte[] EM;
        try {
            byte[] salt = new byte[this.params.getSaltLength()];
            this.random.nextBytes(salt);
            EM = PKCS1Operations.EMSA_PSS_ENCODE(this.getMessage(), this.modBits - 1, this.md, salt);
        }
        catch (PKCS1Exception pkcs1e) {
            throw new SignatureException(pkcs1e.getMessage());
        }
        catch (IOException ioe) {
            throw new SignatureException(ioe.getMessage());
        }
        FlexiBigInt m = PKCS1Operations.OS2IP(EM);
        try {
            s = MpRSAOperations.MpRSADP(this.privKey, m);
        }
        catch (PKCS1Exception pkcs1e) {
            throw new SignatureException("encoding error.");
        }
        try {
            return PKCS1Operations.I2OSP(s, this.modBits + 7 >> 3);
        }
        catch (PKCS1Exception pkcs1e) {
            throw new SignatureException("internal error.");
        }
    }

    public boolean verify(byte[] signature) {
        byte[] EM;
        if (signature.length != this.cipherBlockSize) {
            return false;
        }
        FlexiBigInt s = PKCS1Operations.OS2IP(signature);
        try {
            FlexiBigInt m = MpRSAOperations.MpRSAEP(this.pubKey, s);
            int emLen = this.modBits - 1 + 7 >> 3;
            EM = PKCS1Operations.I2OSP(m, emLen);
        }
        catch (PKCS1Exception pkcs1e) {
            return false;
        }
        try {
            return PKCS1Operations.EMSA_PSS_VERIFY(this.getMessage(), EM, this.modBits - 1, this.md);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe.getMessage());
        }
    }
}

