/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.pbe;

import de.flexiprovider.api.Registry;
import de.flexiprovider.api.SecureRandom;
import de.flexiprovider.api.exceptions.InvalidAlgorithmParameterException;
import de.flexiprovider.api.keys.SecretKey;
import de.flexiprovider.api.keys.SecretKeyGenerator;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.core.pbe.PBEKey;
import de.flexiprovider.core.pbe.PBEKeyGenParameterSpec;

public class PBEKeyGenerator
extends SecretKeyGenerator {
    private int keySize = 16;
    private SecureRandom random = null;
    private boolean initialized;

    public void init(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        PBEKeyGenParameterSpec pbeParams;
        if (params == null) {
            pbeParams = new PBEKeyGenParameterSpec();
        } else if (params instanceof PBEKeyGenParameterSpec) {
            pbeParams = (PBEKeyGenParameterSpec)params;
        } else {
            throw new InvalidAlgorithmParameterException("unsupported type");
        }
        this.keySize = pbeParams.getKeySize();
        this.random = random != null ? random : Registry.getSecureRandom();
        this.initialized = true;
    }

    public void init(int keySize, SecureRandom random) {
        PBEKeyGenParameterSpec params = new PBEKeyGenParameterSpec(keySize);
        try {
            this.init(params, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException("internal error");
        }
    }

    public void init(SecureRandom random) {
        PBEKeyGenParameterSpec defaultParams = new PBEKeyGenParameterSpec();
        try {
            this.init(defaultParams, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException("internal error");
        }
    }

    public SecretKey generateKey() {
        if (!this.initialized) {
            this.init(Registry.getSecureRandom());
        }
        byte[] out = new byte[this.keySize];
        char[] kchar = new char[this.keySize];
        this.random.nextBytes(out);
        int i = 0;
        while (i < this.keySize) {
            kchar[i] = (char)out[i];
            ++i;
        }
        return new PBEKey(kchar);
    }
}

