/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.pbe;

import de.flexiprovider.api.SecureRandom;
import de.flexiprovider.api.exceptions.InvalidAlgorithmParameterException;
import de.flexiprovider.api.exceptions.InvalidKeyException;
import de.flexiprovider.api.exceptions.InvalidKeySpecException;
import de.flexiprovider.api.exceptions.NoSuchPaddingException;
import de.flexiprovider.api.keys.Key;
import de.flexiprovider.api.keys.SecretKey;
import de.flexiprovider.api.keys.SecretKeyFactory;
import de.flexiprovider.api.keys.SecretKeySpec;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.common.mode.ModeParameterSpec;
import de.flexiprovider.core.kdf.PBKDF1_PKCS12;
import de.flexiprovider.core.kdf.PBKDF1_PKCS12ParameterSpec;
import de.flexiprovider.core.pbe.PBEKey;
import de.flexiprovider.core.pbe.PBEParameterSpec;
import de.flexiprovider.core.pbe.PBES1;
import de.flexiprovider.core.rc2.RC2;
import de.flexiprovider.core.rc2.RC2KeyFactory;

public class PBEWithSHAAnd40BitRC2_CBC
extends PBES1 {
    public static final String OID = "1.2.840.113549.1.12.1.6";
    private SecretKeyFactory rc2KeyFactory;

    public PBEWithSHAAnd40BitRC2_CBC() {
        this.cipher = new RC2.RC2_CBC();
        try {
            this.cipher.setPadding("PKCS5Padding");
        }
        catch (NoSuchPaddingException nspe) {
            throw new RuntimeException("internal error");
        }
        this.rc2KeyFactory = new RC2KeyFactory();
        this.kdf = new PBKDF1_PKCS12.SHA1();
    }

    public String getName() {
        return "PbeWithSHAAnd40BitRC2_CBC";
    }

    public int getKeySize(Key key) throws InvalidKeyException {
        if (key instanceof PBEKey) {
            return 40;
        }
        throw new InvalidKeyException("Unsupported key.");
    }

    public void initEncrypt(Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        SecretKey rc2Key;
        if (!(key instanceof PBEKey)) {
            throw new InvalidKeyException("unsupported type");
        }
        byte[] pbeKey = key.getEncoded();
        if (!(params instanceof PBEParameterSpec)) {
            throw new InvalidAlgorithmParameterException("unsupported type");
        }
        PBEParameterSpec pbeParamSpec = (PBEParameterSpec)params;
        byte[] salt = pbeParamSpec.getSalt();
        int iterationCount = pbeParamSpec.getIterationCount();
        PBKDF1_PKCS12ParameterSpec kdfParams = new PBKDF1_PKCS12ParameterSpec(salt, iterationCount, 1);
        this.kdf.init(pbeKey, kdfParams);
        byte[] rc2Bytes = this.kdf.deriveKey(5);
        SecretKeySpec rc2KeySpec = new SecretKeySpec(rc2Bytes, "RC2");
        try {
            rc2Key = this.rc2KeyFactory.generateSecret(rc2KeySpec);
        }
        catch (InvalidKeySpecException ikse) {
            throw new RuntimeException("internal error");
        }
        kdfParams = new PBKDF1_PKCS12ParameterSpec(salt, iterationCount, 2);
        this.kdf.init(pbeKey, kdfParams);
        byte[] ivBytes = this.kdf.deriveKey(8);
        ModeParameterSpec iv = new ModeParameterSpec(ivBytes);
        this.cipher.initEncrypt(rc2Key, iv, null, random);
    }

    public void initDecrypt(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        SecretKey rc2Key;
        if (!(key instanceof PBEKey)) {
            throw new InvalidKeyException("unsupported type");
        }
        byte[] pbeKey = key.getEncoded();
        if (!(params instanceof PBEParameterSpec)) {
            throw new InvalidAlgorithmParameterException("unsupported type");
        }
        PBEParameterSpec pbeParamSpec = (PBEParameterSpec)params;
        byte[] salt = pbeParamSpec.getSalt();
        int iterationCount = pbeParamSpec.getIterationCount();
        PBKDF1_PKCS12ParameterSpec kdfParams = new PBKDF1_PKCS12ParameterSpec(salt, iterationCount, 1);
        this.kdf.init(pbeKey, kdfParams);
        byte[] rc2Bytes = this.kdf.deriveKey(5);
        SecretKeySpec rc2KeySpec = new SecretKeySpec(rc2Bytes, "RC2");
        try {
            rc2Key = this.rc2KeyFactory.generateSecret(rc2KeySpec);
        }
        catch (InvalidKeySpecException ikse) {
            throw new RuntimeException("internal error");
        }
        kdfParams = new PBKDF1_PKCS12ParameterSpec(salt, iterationCount, 2);
        this.kdf.init(pbeKey, kdfParams);
        byte[] ivBytes = this.kdf.deriveKey(8);
        ModeParameterSpec iv = new ModeParameterSpec(ivBytes);
        this.cipher.initDecrypt(rc2Key, iv, null);
    }
}

