/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.rc2;

import de.flexiprovider.api.BlockCipher;
import de.flexiprovider.api.exceptions.InvalidKeyException;
import de.flexiprovider.api.exceptions.NoSuchModeException;
import de.flexiprovider.api.keys.Key;
import de.flexiprovider.api.keys.SecretKey;
import de.flexiprovider.api.keys.SecretKeySpec;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.core.rc2.RC2Key;

public class RC2
extends BlockCipher {
    private int suppliedKeysizeInBytes;
    private int effectiveKeyBits;
    private byte[] key = new byte[128];
    private int j;
    private short[] data = new short[4];
    private static final int blockSize = 8;
    private static final byte[] piTable = new byte[]{-39, 120, -7, -60, 25, -35, -75, -19, 40, -23, -3, 121, 74, -96, -40, -99, -58, 126, 55, -125, 43, 118, 83, -114, 98, 76, 100, -120, 68, -117, -5, -94, 23, -102, 89, -11, -121, -77, 79, 19, 97, 69, 109, -115, 9, -127, 125, 50, -67, -113, 64, -21, -122, -73, 123, 11, -16, -107, 33, 34, 92, 107, 78, -126, 84, -42, 101, -109, -50, 96, -78, 28, 115, 86, -64, 20, -89, -116, -15, -36, 18, 117, -54, 31, 59, -66, -28, -47, 66, 61, -44, 48, -93, 60, -74, 38, 111, -65, 14, -38, 70, 105, 7, 87, 39, -14, 29, -101, -68, -108, 67, 3, -8, 17, -57, -10, -112, -17, 62, -25, 6, -61, -43, 47, -56, 102, 30, -41, 8, -24, -22, -34, -128, 82, -18, -9, -124, -86, 114, -84, 53, 77, 106, 42, -106, 26, -46, 113, 90, 21, 73, 116, 75, -97, -48, 94, 4, 24, -92, -20, -62, -32, 65, 110, 15, 81, -53, -52, 36, -111, -81, 80, -95, -12, 112, 57, -103, 124, 58, -123, 35, -72, -76, 122, -4, 2, 54, 91, 37, 85, -105, 49, 45, 93, -6, -104, -29, -118, -110, -82, 5, -33, 41, 16, 103, 108, -70, -55, -45, 0, -26, -49, -31, -98, -88, 44, 99, 22, 1, 63, 88, -30, -119, -87, 13, 56, 52, 27, -85, 51, -1, -80, -69, 72, 12, 95, -71, -79, -51, 46, -59, -13, -37, 71, -27, -91, -100, 119, 10, -90, 32, 104, -2, 127, -63, -83};

    public String getName() {
        return "RC2";
    }

    public int getKeySize(Key key) throws InvalidKeyException {
        if (!(key instanceof RC2Key) && !(key instanceof SecretKeySpec)) {
            throw new InvalidKeyException("Not a RC2 Key");
        }
        return key.getEncoded().length << 3;
    }

    public int getCipherBlockSize() {
        return 8;
    }

    protected void initCipherEncrypt(SecretKey key, AlgorithmParameterSpec params) throws InvalidKeyException {
        if (!(key instanceof RC2Key)) {
            throw new InvalidKeyException("Not a RC2 Key");
        }
        byte[] encodedKey = key.getEncoded();
        this.suppliedKeysizeInBytes = encodedKey.length;
        this.effectiveKeyBits = 8 * this.suppliedKeysizeInBytes;
        this.keySchedule(encodedKey);
    }

    protected void initCipherDecrypt(SecretKey key, AlgorithmParameterSpec params) throws InvalidKeyException {
        this.initCipherEncrypt(key, params);
    }

    private void keySchedule(byte[] userKey) {
        int keysizeInBytes = this.effectiveKeyBits + 7 >> 3;
        int keyMask = 255 >>> 8 * keysizeInBytes - this.effectiveKeyBits;
        int i = 0;
        while (i < this.suppliedKeysizeInBytes) {
            this.key[i] = userKey[i];
            ++i;
        }
        i = this.suppliedKeysizeInBytes;
        while (i <= 127) {
            this.key[i] = piTable[this.key[i - 1] + this.key[i - this.suppliedKeysizeInBytes] & 0xFF];
            ++i;
        }
        this.key[128 - keysizeInBytes] = piTable[this.key[128 - keysizeInBytes] & keyMask];
        i = 127 - keysizeInBytes;
        while (i >= 0) {
            this.key[i] = piTable[(this.key[i + 1] ^ this.key[i + keysizeInBytes]) & 0xFF];
            --i;
        }
    }

    protected void singleBlockEncrypt(byte[] in, int inOffset, byte[] out, int outOffset) {
        this.data[0] = this.bytesToShort(in, inOffset);
        this.data[1] = this.bytesToShort(in, inOffset + 2);
        this.data[2] = this.bytesToShort(in, inOffset + 4);
        this.data[3] = this.bytesToShort(in, inOffset + 6);
        this.j = 0;
        this.mix();
        this.mix();
        this.mix();
        this.mix();
        this.mix();
        this.mash();
        this.mix();
        this.mix();
        this.mix();
        this.mix();
        this.mix();
        this.mix();
        this.mash();
        this.mix();
        this.mix();
        this.mix();
        this.mix();
        this.mix();
        this.shortToBytes(out, outOffset, this.data[0]);
        this.shortToBytes(out, outOffset + 2, this.data[1]);
        this.shortToBytes(out, outOffset + 4, this.data[2]);
        this.shortToBytes(out, outOffset + 6, this.data[3]);
    }

    protected void singleBlockDecrypt(byte[] in, int inOffset, byte[] out, int outOffset) {
        this.data[0] = this.bytesToShort(in, inOffset);
        this.data[1] = this.bytesToShort(in, inOffset + 2);
        this.data[2] = this.bytesToShort(in, inOffset + 4);
        this.data[3] = this.bytesToShort(in, inOffset + 6);
        this.j = 63;
        this.demix();
        this.demix();
        this.demix();
        this.demix();
        this.demix();
        this.demash();
        this.demix();
        this.demix();
        this.demix();
        this.demix();
        this.demix();
        this.demix();
        this.demash();
        this.demix();
        this.demix();
        this.demix();
        this.demix();
        this.demix();
        this.shortToBytes(out, outOffset, this.data[0]);
        this.shortToBytes(out, outOffset + 2, this.data[1]);
        this.shortToBytes(out, outOffset + 4, this.data[2]);
        this.shortToBytes(out, outOffset + 6, this.data[3]);
    }

    private void mix() {
        this.data[0] = (short)(this.data[0] + (this.keyWord(this.j++) + (this.data[3] & this.data[2]) + (~this.data[3] & this.data[1])));
        this.data[0] = this.rotateLeft(this.data[0], 1);
        this.data[1] = (short)(this.data[1] + (this.keyWord(this.j++) + (this.data[0] & this.data[3]) + (~this.data[0] & this.data[2])));
        this.data[1] = this.rotateLeft(this.data[1], 2);
        this.data[2] = (short)(this.data[2] + (this.keyWord(this.j++) + (this.data[1] & this.data[0]) + (~this.data[1] & this.data[3])));
        this.data[2] = this.rotateLeft(this.data[2], 3);
        this.data[3] = (short)(this.data[3] + (this.keyWord(this.j++) + (this.data[2] & this.data[1]) + (~this.data[2] & this.data[0])));
        this.data[3] = this.rotateLeft(this.data[3], 5);
    }

    private void mash() {
        this.data[0] = (short)(this.data[0] + this.keyWord(this.data[3] & 0x3F));
        this.data[1] = (short)(this.data[1] + this.keyWord(this.data[0] & 0x3F));
        this.data[2] = (short)(this.data[2] + this.keyWord(this.data[1] & 0x3F));
        this.data[3] = (short)(this.data[3] + this.keyWord(this.data[2] & 0x3F));
    }

    private void demix() {
        this.data[3] = this.rotateRight(this.data[3], 5);
        this.data[3] = (short)(this.data[3] - this.keyWord(this.j--) - (this.data[2] & this.data[1]) - (~this.data[2] & this.data[0]));
        this.data[2] = this.rotateRight(this.data[2], 3);
        this.data[2] = (short)(this.data[2] - this.keyWord(this.j--) - (this.data[1] & this.data[0]) - (~this.data[1] & this.data[3]));
        this.data[1] = this.rotateRight(this.data[1], 2);
        this.data[1] = (short)(this.data[1] - this.keyWord(this.j--) - (this.data[0] & this.data[3]) - (~this.data[0] & this.data[2]));
        this.data[0] = this.rotateRight(this.data[0], 1);
        this.data[0] = (short)(this.data[0] - this.keyWord(this.j--) - (this.data[3] & this.data[2]) - (~this.data[3] & this.data[1]));
    }

    private void demash() {
        this.data[3] = (short)(this.data[3] - this.keyWord(this.data[2] & 0x3F));
        this.data[2] = (short)(this.data[2] - this.keyWord(this.data[1] & 0x3F));
        this.data[1] = (short)(this.data[1] - this.keyWord(this.data[0] & 0x3F));
        this.data[0] = (short)(this.data[0] - this.keyWord(this.data[3] & 0x3F));
    }

    private short keyWord(int index) {
        return (short)((this.key[index << 1] & 0xFF) + (short)(this.key[(index << 1) + 1] << 8));
    }

    private short rotateLeft(short x, int n) {
        return (short)(x << n | (x & 0xFFFF) >>> 16 - n);
    }

    private short rotateRight(short x, int n) {
        return (short)((x & 0xFFFF) >>> n | x << 16 - n);
    }

    private void shortToBytes(byte[] bytes, int offset, short value) {
        bytes[offset] = (byte)(value & 0xFF);
        bytes[offset + 1] = (byte)(value >>> 8 & 0xFF);
    }

    private short bytesToShort(byte[] bytes, int offset) {
        short value = 0;
        value = (short)(value | bytes[offset] & 0xFF);
        value = (short)(value | bytes[offset + 1] << 8 & 0xFF00);
        return value;
    }

    public static class RC2_CBC
    extends RC2 {
        public static final String OID = "1.2.840.113549.3.2";

        public RC2_CBC() {
            try {
                this.setMode("CBC");
            }
            catch (NoSuchModeException e) {
                throw new RuntimeException("Internal error: could not find mode 'CBC'.");
            }
        }
    }
}

