/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.rc2;

import de.flexiprovider.api.keys.SecretKey;
import de.flexiprovider.common.util.ByteUtils;

public class RC2Key
implements SecretKey {
    private byte[] keyBytes;

    protected RC2Key(byte[] keyBytes) {
        this.keyBytes = ByteUtils.clone(keyBytes);
    }

    public String getAlgorithm() {
        return "RC2";
    }

    public String getFormat() {
        return "RAW";
    }

    public byte[] getEncoded() {
        return ByteUtils.clone(this.keyBytes);
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof RC2Key)) {
            return false;
        }
        RC2Key otherKey = (RC2Key)other;
        return ByteUtils.equals(this.keyBytes, otherKey.keyBytes);
    }

    public int hashCode() {
        int result = 1;
        int i = 0;
        while (i < this.keyBytes.length) {
            result = 31 * result + this.keyBytes[i];
            ++i;
        }
        return result;
    }
}

