/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.rc5;

import de.flexiprovider.api.BlockCipher;
import de.flexiprovider.api.exceptions.InvalidAlgorithmParameterException;
import de.flexiprovider.api.exceptions.InvalidKeyException;
import de.flexiprovider.api.keys.Key;
import de.flexiprovider.api.keys.SecretKey;
import de.flexiprovider.api.keys.SecretKeySpec;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.core.rc5.RC5Key;
import de.flexiprovider.core.rc5.RC5ParameterSpec;

public class RC5
extends BlockCipher {
    private int wordSize;
    private int wordSizeInBytes;
    private int numRounds = 0;
    private int keySize;
    private long moduloMask;
    private long P;
    private long Q;
    private long[] roundKey;
    private static final long P16 = 47073L;
    private static final long Q16 = 40503L;
    private static final long P32 = -1209970333L;
    private static final long Q32 = -1640531527L;
    private static final long P64 = -5196783011329398165L;
    private static final long Q64 = -7046029254386353131L;

    public String getName() {
        return "RC5";
    }

    public int getKeySize(Key key) throws InvalidKeyException {
        if (!(key instanceof RC5Key) && !(key instanceof SecretKeySpec)) {
            throw new InvalidKeyException("Not a RC5 Key");
        }
        return key.getEncoded().length << 3;
    }

    public int getCipherBlockSize() throws IllegalStateException {
        return this.wordSizeInBytes << 1;
    }

    protected void initCipherEncrypt(SecretKey key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (!(key instanceof RC5Key)) {
            throw new InvalidKeyException("unsupported type");
        }
        if (params == null) {
            this.extractParameters(new RC5ParameterSpec());
        } else {
            if (!(params instanceof RC5ParameterSpec)) {
                throw new InvalidAlgorithmParameterException("unsupported type");
            }
            this.extractParameters((RC5ParameterSpec)params);
        }
        byte[] encodedKey = key.getEncoded();
        this.keySize = encodedKey.length;
        this.keySchedule(encodedKey);
    }

    protected void initCipherDecrypt(SecretKey key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.initCipherEncrypt(key, params);
    }

    private void keySchedule(byte[] key) {
        int u = this.wordSizeInBytes;
        int c = (int)Math.ceil((double)this.keySize / (double)u);
        long[] L = new long[c];
        this.roundKey = new long[Math.max((this.numRounds << 1) + 2, 4)];
        this.roundKey[0] = this.P;
        int j = this.keySize;
        while (j <= c * u - 1) {
            this.roundKey[j] = 0L;
            ++j;
        }
        int i = 0;
        while (i <= c - 1) {
            L[i] = 0L;
            j = 0;
            while (j <= u - 1) {
                if (i * u + j < this.keySize) {
                    int n = i;
                    L[n] = L[n] + (((long)key[i * u + j] & 0xFFL) << 8 * j);
                }
                ++j;
            }
            ++i;
        }
        i = 1;
        while (i <= (this.numRounds << 1) + 1) {
            this.roundKey[i] = this.roundKey[i - 1] + this.Q & this.moduloMask;
            ++i;
        }
        i = 0;
        j = 0;
        long A = 0L;
        long B = 0L;
        int t = Math.max(c, (this.numRounds << 1) + 2);
        int s = 1;
        while (s <= 3 * t) {
            this.roundKey[i] = this.rotateLeft(this.roundKey[i] + A + B & this.moduloMask, 3L);
            A = this.roundKey[i];
            i = (i + 1) % ((this.numRounds << 1) + 2);
            L[j] = this.rotateLeft(L[j] + A + B & this.moduloMask, A + B & this.moduloMask);
            B = L[j];
            j = (j + 1) % c;
            ++s;
        }
        u = 0;
        c = 0;
        L = null;
        A = 0L;
        B = 0L;
        t = 0;
        s = 0;
    }

    protected void singleBlockEncrypt(byte[] in, int inOffset, byte[] out, int outOffset) {
        long A = this.bytesToLong(in, inOffset, this.wordSizeInBytes);
        long B = this.bytesToLong(in, inOffset + this.wordSizeInBytes, this.wordSizeInBytes);
        A = A + this.roundKey[0] & this.moduloMask;
        B = B + this.roundKey[1] & this.moduloMask;
        int i = 1;
        while (i <= this.numRounds) {
            A = this.rotateLeft(A ^ B, B) + this.roundKey[i << 1] & this.moduloMask;
            B = this.rotateLeft(A ^ B, A) + this.roundKey[(i << 1) + 1] & this.moduloMask;
            ++i;
        }
        this.longToBytes(out, outOffset, A, this.wordSizeInBytes);
        this.longToBytes(out, outOffset + this.wordSizeInBytes, B, this.wordSizeInBytes);
    }

    protected void singleBlockDecrypt(byte[] in, int inOffset, byte[] out, int outOffset) {
        long A = this.bytesToLong(in, inOffset, this.wordSizeInBytes);
        long B = this.bytesToLong(in, inOffset + this.wordSizeInBytes, this.wordSizeInBytes);
        int i = this.numRounds;
        while (i >= 1) {
            B = this.rotateRight(B - this.roundKey[(i << 1) + 1] & this.moduloMask, A) ^ A;
            A = this.rotateRight(A - this.roundKey[i << 1] & this.moduloMask, B) ^ B;
            --i;
        }
        A = A - this.roundKey[0] & this.moduloMask;
        B = B - this.roundKey[1] & this.moduloMask;
        this.longToBytes(out, outOffset, A, this.wordSizeInBytes);
        this.longToBytes(out, outOffset + this.wordSizeInBytes, B, this.wordSizeInBytes);
    }

    private void extractParameters(RC5ParameterSpec params) {
        this.numRounds = params.getNumRounds();
        this.wordSize = params.getWordSize();
        switch (this.wordSize) {
            case 16: {
                this.P = 47073L;
                this.Q = 40503L;
                break;
            }
            case 32: {
                this.P = -1209970333L;
                this.Q = -1640531527L;
                break;
            }
            case 64: {
                this.P = -5196783011329398165L;
                this.Q = -7046029254386353131L;
                break;
            }
        }
        this.wordSizeInBytes = this.wordSize >> 3;
        this.moduloMask = -1L >>> 64 - this.wordSize;
    }

    private long rotateLeft(long x, long n) {
        return (x << (int)(n %= (long)this.wordSize) | x >>> (int)((long)this.wordSize - n)) & this.moduloMask;
    }

    private long rotateRight(long x, long n) {
        return (x >>> (int)(n %= (long)this.wordSize) | x << (int)((long)this.wordSize - n)) & this.moduloMask;
    }

    private void longToBytes(byte[] bytes, int offset, long value, int numberOfBytes) {
        int i = 0;
        while (i < numberOfBytes) {
            bytes[offset + i] = (byte)(value >>> (i << 3) & 0xFFL);
            ++i;
        }
    }

    private long bytesToLong(byte[] bytes, int offset, int numberOfBytes) {
        long value = 0L;
        int i = 0;
        while (i < numberOfBytes) {
            value |= ((long)bytes[offset + i] & 0xFFL) << (i << 3);
            ++i;
        }
        return value;
    }
}

