/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.rc5;

import de.flexiprovider.api.keys.SecretKey;
import de.flexiprovider.common.util.ByteUtils;

public class RC5Key
implements SecretKey {
    private byte[] keyBytes;

    protected RC5Key(byte[] keyBytes) {
        this.keyBytes = ByteUtils.clone(keyBytes);
    }

    public String getAlgorithm() {
        return "RC5";
    }

    public String getFormat() {
        return "RAW";
    }

    public byte[] getEncoded() {
        return ByteUtils.clone(this.keyBytes);
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof RC5Key)) {
            return false;
        }
        return ByteUtils.equals(this.keyBytes, ((RC5Key)other).keyBytes);
    }

    public int hashCode() {
        int result = 1;
        int i = 0;
        while (i < this.keyBytes.length) {
            result = 31 * result + this.keyBytes[i];
            ++i;
        }
        return result;
    }
}

