/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.rc5;

import de.flexiprovider.api.exceptions.InvalidKeyException;
import de.flexiprovider.api.exceptions.InvalidKeySpecException;
import de.flexiprovider.api.keys.KeySpec;
import de.flexiprovider.api.keys.SecretKey;
import de.flexiprovider.api.keys.SecretKeyFactory;
import de.flexiprovider.api.keys.SecretKeySpec;
import de.flexiprovider.core.rc5.RC5Key;

public class RC5KeyFactory
extends SecretKeyFactory {
    static /* synthetic */ Class class$de$flexiprovider$api$keys$SecretKeySpec;

    public SecretKey generateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec == null) {
            throw new InvalidKeySpecException("key spec is null");
        }
        if (keySpec instanceof SecretKeySpec) {
            SecretKeySpec secKeySpec = (SecretKeySpec)keySpec;
            if (!secKeySpec.getAlgorithm().equals("RC5")) {
                throw new InvalidKeySpecException("unsupported type");
            }
            return new RC5Key(secKeySpec.getEncoded());
        }
        throw new InvalidKeySpecException("unsupported type");
    }

    public KeySpec getKeySpec(SecretKey key, Class keySpec) throws InvalidKeySpecException {
        if (keySpec == null || !keySpec.isAssignableFrom(class$de$flexiprovider$api$keys$SecretKeySpec == null ? (class$de$flexiprovider$api$keys$SecretKeySpec = RC5KeyFactory.class$("de.flexiprovider.api.keys.SecretKeySpec")) : class$de$flexiprovider$api$keys$SecretKeySpec)) {
            throw new InvalidKeySpecException("wrong spec type");
        }
        if (key == null || !(key instanceof RC5Key)) {
            throw new InvalidKeySpecException("wrong key type");
        }
        return new SecretKeySpec(key.getEncoded(), "RC5");
    }

    public SecretKey translateKey(SecretKey key) throws InvalidKeyException {
        if (key.getAlgorithm() != "RC5") {
            throw new InvalidKeyException("unsupported type");
        }
        return new RC5Key(key.getEncoded());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

