/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.rc5;

import codec.asn1.ASN1Choice;
import codec.asn1.ASN1Exception;
import codec.asn1.ASN1Integer;
import codec.asn1.ASN1Null;
import codec.asn1.ASN1OctetString;
import codec.asn1.ASN1Sequence;
import codec.asn1.ASN1Type;
import de.flexiprovider.api.exceptions.InvalidParameterSpecException;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.api.parameters.AlgorithmParameters;
import de.flexiprovider.common.mode.ModeParameterSpec;
import de.flexiprovider.common.util.ASN1Tools;
import de.flexiprovider.common.util.ByteUtils;
import de.flexiprovider.core.rc5.RC5ParameterSpec;
import java.io.IOException;

public class RC5Parameters
extends AlgorithmParameters {
    private int version;
    private int rounds;
    private int blockSize;
    private byte[] iv;
    static /* synthetic */ Class class$de$flexiprovider$core$rc5$RC5ParameterSpec;

    public void init(AlgorithmParameterSpec params) throws InvalidParameterSpecException {
        if (params == null || !(params instanceof RC5ParameterSpec)) {
            throw new InvalidParameterSpecException("unsupported type");
        }
        RC5ParameterSpec rc5Params = (RC5ParameterSpec)params;
        this.version = rc5Params.getVersion();
        this.rounds = rc5Params.getNumRounds();
        this.blockSize = rc5Params.getWordSize();
        this.iv = rc5Params.getIV();
    }

    public void init(byte[] encParams) throws IOException {
        ASN1Sequence params = new ASN1Sequence(2);
        params.add(new ASN1Integer());
        params.add(new ASN1Integer());
        params.add(new ASN1Integer());
        ASN1Choice ivChoice = new ASN1Choice();
        ivChoice.addType((ASN1Type)new ASN1Null());
        ivChoice.addType((ASN1Type)new ASN1OctetString());
        params.add(ivChoice);
        try {
            ASN1Tools.derDecode(encParams, (ASN1Type)params);
        }
        catch (ASN1Exception e) {
            throw new IOException("bad encoding");
        }
        this.version = ASN1Tools.getFlexiBigInt((ASN1Integer)params.get(0)).intValue();
        this.rounds = ASN1Tools.getFlexiBigInt((ASN1Integer)params.get(1)).intValue();
        this.blockSize = ASN1Tools.getFlexiBigInt((ASN1Integer)params.get(2)).intValue();
        ASN1Type ivType = ((ASN1Choice)params.get(3)).getInnerType();
        this.iv = (byte[])(ivType instanceof ASN1Null ? null : ((ASN1OctetString)ivType).getByteArray());
    }

    public void init(byte[] encParams, String format) throws IOException {
        if (!format.equals("ASN.1")) {
            throw new IOException("unsupported format");
        }
        this.init(encParams);
    }

    public byte[] getEncoded() {
        ASN1Sequence params = new ASN1Sequence(4);
        params.add(new ASN1Integer(this.version));
        params.add(new ASN1Integer(this.rounds));
        params.add(new ASN1Integer(this.blockSize));
        if (this.iv == null) {
            params.add(new ASN1Null());
        } else {
            params.add(new ASN1OctetString(this.iv));
        }
        return ASN1Tools.derEncode((ASN1Type)params);
    }

    public byte[] getEncoded(String format) throws IOException {
        if (!format.equals("ASN.1")) {
            throw new IOException("unsupported format");
        }
        return this.getEncoded();
    }

    public AlgorithmParameterSpec getParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
        if (!paramSpec.isAssignableFrom(class$de$flexiprovider$core$rc5$RC5ParameterSpec == null ? (class$de$flexiprovider$core$rc5$RC5ParameterSpec = RC5Parameters.class$("de.flexiprovider.core.rc5.RC5ParameterSpec")) : class$de$flexiprovider$core$rc5$RC5ParameterSpec)) {
            throw new InvalidParameterSpecException("unsupported type");
        }
        if (this.iv == null) {
            return new RC5ParameterSpec(this.rounds, this.blockSize);
        }
        return new RC5ParameterSpec(this.rounds, this.blockSize, new ModeParameterSpec(this.iv));
    }

    public String toString() {
        String result = "RC5 Parameters:\n";
        result = result + "  version   : " + this.version + "\n";
        result = result + "  rounds    : " + this.rounds + "\n";
        result = result + "  block size: " + this.blockSize + " bits\n";
        result = result + "  IV        : ";
        result = this.iv == null ? result + "null\n" : result + ByteUtils.toHexString(this.iv) + "\n";
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

