/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.rijndael;

import de.flexiprovider.api.keys.SecretKey;
import de.flexiprovider.common.util.ByteUtils;

public class RijndaelKey
implements SecretKey {
    private byte[] keyBytes;

    protected RijndaelKey(byte[] keyBytes) {
        this.keyBytes = ByteUtils.clone(keyBytes);
    }

    public String getAlgorithm() {
        return "Rijndael";
    }

    public String getFormat() {
        return "RAW";
    }

    public byte[] getEncoded() {
        return ByteUtils.clone(this.keyBytes);
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof RijndaelKey)) {
            return false;
        }
        return ByteUtils.equals(this.keyBytes, ((RijndaelKey)other).keyBytes);
    }

    public int hashCode() {
        int result = 1;
        int i = 0;
        while (i < this.keyBytes.length) {
            result = 31 * result + this.keyBytes[i];
            ++i;
        }
        return result;
    }
}

