/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.rijndael;

import de.flexiprovider.api.exceptions.InvalidKeyException;
import de.flexiprovider.api.exceptions.InvalidKeySpecException;
import de.flexiprovider.api.keys.KeySpec;
import de.flexiprovider.api.keys.SecretKey;
import de.flexiprovider.api.keys.SecretKeyFactory;
import de.flexiprovider.api.keys.SecretKeySpec;
import de.flexiprovider.core.rijndael.RijndaelKey;

public final class RijndaelKeyFactory
extends SecretKeyFactory {
    static /* synthetic */ Class class$de$flexiprovider$api$keys$SecretKeySpec;

    public SecretKey generateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec == null) {
            throw new InvalidKeySpecException("key spec is null");
        }
        if (keySpec instanceof SecretKeySpec) {
            SecretKeySpec secKeySpec = (SecretKeySpec)keySpec;
            String algorithm = secKeySpec.getAlgorithm();
            if (!algorithm.equals("Rijndael") && !algorithm.startsWith("AES")) {
                throw new InvalidKeySpecException("unsupported type");
            }
            return new RijndaelKey(secKeySpec.getEncoded());
        }
        throw new InvalidKeySpecException("unsupported type");
    }

    public KeySpec getKeySpec(SecretKey key, Class keySpec) throws InvalidKeySpecException {
        if (keySpec == null || !keySpec.isAssignableFrom(class$de$flexiprovider$api$keys$SecretKeySpec == null ? (class$de$flexiprovider$api$keys$SecretKeySpec = RijndaelKeyFactory.class$("de.flexiprovider.api.keys.SecretKeySpec")) : class$de$flexiprovider$api$keys$SecretKeySpec)) {
            throw new InvalidKeySpecException("wrong spec type");
        }
        if (key == null || !(key instanceof RijndaelKey)) {
            throw new InvalidKeySpecException("wrong key type");
        }
        return new SecretKeySpec(key.getEncoded(), "Rijndael");
    }

    public SecretKey translateKey(SecretKey key) throws InvalidKeyException {
        throw new InvalidKeyException("not implemented");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

