/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.rijndael;

import de.flexiprovider.api.Registry;
import de.flexiprovider.api.SecureRandom;
import de.flexiprovider.api.exceptions.InvalidAlgorithmParameterException;
import de.flexiprovider.api.keys.SecretKey;
import de.flexiprovider.api.keys.SecretKeyGenerator;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.core.rijndael.RijndaelKey;
import de.flexiprovider.core.rijndael.RijndaelKeyGenParameterSpec;

public class RijndaelKeyGenerator
extends SecretKeyGenerator {
    private int keySize;
    private SecureRandom random;
    private boolean initialized;

    public void init(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        RijndaelKeyGenParameterSpec rijndaelParams;
        if (params == null) {
            rijndaelParams = new RijndaelKeyGenParameterSpec();
        } else if (params instanceof RijndaelKeyGenParameterSpec) {
            rijndaelParams = (RijndaelKeyGenParameterSpec)params;
        } else {
            throw new InvalidAlgorithmParameterException("unsupported type");
        }
        this.keySize = rijndaelParams.getKeySize() >> 3;
        this.random = random != null ? random : Registry.getSecureRandom();
        this.initialized = true;
    }

    public void init(int keySize, SecureRandom random) {
        RijndaelKeyGenParameterSpec params = new RijndaelKeyGenParameterSpec(keySize);
        try {
            this.init(params, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException("internal error");
        }
    }

    public void init(SecureRandom random) {
        RijndaelKeyGenParameterSpec defaultParams = new RijndaelKeyGenParameterSpec();
        try {
            this.init(defaultParams, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException("internal error");
        }
    }

    public SecretKey generateKey() {
        if (!this.initialized) {
            this.init(Registry.getSecureRandom());
        }
        byte[] keyBytes = new byte[this.keySize];
        this.random.nextBytes(keyBytes);
        return new RijndaelKey(keyBytes);
    }
}

