/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.rijndael;

import codec.asn1.ASN1Choice;
import codec.asn1.ASN1Exception;
import codec.asn1.ASN1Integer;
import codec.asn1.ASN1Null;
import codec.asn1.ASN1OctetString;
import codec.asn1.ASN1Sequence;
import codec.asn1.ASN1Type;
import de.flexiprovider.api.exceptions.InvalidParameterSpecException;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.api.parameters.AlgorithmParameters;
import de.flexiprovider.common.mode.ModeParameterSpec;
import de.flexiprovider.common.util.ASN1Tools;
import de.flexiprovider.common.util.ByteUtils;
import de.flexiprovider.core.rijndael.RijndaelParameterSpec;
import java.io.IOException;

public class RijndaelParameters
extends AlgorithmParameters {
    private int blockSize;
    private byte[] iv;
    static /* synthetic */ Class class$de$flexiprovider$core$rijndael$RijndaelParameterSpec;

    public void init(AlgorithmParameterSpec params) throws InvalidParameterSpecException {
        if (params == null || !(params instanceof RijndaelParameterSpec)) {
            throw new InvalidParameterSpecException("unsupported type");
        }
        this.blockSize = ((RijndaelParameterSpec)params).getBlockSize();
        this.iv = ((RijndaelParameterSpec)params).getIV();
    }

    public void init(byte[] encParams) throws IOException {
        ASN1Sequence params = new ASN1Sequence(2);
        params.add(new ASN1Integer());
        ASN1Choice ivChoice = new ASN1Choice();
        ivChoice.addType((ASN1Type)new ASN1Null());
        ivChoice.addType((ASN1Type)new ASN1OctetString());
        params.add(ivChoice);
        try {
            ASN1Tools.derDecode(encParams, (ASN1Type)params);
        }
        catch (ASN1Exception e) {
            throw new IOException("bad encoding");
        }
        this.blockSize = ASN1Tools.getFlexiBigInt((ASN1Integer)params.get(0)).intValue();
        ASN1Type ivType = ((ASN1Choice)params.get(1)).getInnerType();
        this.iv = (byte[])(ivType instanceof ASN1Null ? null : ((ASN1OctetString)ivType).getByteArray());
    }

    public void init(byte[] encParams, String format) throws IOException {
        if (!format.equals("ASN.1")) {
            throw new IOException("unsupported format");
        }
        this.init(encParams);
    }

    public byte[] getEncoded() {
        ASN1Sequence params = new ASN1Sequence(2);
        params.add(new ASN1Integer(this.blockSize));
        if (this.iv == null) {
            params.add(new ASN1Null());
        } else {
            params.add(new ASN1OctetString(this.iv));
        }
        return ASN1Tools.derEncode((ASN1Type)params);
    }

    public byte[] getEncoded(String format) throws IOException {
        if (!format.equals("ASN.1")) {
            throw new IOException("unsupported format");
        }
        return this.getEncoded();
    }

    public AlgorithmParameterSpec getParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
        if (!(class$de$flexiprovider$core$rijndael$RijndaelParameterSpec == null ? (class$de$flexiprovider$core$rijndael$RijndaelParameterSpec = RijndaelParameters.class$("de.flexiprovider.core.rijndael.RijndaelParameterSpec")) : class$de$flexiprovider$core$rijndael$RijndaelParameterSpec).isAssignableFrom(paramSpec)) {
            throw new InvalidParameterSpecException("unsupported type");
        }
        if (this.iv == null) {
            return new RijndaelParameterSpec(this.blockSize);
        }
        return new RijndaelParameterSpec(this.blockSize, new ModeParameterSpec(this.iv));
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("RijndaelParameters (block size " + this.blockSize + ")");
        buf.append("(IV " + ByteUtils.toHexString(this.iv) + ")");
        return buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

